/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3;

import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPreviewApi;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.transfer.s3.TransferRequest;
import software.amazon.awssdk.transfer.s3.UploadDirectoryOverrideConfiguration;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkPublicApi
@SdkPreviewApi
public final class UploadDirectoryRequest
implements TransferRequest,
ToCopyableBuilder<Builder, UploadDirectoryRequest> {
    private final Path sourceDirectory;
    private final String bucket;
    private final String prefix;
    private final UploadDirectoryOverrideConfiguration overrideConfiguration;
    private final String delimiter;

    public UploadDirectoryRequest(DefaultBuilder builder) {
        this.sourceDirectory = (Path)Validate.paramNotNull((Object)builder.sourceDirectory, (String)"sourceDirectory");
        this.bucket = (String)Validate.paramNotNull((Object)builder.bucket, (String)"bucket");
        this.prefix = builder.prefix;
        this.overrideConfiguration = builder.configuration;
        this.delimiter = builder.delimiter;
    }

    public Path sourceDirectory() {
        return this.sourceDirectory;
    }

    public String bucket() {
        return this.bucket;
    }

    public Optional<String> prefix() {
        return Optional.ofNullable(this.prefix);
    }

    public Optional<String> delimiter() {
        return Optional.ofNullable(this.delimiter);
    }

    public Optional<UploadDirectoryOverrideConfiguration> overrideConfiguration() {
        return Optional.ofNullable(this.overrideConfiguration);
    }

    public static Builder builder() {
        return new DefaultBuilder();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return DefaultBuilder.class;
    }

    public Builder toBuilder() {
        return new DefaultBuilder(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UploadDirectoryRequest that = (UploadDirectoryRequest)o;
        if (!this.sourceDirectory.equals(that.sourceDirectory)) {
            return false;
        }
        if (!this.bucket.equals(that.bucket)) {
            return false;
        }
        if (!Objects.equals(this.prefix, that.prefix)) {
            return false;
        }
        if (!Objects.equals(this.delimiter, that.delimiter)) {
            return false;
        }
        return Objects.equals(this.overrideConfiguration, that.overrideConfiguration);
    }

    public int hashCode() {
        int result = this.sourceDirectory.hashCode();
        result = 31 * result + this.bucket.hashCode();
        result = 31 * result + (this.prefix != null ? this.prefix.hashCode() : 0);
        result = 31 * result + (this.delimiter != null ? this.delimiter.hashCode() : 0);
        result = 31 * result + (this.overrideConfiguration != null ? this.overrideConfiguration.hashCode() : 0);
        return result;
    }

    private static final class DefaultBuilder
    implements Builder {
        private Path sourceDirectory;
        private String bucket;
        private String prefix;
        private UploadDirectoryOverrideConfiguration configuration;
        private String delimiter;

        private DefaultBuilder() {
        }

        private DefaultBuilder(UploadDirectoryRequest request) {
            this.sourceDirectory = request.sourceDirectory;
            this.bucket = request.bucket;
            this.prefix = request.prefix;
            this.configuration = request.overrideConfiguration;
        }

        @Override
        public Builder sourceDirectory(Path sourceDirectory) {
            this.sourceDirectory = sourceDirectory;
            return this;
        }

        public void setSourceDirectory(Path sourceDirectory) {
            this.sourceDirectory(sourceDirectory);
        }

        public Path getSourceDirectory() {
            return this.sourceDirectory;
        }

        @Override
        public Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public void setBucket(String bucket) {
            this.bucket(bucket);
        }

        public String getBucket() {
            return this.bucket;
        }

        @Override
        public Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public void setPrefix(String prefix) {
            this.prefix(prefix);
        }

        public String getPrefix() {
            return this.prefix;
        }

        @Override
        public Builder delimiter(String delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        public void setDelimiter(String delimiter) {
            this.delimiter(delimiter);
        }

        public String getDelimiter() {
            return this.delimiter;
        }

        @Override
        public Builder overrideConfiguration(UploadDirectoryOverrideConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public void setOverrideConfiguration(UploadDirectoryOverrideConfiguration configuration) {
            this.overrideConfiguration(configuration);
        }

        public UploadDirectoryOverrideConfiguration getOverrideConfiguration() {
            return this.configuration;
        }

        @Override
        public UploadDirectoryRequest build() {
            return new UploadDirectoryRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UploadDirectoryRequest> {
        public Builder sourceDirectory(Path var1);

        public Builder bucket(String var1);

        public Builder prefix(String var1);

        public Builder delimiter(String var1);

        public Builder overrideConfiguration(UploadDirectoryOverrideConfiguration var1);

        default public Builder overrideConfiguration(Consumer<UploadDirectoryOverrideConfiguration.Builder> uploadConfigurationBuilder) {
            Validate.paramNotNull(uploadConfigurationBuilder, (String)"uploadConfigurationBuilder");
            return this.overrideConfiguration(((UploadDirectoryOverrideConfiguration.Builder)UploadDirectoryOverrideConfiguration.builder().applyMutation(uploadConfigurationBuilder)).build());
        }

        public UploadDirectoryRequest build();
    }
}

