/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3;

import software.amazon.awssdk.annotations.SdkPreviewApi;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.transfer.s3.FailedFileTransfer;
import software.amazon.awssdk.transfer.s3.UploadRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkPublicApi
@SdkPreviewApi
public final class FailedFileUpload
implements FailedFileTransfer<UploadRequest>,
ToCopyableBuilder<Builder, FailedFileUpload> {
    private final Throwable exception;
    private final UploadRequest request;

    FailedFileUpload(DefaultBuilder builder) {
        this.exception = (Throwable)Validate.paramNotNull((Object)builder.exception, (String)"exception");
        this.request = (UploadRequest)Validate.paramNotNull((Object)builder.request, (String)"request");
    }

    @Override
    public Throwable exception() {
        return this.exception;
    }

    @Override
    public UploadRequest request() {
        return this.request;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FailedFileUpload that = (FailedFileUpload)o;
        if (!this.exception.equals(that.exception)) {
            return false;
        }
        return this.request.equals(that.request);
    }

    public int hashCode() {
        int result = this.exception.hashCode();
        result = 31 * result + this.request.hashCode();
        return result;
    }

    public String toString() {
        return ToString.builder((String)"FailedUpload").add("exception", (Object)this.exception).add("request", (Object)this.request).build();
    }

    public static Builder builder() {
        return new DefaultBuilder();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return DefaultBuilder.class;
    }

    public Builder toBuilder() {
        return new DefaultBuilder(this);
    }

    private static final class DefaultBuilder
    implements Builder {
        private UploadRequest request;
        private Throwable exception;

        private DefaultBuilder(FailedFileUpload failedSingleFileUpload) {
            this.request = failedSingleFileUpload.request;
            this.exception = failedSingleFileUpload.exception;
        }

        private DefaultBuilder() {
        }

        @Override
        public Builder exception(Throwable exception) {
            this.exception = exception;
            return this;
        }

        public void setException(Throwable exception) {
            this.exception(exception);
        }

        public Throwable getException() {
            return this.exception;
        }

        @Override
        public Builder request(UploadRequest request) {
            this.request = request;
            return this;
        }

        public void setRequest(UploadRequest request) {
            this.request(request);
        }

        public UploadRequest getRequest() {
            return this.request;
        }

        @Override
        public FailedFileUpload build() {
            return new FailedFileUpload(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, FailedFileUpload>,
    FailedFileTransfer.Builder<UploadRequest> {
        public Builder exception(Throwable var1);

        public Builder request(UploadRequest var1);

        public FailedFileUpload build();
    }
}

