/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPreviewApi;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.transfer.s3.Download;
import software.amazon.awssdk.transfer.s3.DownloadRequest;
import software.amazon.awssdk.transfer.s3.S3ClientConfiguration;
import software.amazon.awssdk.transfer.s3.Upload;
import software.amazon.awssdk.transfer.s3.UploadRequest;
import software.amazon.awssdk.transfer.s3.internal.DefaultS3TransferManager;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkPublicApi
@SdkPreviewApi
public interface S3TransferManager
extends SdkAutoCloseable {
    default public Download download(DownloadRequest downloadRequest) {
        throw new UnsupportedOperationException();
    }

    default public Download download(Consumer<DownloadRequest.Builder> request) {
        return this.download(((DownloadRequest.Builder)DownloadRequest.builder().applyMutation(request)).build());
    }

    default public Upload upload(UploadRequest uploadRequest) {
        throw new UnsupportedOperationException();
    }

    default public Upload upload(Consumer<UploadRequest.Builder> request) {
        return this.upload(((UploadRequest.Builder)UploadRequest.builder().applyMutation(request)).build());
    }

    public static S3TransferManager create() {
        return S3TransferManager.builder().build();
    }

    public static Builder builder() {
        return DefaultS3TransferManager.builder();
    }

    public static interface Builder {
        public Builder s3ClientConfiguration(S3ClientConfiguration var1);

        default public Builder s3ClientConfiguration(Consumer<S3ClientConfiguration.Builder> configuration) {
            S3ClientConfiguration.Builder builder = S3ClientConfiguration.builder();
            configuration.accept(builder);
            this.s3ClientConfiguration((S3ClientConfiguration)builder.build());
            return this;
        }

        public S3TransferManager build();
    }
}

