/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPreviewApi;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.core.client.config.ClientAsyncConfiguration;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkPublicApi
@SdkPreviewApi
public final class S3ClientConfiguration
implements ToCopyableBuilder<Builder, S3ClientConfiguration> {
    private final AwsCredentialsProvider credentialsProvider;
    private final Region region;
    private final Long minimumPartSizeInBytes;
    private final Double targetThroughputInGbps;
    private final Integer maxConcurrency;
    private final ClientAsyncConfiguration asyncConfiguration;

    private S3ClientConfiguration(DefaultBuilder builder) {
        this.credentialsProvider = builder.credentialsProvider;
        this.region = builder.region;
        this.minimumPartSizeInBytes = Validate.isPositiveOrNull((Long)builder.minimumPartSizeInBytes, (String)"minimumPartSizeInBytes");
        this.targetThroughputInGbps = Validate.isPositiveOrNull((Double)builder.targetThroughputInGbps, (String)"targetThroughputInGbps");
        this.maxConcurrency = Validate.isPositiveOrNull((Integer)builder.maxConcurrency, (String)"maxConcurrency");
        this.asyncConfiguration = builder.asyncConfiguration;
    }

    public Optional<AwsCredentialsProvider> credentialsProvider() {
        return Optional.ofNullable(this.credentialsProvider);
    }

    public Optional<Region> region() {
        return Optional.ofNullable(this.region);
    }

    public Optional<Long> minimumPartSizeInBytes() {
        return Optional.ofNullable(this.minimumPartSizeInBytes);
    }

    public Optional<Double> targetThroughputInGbps() {
        return Optional.ofNullable(this.targetThroughputInGbps);
    }

    public Optional<Integer> maxConcurrency() {
        return Optional.ofNullable(this.maxConcurrency);
    }

    public Optional<ClientAsyncConfiguration> asyncConfiguration() {
        return Optional.ofNullable(this.asyncConfiguration);
    }

    public Builder toBuilder() {
        return new DefaultBuilder(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        S3ClientConfiguration that = (S3ClientConfiguration)o;
        if (!Objects.equals(this.credentialsProvider, that.credentialsProvider)) {
            return false;
        }
        if (!Objects.equals(this.region, that.region)) {
            return false;
        }
        if (!Objects.equals(this.minimumPartSizeInBytes, that.minimumPartSizeInBytes)) {
            return false;
        }
        if (!Objects.equals(this.targetThroughputInGbps, that.targetThroughputInGbps)) {
            return false;
        }
        if (!Objects.equals(this.maxConcurrency, that.maxConcurrency)) {
            return false;
        }
        return Objects.equals(this.asyncConfiguration, that.asyncConfiguration);
    }

    public int hashCode() {
        int result = this.credentialsProvider != null ? this.credentialsProvider.hashCode() : 0;
        result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
        result = 31 * result + (this.minimumPartSizeInBytes != null ? this.minimumPartSizeInBytes.hashCode() : 0);
        result = 31 * result + (this.targetThroughputInGbps != null ? this.targetThroughputInGbps.hashCode() : 0);
        result = 31 * result + (this.maxConcurrency != null ? this.maxConcurrency.hashCode() : 0);
        result = 31 * result + (this.asyncConfiguration != null ? this.asyncConfiguration.hashCode() : 0);
        return result;
    }

    public static Builder builder() {
        return new DefaultBuilder();
    }

    private static final class DefaultBuilder
    implements Builder {
        private AwsCredentialsProvider credentialsProvider;
        private Region region;
        private Long minimumPartSizeInBytes;
        private Double targetThroughputInGbps;
        private Integer maxConcurrency;
        private ClientAsyncConfiguration asyncConfiguration;

        private DefaultBuilder() {
        }

        private DefaultBuilder(S3ClientConfiguration configuration) {
            this.credentialsProvider = configuration.credentialsProvider;
            this.region = configuration.region;
            this.minimumPartSizeInBytes = configuration.minimumPartSizeInBytes;
            this.targetThroughputInGbps = configuration.targetThroughputInGbps;
            this.maxConcurrency = configuration.maxConcurrency;
            this.asyncConfiguration = configuration.asyncConfiguration;
        }

        @Override
        public Builder credentialsProvider(AwsCredentialsProvider credentialsProvider) {
            this.credentialsProvider = credentialsProvider;
            return this;
        }

        @Override
        public Builder region(Region region) {
            this.region = region;
            return this;
        }

        @Override
        public Builder minimumPartSizeInBytes(Long partSizeBytes) {
            this.minimumPartSizeInBytes = partSizeBytes;
            return this;
        }

        @Override
        public Builder targetThroughputInGbps(Double targetThroughputInGbps) {
            this.targetThroughputInGbps = targetThroughputInGbps;
            return this;
        }

        @Override
        public Builder maxConcurrency(Integer maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        @Override
        public Builder asyncConfiguration(ClientAsyncConfiguration asyncConfiguration) {
            this.asyncConfiguration = asyncConfiguration;
            return this;
        }

        public S3ClientConfiguration build() {
            return new S3ClientConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, S3ClientConfiguration> {
        public Builder credentialsProvider(AwsCredentialsProvider var1);

        public Builder region(Region var1);

        public Builder minimumPartSizeInBytes(Long var1);

        public Builder targetThroughputInGbps(Double var1);

        public Builder maxConcurrency(Integer var1);

        public Builder asyncConfiguration(ClientAsyncConfiguration var1);

        default public Builder asyncConfiguration(Consumer<ClientAsyncConfiguration.Builder> configuration) {
            return this.asyncConfiguration((ClientAsyncConfiguration)((ClientAsyncConfiguration.Builder)ClientAsyncConfiguration.builder().applyMutation(configuration)).build());
        }
    }
}

