/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3;

import java.io.File;
import java.nio.file.Path;
import java.util.Objects;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.annotations.SdkPreviewApi;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.transfer.s3.TransferRequest;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkPublicApi
@SdkPreviewApi
public final class DownloadRequest
implements TransferRequest,
ToCopyableBuilder<Builder, DownloadRequest> {
    private final Path destination;
    private final GetObjectRequest getObjectRequest;

    private DownloadRequest(BuilderImpl builder) {
        this.destination = (Path)Validate.paramNotNull((Object)builder.destination, (String)"destination");
        this.getObjectRequest = (GetObjectRequest)Validate.paramNotNull((Object)builder.getObjectRequest, (String)"getObjectRequest");
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public Builder toBuilder() {
        return new BuilderImpl();
    }

    public Path destination() {
        return this.destination;
    }

    public GetObjectRequest getObjectRequest() {
        return this.getObjectRequest;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DownloadRequest that = (DownloadRequest)o;
        if (!Objects.equals(this.destination, that.destination)) {
            return false;
        }
        return Objects.equals(this.getObjectRequest, that.getObjectRequest);
    }

    public int hashCode() {
        int result = this.destination != null ? this.destination.hashCode() : 0;
        result = 31 * result + (this.getObjectRequest != null ? this.getObjectRequest.hashCode() : 0);
        return result;
    }

    private static final class BuilderImpl
    implements Builder {
        private Path destination;
        private GetObjectRequest getObjectRequest;

        private BuilderImpl() {
        }

        @Override
        public Builder destination(Path destination) {
            this.destination = destination;
            return this;
        }

        @Override
        public Builder getObjectRequest(GetObjectRequest getObjectRequest) {
            this.getObjectRequest = getObjectRequest;
            return this;
        }

        @Override
        public DownloadRequest build() {
            return new DownloadRequest(this);
        }
    }

    @SdkPublicApi
    @NotThreadSafe
    public static interface Builder
    extends TransferRequest.Builder<DownloadRequest, Builder>,
    CopyableBuilder<Builder, DownloadRequest> {
        public Builder destination(Path var1);

        default public Builder destination(File destination) {
            Validate.paramNotNull((Object)destination, (String)"destination");
            return this.destination(destination.toPath());
        }

        public Builder getObjectRequest(GetObjectRequest var1);

        default public Builder getObjectRequest(Consumer<GetObjectRequest.Builder> getObjectRequestBuilder) {
            GetObjectRequest request = (GetObjectRequest)((GetObjectRequest.Builder)GetObjectRequest.builder().applyMutation(getObjectRequestBuilder)).build();
            this.getObjectRequest(request);
            return this;
        }

        @Override
        public DownloadRequest build();
    }
}

