/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkPreviewApi;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.transfer.s3.TransferObjectRequest;
import software.amazon.awssdk.transfer.s3.TransferRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkPublicApi
@SdkPreviewApi
public final class DownloadRequest<ReturnT>
implements TransferObjectRequest,
ToCopyableBuilder<TypedBuilder<ReturnT>, DownloadRequest<ReturnT>> {
    private final AsyncResponseTransformer<GetObjectResponse, ReturnT> responseTransformer;
    private final GetObjectRequest getObjectRequest;
    private final TransferRequestOverrideConfiguration overrideConfiguration;

    private DownloadRequest(DefaultTypedBuilder<ReturnT> builder) {
        this.responseTransformer = (AsyncResponseTransformer)Validate.paramNotNull((Object)((DefaultTypedBuilder)builder).responseTransformer, (String)"responseTransformer");
        this.getObjectRequest = (GetObjectRequest)Validate.paramNotNull((Object)((DefaultTypedBuilder)builder).getObjectRequest, (String)"getObjectRequest");
        this.overrideConfiguration = ((DefaultTypedBuilder)builder).overrideConfiguration;
    }

    public static UntypedBuilder builder() {
        return new DefaultUntypedBuilder();
    }

    public TypedBuilder<ReturnT> toBuilder() {
        return new DefaultTypedBuilder(this);
    }

    public AsyncResponseTransformer<GetObjectResponse, ReturnT> responseTransformer() {
        return this.responseTransformer;
    }

    public GetObjectRequest getObjectRequest() {
        return this.getObjectRequest;
    }

    public Optional<TransferRequestOverrideConfiguration> overrideConfiguration() {
        return Optional.ofNullable(this.overrideConfiguration);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DownloadRequest that = (DownloadRequest)o;
        if (!Objects.equals(this.responseTransformer, that.responseTransformer)) {
            return false;
        }
        if (!Objects.equals(this.getObjectRequest, that.getObjectRequest)) {
            return false;
        }
        return Objects.equals(this.overrideConfiguration, that.overrideConfiguration);
    }

    public int hashCode() {
        int result = this.responseTransformer != null ? this.responseTransformer.hashCode() : 0;
        result = 31 * result + (this.getObjectRequest != null ? this.getObjectRequest.hashCode() : 0);
        result = 31 * result + (this.overrideConfiguration != null ? this.overrideConfiguration.hashCode() : 0);
        return result;
    }

    public String toString() {
        return ToString.builder((String)"DownloadRequest").add("responseTransformer", this.responseTransformer).add("getObjectRequest", (Object)this.getObjectRequest).add("overrideConfiguration", (Object)this.overrideConfiguration).build();
    }

    private static class DefaultTypedBuilder<T>
    implements TypedBuilder<T> {
        private GetObjectRequest getObjectRequest;
        private TransferRequestOverrideConfiguration overrideConfiguration;
        private AsyncResponseTransformer<GetObjectResponse, T> responseTransformer;

        private DefaultTypedBuilder() {
        }

        private DefaultTypedBuilder(DownloadRequest<T> request) {
            this.getObjectRequest = ((DownloadRequest)request).getObjectRequest;
            this.responseTransformer = ((DownloadRequest)request).responseTransformer;
            this.overrideConfiguration = ((DownloadRequest)request).overrideConfiguration;
        }

        @Override
        public TypedBuilder<T> getObjectRequest(GetObjectRequest getObjectRequest) {
            this.getObjectRequest = getObjectRequest;
            return this;
        }

        @Override
        public DefaultTypedBuilder<T> overrideConfiguration(TransferRequestOverrideConfiguration configuration) {
            this.overrideConfiguration = configuration;
            return this;
        }

        @Override
        public TypedBuilder<T> responseTransformer(AsyncResponseTransformer<GetObjectResponse, T> responseTransformer) {
            this.responseTransformer = responseTransformer;
            return this;
        }

        public DownloadRequest<T> build() {
            return new DownloadRequest(this);
        }
    }

    public static interface TypedBuilder<T>
    extends CopyableBuilder<TypedBuilder<T>, DownloadRequest<T>> {
        public TypedBuilder<T> getObjectRequest(GetObjectRequest var1);

        default public TypedBuilder<T> getObjectRequest(Consumer<GetObjectRequest.Builder> getObjectRequestBuilder) {
            GetObjectRequest request = (GetObjectRequest)((GetObjectRequest.Builder)GetObjectRequest.builder().applyMutation(getObjectRequestBuilder)).build();
            this.getObjectRequest(request);
            return this;
        }

        public TypedBuilder<T> overrideConfiguration(TransferRequestOverrideConfiguration var1);

        default public TypedBuilder<T> overrideConfiguration(Consumer<TransferRequestOverrideConfiguration.Builder> configurationBuilder) {
            Validate.paramNotNull(configurationBuilder, (String)"configurationBuilder");
            return this.overrideConfiguration(((TransferRequestOverrideConfiguration.Builder)TransferRequestOverrideConfiguration.builder().applyMutation(configurationBuilder)).build());
        }

        public TypedBuilder<T> responseTransformer(AsyncResponseTransformer<GetObjectResponse, T> var1);
    }

    private static class DefaultUntypedBuilder
    implements UntypedBuilder {
        private GetObjectRequest getObjectRequest;
        private TransferRequestOverrideConfiguration configuration;

        private DefaultUntypedBuilder() {
        }

        @Override
        public UntypedBuilder getObjectRequest(GetObjectRequest getObjectRequest) {
            this.getObjectRequest = getObjectRequest;
            return this;
        }

        @Override
        public UntypedBuilder overrideConfiguration(TransferRequestOverrideConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        @Override
        public <T> TypedBuilder<T> responseTransformer(AsyncResponseTransformer<GetObjectResponse, T> responseTransformer) {
            return new DefaultTypedBuilder().getObjectRequest(this.getObjectRequest).overrideConfiguration(this.configuration).responseTransformer(responseTransformer);
        }
    }

    public static interface UntypedBuilder {
        public UntypedBuilder getObjectRequest(GetObjectRequest var1);

        default public UntypedBuilder getObjectRequest(Consumer<GetObjectRequest.Builder> getObjectRequestBuilder) {
            GetObjectRequest request = (GetObjectRequest)((GetObjectRequest.Builder)GetObjectRequest.builder().applyMutation(getObjectRequestBuilder)).build();
            this.getObjectRequest(request);
            return this;
        }

        public UntypedBuilder overrideConfiguration(TransferRequestOverrideConfiguration var1);

        default public UntypedBuilder overrideConfiguration(Consumer<TransferRequestOverrideConfiguration.Builder> configurationBuilder) {
            Validate.paramNotNull(configurationBuilder, (String)"configurationBuilder");
            return this.overrideConfiguration(((TransferRequestOverrideConfiguration.Builder)TransferRequestOverrideConfiguration.builder().applyMutation(configurationBuilder)).build());
        }

        public <T> TypedBuilder<T> responseTransformer(AsyncResponseTransformer<GetObjectResponse, T> var1);

        default public <T> TypedBuilder<T> applyMutation(Function<UntypedBuilder, TypedBuilder<T>> mutator) {
            return mutator.apply(this);
        }
    }
}

