/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3.internal;

import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.SdkTestInternalApi;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectResponse;
import software.amazon.awssdk.transfer.s3.Download;
import software.amazon.awssdk.transfer.s3.DownloadRequest;
import software.amazon.awssdk.transfer.s3.S3ClientConfiguration;
import software.amazon.awssdk.transfer.s3.S3TransferManager;
import software.amazon.awssdk.transfer.s3.Upload;
import software.amazon.awssdk.transfer.s3.UploadRequest;
import software.amazon.awssdk.transfer.s3.internal.DefaultCompletedDownload;
import software.amazon.awssdk.transfer.s3.internal.DefaultCompletedUpload;
import software.amazon.awssdk.transfer.s3.internal.DefaultDownload;
import software.amazon.awssdk.transfer.s3.internal.DefaultUpload;
import software.amazon.awssdk.transfer.s3.internal.S3CrtAsyncClient;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
public final class DefaultS3TransferManager
implements S3TransferManager {
    private final S3CrtAsyncClient s3CrtAsyncClient;

    public DefaultS3TransferManager(DefaultBuilder builder) {
        S3CrtAsyncClient.S3CrtAsyncClientBuilder clientBuilder = S3CrtAsyncClient.builder();
        builder.s3ClientConfiguration.credentialsProvider().ifPresent(clientBuilder::credentialsProvider);
        builder.s3ClientConfiguration.maxConcurrency().ifPresent(clientBuilder::maxConcurrency);
        builder.s3ClientConfiguration.minimumPartSizeInBytes().ifPresent(clientBuilder::minimumPartSizeInBytes);
        builder.s3ClientConfiguration.region().ifPresent(clientBuilder::region);
        builder.s3ClientConfiguration.targetThroughputInGbps().ifPresent(clientBuilder::targetThroughputInGbps);
        builder.s3ClientConfiguration.asyncConfiguration().ifPresent(clientBuilder::asyncConfiguration);
        this.s3CrtAsyncClient = clientBuilder.build();
    }

    @SdkTestInternalApi
    DefaultS3TransferManager(S3CrtAsyncClient s3CrtAsyncClient) {
        this.s3CrtAsyncClient = s3CrtAsyncClient;
    }

    @Override
    public Upload upload(UploadRequest uploadRequest) {
        PutObjectRequest putObjectRequest = uploadRequest.putObjectRequest();
        AsyncRequestBody requestBody = this.requestBodyFor(uploadRequest);
        CompletableFuture putObjFuture = this.s3CrtAsyncClient.putObject(putObjectRequest, requestBody);
        CompletionStage future = putObjFuture.thenApply(r -> DefaultCompletedUpload.builder().response((PutObjectResponse)r).build());
        return new DefaultUpload(CompletableFutureUtils.forwardExceptionTo((CompletableFuture)future, (CompletableFuture)putObjFuture));
    }

    @Override
    public Download download(DownloadRequest downloadRequest) {
        CompletableFuture getObjectFuture = this.s3CrtAsyncClient.getObject(downloadRequest.getObjectRequest(), AsyncResponseTransformer.toFile((Path)downloadRequest.destination()));
        CompletionStage future = getObjectFuture.thenApply(r -> DefaultCompletedDownload.builder().response((GetObjectResponse)r).build());
        return new DefaultDownload(CompletableFutureUtils.forwardExceptionTo((CompletableFuture)future, (CompletableFuture)getObjectFuture));
    }

    public void close() {
        this.s3CrtAsyncClient.close();
    }

    public static S3TransferManager.Builder builder() {
        return new DefaultBuilder();
    }

    private AsyncRequestBody requestBodyFor(UploadRequest uploadRequest) {
        return AsyncRequestBody.fromFile((Path)uploadRequest.source());
    }

    private static class DefaultBuilder
    implements S3TransferManager.Builder {
        private S3ClientConfiguration s3ClientConfiguration;

        private DefaultBuilder() {
        }

        @Override
        public S3TransferManager.Builder s3ClientConfiguration(S3ClientConfiguration configuration) {
            this.s3ClientConfiguration = configuration;
            return this;
        }

        @Override
        public S3TransferManager build() {
            return new DefaultS3TransferManager(this);
        }
    }
}

