/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3;

import java.nio.file.Path;
import java.util.Objects;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.annotations.SdkPreviewApi;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.transfer.s3.TransferRequest;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkPublicApi
@SdkPreviewApi
public final class UploadRequest
implements TransferRequest,
ToCopyableBuilder<Builder, UploadRequest> {
    private final PutObjectRequest putObjectRequest;
    private final Path source;

    private UploadRequest(BuilderImpl builder) {
        this.putObjectRequest = (PutObjectRequest)Validate.paramNotNull((Object)builder.putObjectRequest, (String)"putObjectRequest");
        this.source = (Path)Validate.paramNotNull((Object)builder.source, (String)"source");
    }

    public PutObjectRequest putObjectRequest() {
        return this.putObjectRequest;
    }

    public Path source() {
        return this.source;
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public Builder toBuilder() {
        return new BuilderImpl();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UploadRequest that = (UploadRequest)o;
        if (!Objects.equals(this.putObjectRequest, that.putObjectRequest)) {
            return false;
        }
        return Objects.equals(this.source, that.source);
    }

    public int hashCode() {
        int result = this.putObjectRequest != null ? this.putObjectRequest.hashCode() : 0;
        result = 31 * result + (this.source != null ? this.source.hashCode() : 0);
        return result;
    }

    private static class BuilderImpl
    implements Builder {
        private PutObjectRequest putObjectRequest;
        private Path source;

        private BuilderImpl() {
        }

        @Override
        public Builder source(Path source) {
            this.source = source;
            return this;
        }

        @Override
        public Builder putObjectRequest(PutObjectRequest putObjectRequest) {
            this.putObjectRequest = putObjectRequest;
            return this;
        }

        @Override
        public UploadRequest build() {
            return new UploadRequest(this);
        }
    }

    @SdkPublicApi
    @NotThreadSafe
    public static interface Builder
    extends TransferRequest.Builder<UploadRequest, Builder>,
    CopyableBuilder<Builder, UploadRequest> {
        public Builder source(Path var1);

        public Builder putObjectRequest(PutObjectRequest var1);

        default public Builder putObjectRequest(Consumer<PutObjectRequest.Builder> putObjectRequestBuilder) {
            return this.putObjectRequest((PutObjectRequest)((PutObjectRequest.Builder)PutObjectRequest.builder().applyMutation(putObjectRequestBuilder)).build());
        }

        @Override
        public UploadRequest build();
    }
}

