/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPreviewApi;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.transfer.s3.UploadDirectoryOverrideConfiguration;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkPublicApi
@SdkPreviewApi
public final class S3TransferManagerOverrideConfiguration
implements ToCopyableBuilder<Builder, S3TransferManagerOverrideConfiguration> {
    private final Executor executor;
    private final UploadDirectoryOverrideConfiguration uploadDirectoryConfiguration;

    private S3TransferManagerOverrideConfiguration(DefaultBuilder builder) {
        this.executor = builder.executor;
        this.uploadDirectoryConfiguration = builder.uploadDirectoryConfiguration;
    }

    public Optional<Executor> executor() {
        return Optional.ofNullable(this.executor);
    }

    public Optional<UploadDirectoryOverrideConfiguration> uploadDirectoryConfiguration() {
        return Optional.ofNullable(this.uploadDirectoryConfiguration);
    }

    public Builder toBuilder() {
        return new DefaultBuilder(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        S3TransferManagerOverrideConfiguration that = (S3TransferManagerOverrideConfiguration)o;
        if (!Objects.equals(this.executor, that.executor)) {
            return false;
        }
        return Objects.equals(this.uploadDirectoryConfiguration, that.uploadDirectoryConfiguration);
    }

    public int hashCode() {
        int result = this.executor != null ? this.executor.hashCode() : 0;
        result = 31 * result + (this.uploadDirectoryConfiguration != null ? this.uploadDirectoryConfiguration.hashCode() : 0);
        return result;
    }

    public static Builder builder() {
        return new DefaultBuilder();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return DefaultBuilder.class;
    }

    private static final class DefaultBuilder
    implements Builder {
        private Executor executor;
        private UploadDirectoryOverrideConfiguration uploadDirectoryConfiguration;

        private DefaultBuilder() {
        }

        private DefaultBuilder(S3TransferManagerOverrideConfiguration configuration) {
            this.executor = configuration.executor;
            this.uploadDirectoryConfiguration = configuration.uploadDirectoryConfiguration;
        }

        @Override
        public Builder executor(Executor executor) {
            this.executor = executor;
            return this;
        }

        public void setExecutor(Executor executor) {
            this.executor(executor);
        }

        public Executor getExecutor() {
            return this.executor;
        }

        @Override
        public Builder uploadDirectoryConfiguration(UploadDirectoryOverrideConfiguration uploadDirectoryConfiguration) {
            this.uploadDirectoryConfiguration = uploadDirectoryConfiguration;
            return this;
        }

        public void setUploadDirectoryConfiguration(UploadDirectoryOverrideConfiguration uploadDirectoryConfiguration) {
            this.uploadDirectoryConfiguration(uploadDirectoryConfiguration);
        }

        public UploadDirectoryOverrideConfiguration getUploadDirectoryConfiguration() {
            return this.uploadDirectoryConfiguration;
        }

        public S3TransferManagerOverrideConfiguration build() {
            return new S3TransferManagerOverrideConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, S3TransferManagerOverrideConfiguration> {
        public Builder executor(Executor var1);

        public Builder uploadDirectoryConfiguration(UploadDirectoryOverrideConfiguration var1);

        default public Builder uploadDirectoryConfiguration(Consumer<UploadDirectoryOverrideConfiguration.Builder> uploadConfigurationBuilder) {
            Validate.paramNotNull(uploadConfigurationBuilder, (String)"uploadConfigurationBuilder");
            return this.uploadDirectoryConfiguration(((UploadDirectoryOverrideConfiguration.Builder)UploadDirectoryOverrideConfiguration.builder().applyMutation(uploadConfigurationBuilder)).build());
        }
    }
}

