/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3.internal;

import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.SdkTestInternalApi;
import software.amazon.awssdk.arns.Arn;
import software.amazon.awssdk.core.FileTransformerConfiguration;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.services.s3.internal.resource.S3AccessPointResource;
import software.amazon.awssdk.services.s3.internal.resource.S3ArnConverter;
import software.amazon.awssdk.services.s3.internal.resource.S3Resource;
import software.amazon.awssdk.services.s3.model.CopyObjectResponse;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.PutObjectResponse;
import software.amazon.awssdk.transfer.s3.CompletedCopy;
import software.amazon.awssdk.transfer.s3.CompletedDownload;
import software.amazon.awssdk.transfer.s3.CompletedFileDownload;
import software.amazon.awssdk.transfer.s3.CompletedFileUpload;
import software.amazon.awssdk.transfer.s3.CompletedUpload;
import software.amazon.awssdk.transfer.s3.Copy;
import software.amazon.awssdk.transfer.s3.CopyRequest;
import software.amazon.awssdk.transfer.s3.DirectoryDownload;
import software.amazon.awssdk.transfer.s3.DirectoryUpload;
import software.amazon.awssdk.transfer.s3.Download;
import software.amazon.awssdk.transfer.s3.DownloadDirectoryRequest;
import software.amazon.awssdk.transfer.s3.DownloadFileRequest;
import software.amazon.awssdk.transfer.s3.DownloadRequest;
import software.amazon.awssdk.transfer.s3.FileDownload;
import software.amazon.awssdk.transfer.s3.FileUpload;
import software.amazon.awssdk.transfer.s3.ResumableFileDownload;
import software.amazon.awssdk.transfer.s3.S3ClientConfiguration;
import software.amazon.awssdk.transfer.s3.S3TransferManager;
import software.amazon.awssdk.transfer.s3.S3TransferManagerOverrideConfiguration;
import software.amazon.awssdk.transfer.s3.Upload;
import software.amazon.awssdk.transfer.s3.UploadDirectoryRequest;
import software.amazon.awssdk.transfer.s3.UploadFileRequest;
import software.amazon.awssdk.transfer.s3.UploadRequest;
import software.amazon.awssdk.transfer.s3.internal.DefaultCopy;
import software.amazon.awssdk.transfer.s3.internal.DefaultDirectoryDownload;
import software.amazon.awssdk.transfer.s3.internal.DefaultDirectoryUpload;
import software.amazon.awssdk.transfer.s3.internal.DefaultDownload;
import software.amazon.awssdk.transfer.s3.internal.DefaultFileDownload;
import software.amazon.awssdk.transfer.s3.internal.DefaultFileUpload;
import software.amazon.awssdk.transfer.s3.internal.DefaultUpload;
import software.amazon.awssdk.transfer.s3.internal.DownloadDirectoryHelper;
import software.amazon.awssdk.transfer.s3.internal.ListObjectsHelper;
import software.amazon.awssdk.transfer.s3.internal.S3CrtAsyncClient;
import software.amazon.awssdk.transfer.s3.internal.TransferManagerConfiguration;
import software.amazon.awssdk.transfer.s3.internal.UploadDirectoryHelper;
import software.amazon.awssdk.transfer.s3.internal.progress.TransferProgressUpdater;
import software.amazon.awssdk.transfer.s3.internal.utils.ResumableRequestConverter;
import software.amazon.awssdk.transfer.s3.progress.TransferProgress;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.Pair;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultS3TransferManager
implements S3TransferManager {
    private static final Logger log = Logger.loggerFor(S3TransferManager.class);
    private final S3CrtAsyncClient s3CrtAsyncClient;
    private final TransferManagerConfiguration transferConfiguration;
    private final UploadDirectoryHelper uploadDirectoryHelper;
    private final DownloadDirectoryHelper downloadDirectoryHelper;

    public DefaultS3TransferManager(DefaultBuilder tmBuilder) {
        this.transferConfiguration = DefaultS3TransferManager.resolveTransferManagerConfiguration(tmBuilder);
        this.s3CrtAsyncClient = DefaultS3TransferManager.initializeS3CrtClient(tmBuilder);
        this.uploadDirectoryHelper = new UploadDirectoryHelper(this.transferConfiguration, this::uploadFile);
        ListObjectsHelper listObjectsHelper = new ListObjectsHelper(arg_0 -> ((S3CrtAsyncClient)this.s3CrtAsyncClient).listObjectsV2(arg_0));
        this.downloadDirectoryHelper = new DownloadDirectoryHelper(this.transferConfiguration, listObjectsHelper, this::downloadFile);
    }

    @SdkTestInternalApi
    DefaultS3TransferManager(S3CrtAsyncClient s3CrtAsyncClient, UploadDirectoryHelper uploadDirectoryHelper, TransferManagerConfiguration configuration, DownloadDirectoryHelper downloadDirectoryHelper) {
        this.s3CrtAsyncClient = s3CrtAsyncClient;
        this.transferConfiguration = configuration;
        this.uploadDirectoryHelper = uploadDirectoryHelper;
        this.downloadDirectoryHelper = downloadDirectoryHelper;
    }

    private static TransferManagerConfiguration resolveTransferManagerConfiguration(DefaultBuilder tmBuilder) {
        TransferManagerConfiguration.Builder transferConfigBuilder = TransferManagerConfiguration.builder();
        tmBuilder.transferManagerConfiguration.uploadDirectoryConfiguration().ifPresent(transferConfigBuilder::uploadDirectoryConfiguration);
        tmBuilder.transferManagerConfiguration.executor().ifPresent(transferConfigBuilder::executor);
        return transferConfigBuilder.build();
    }

    private static S3CrtAsyncClient initializeS3CrtClient(DefaultBuilder tmBuilder) {
        S3CrtAsyncClient.S3CrtAsyncClientBuilder clientBuilder = S3CrtAsyncClient.builder();
        tmBuilder.s3ClientConfiguration.credentialsProvider().ifPresent(clientBuilder::credentialsProvider);
        tmBuilder.s3ClientConfiguration.maxConcurrency().ifPresent(clientBuilder::maxConcurrency);
        tmBuilder.s3ClientConfiguration.minimumPartSizeInBytes().ifPresent(clientBuilder::minimumPartSizeInBytes);
        tmBuilder.s3ClientConfiguration.region().ifPresent(clientBuilder::region);
        tmBuilder.s3ClientConfiguration.targetThroughputInGbps().ifPresent(clientBuilder::targetThroughputInGbps);
        tmBuilder.s3ClientConfiguration.endpointOverride().ifPresent(clientBuilder::endpointOverride);
        return clientBuilder.build();
    }

    @Override
    public Upload upload(UploadRequest uploadRequest) {
        Validate.paramNotNull((Object)uploadRequest, (String)"uploadRequest");
        AsyncRequestBody requestBody = uploadRequest.requestBody();
        CompletableFuture<CompletedUpload> returnFuture = new CompletableFuture<CompletedUpload>();
        TransferProgressUpdater progressUpdater = new TransferProgressUpdater(uploadRequest, requestBody);
        progressUpdater.transferInitiated();
        requestBody = progressUpdater.wrapRequestBody(requestBody);
        progressUpdater.registerCompletion(returnFuture);
        try {
            DefaultS3TransferManager.assertNotUnsupportedArn(uploadRequest.putObjectRequest().bucket(), "upload");
            CompletableFuture crtFuture = this.s3CrtAsyncClient.putObject(uploadRequest.putObjectRequest(), requestBody);
            CompletableFutureUtils.forwardExceptionTo(returnFuture, (CompletableFuture)crtFuture);
            CompletableFutureUtils.forwardTransformedResultTo((CompletableFuture)crtFuture, returnFuture, r -> CompletedUpload.builder().response((PutObjectResponse)r).build());
        }
        catch (Throwable throwable) {
            returnFuture.completeExceptionally(throwable);
        }
        return new DefaultUpload(returnFuture, progressUpdater.progress());
    }

    @Override
    public FileUpload uploadFile(UploadFileRequest uploadFileRequest) {
        Validate.paramNotNull((Object)uploadFileRequest, (String)"uploadFileRequest");
        AsyncRequestBody requestBody = AsyncRequestBody.fromFile((Path)uploadFileRequest.source());
        CompletableFuture<CompletedFileUpload> returnFuture = new CompletableFuture<CompletedFileUpload>();
        TransferProgressUpdater progressUpdater = new TransferProgressUpdater(uploadFileRequest, requestBody);
        progressUpdater.transferInitiated();
        requestBody = progressUpdater.wrapRequestBody(requestBody);
        progressUpdater.registerCompletion(returnFuture);
        try {
            DefaultS3TransferManager.assertNotUnsupportedArn(uploadFileRequest.putObjectRequest().bucket(), "upload");
            CompletableFuture crtFuture = this.s3CrtAsyncClient.putObject(uploadFileRequest.putObjectRequest(), requestBody);
            CompletableFutureUtils.forwardExceptionTo(returnFuture, (CompletableFuture)crtFuture);
            CompletableFutureUtils.forwardTransformedResultTo((CompletableFuture)crtFuture, returnFuture, r -> CompletedFileUpload.builder().response((PutObjectResponse)r).build());
        }
        catch (Throwable throwable) {
            returnFuture.completeExceptionally(throwable);
        }
        return new DefaultFileUpload(returnFuture, progressUpdater.progress());
    }

    @Override
    public DirectoryUpload uploadDirectory(UploadDirectoryRequest uploadDirectoryRequest) {
        Validate.paramNotNull((Object)uploadDirectoryRequest, (String)"uploadDirectoryRequest");
        try {
            DefaultS3TransferManager.assertNotUnsupportedArn(uploadDirectoryRequest.bucket(), "uploadDirectory");
            return this.uploadDirectoryHelper.uploadDirectory(uploadDirectoryRequest);
        }
        catch (Throwable throwable) {
            return new DefaultDirectoryUpload(CompletableFutureUtils.failedFuture((Throwable)throwable));
        }
    }

    @Override
    public <ResultT> Download<ResultT> download(DownloadRequest<ResultT> downloadRequest) {
        Validate.paramNotNull(downloadRequest, (String)"downloadRequest");
        AsyncResponseTransformer<GetObjectResponse, ResultT> responseTransformer = downloadRequest.responseTransformer();
        CompletableFuture returnFuture = new CompletableFuture();
        TransferProgressUpdater progressUpdater = new TransferProgressUpdater(downloadRequest, null);
        progressUpdater.transferInitiated();
        responseTransformer = progressUpdater.wrapResponseTransformer(responseTransformer);
        progressUpdater.registerCompletion(returnFuture);
        try {
            DefaultS3TransferManager.assertNotUnsupportedArn(downloadRequest.getObjectRequest().bucket(), "download");
            CompletableFuture crtFuture = this.s3CrtAsyncClient.getObject(downloadRequest.getObjectRequest(), responseTransformer);
            CompletableFutureUtils.forwardExceptionTo(returnFuture, (CompletableFuture)crtFuture);
            CompletableFutureUtils.forwardTransformedResultTo((CompletableFuture)crtFuture, returnFuture, r -> (CompletedDownload)CompletedDownload.builder().result(r).build());
        }
        catch (Throwable throwable) {
            returnFuture.completeExceptionally(throwable);
        }
        return new DefaultDownload(returnFuture, progressUpdater.progress());
    }

    @Override
    public FileDownload downloadFile(DownloadFileRequest downloadRequest) {
        Validate.paramNotNull((Object)downloadRequest, (String)"downloadFileRequest");
        AsyncResponseTransformer responseTransformer = AsyncResponseTransformer.toFile((Path)downloadRequest.destination(), (FileTransformerConfiguration)FileTransformerConfiguration.defaultCreateOrReplaceExisting());
        CompletableFuture<CompletedFileDownload> returnFuture = new CompletableFuture<CompletedFileDownload>();
        TransferProgressUpdater progressUpdater = this.doDownloadFile(downloadRequest, (AsyncResponseTransformer<GetObjectResponse, GetObjectResponse>)responseTransformer, returnFuture);
        return new DefaultFileDownload(returnFuture, CompletableFuture.completedFuture(progressUpdater.progress()), CompletableFuture.completedFuture(downloadRequest));
    }

    private TransferProgressUpdater doDownloadFile(DownloadFileRequest downloadRequest, AsyncResponseTransformer<GetObjectResponse, GetObjectResponse> responseTransformer, CompletableFuture<CompletedFileDownload> returnFuture) {
        TransferProgressUpdater progressUpdater = new TransferProgressUpdater(downloadRequest, null);
        try {
            progressUpdater.transferInitiated();
            responseTransformer = progressUpdater.wrapResponseTransformer(responseTransformer);
            progressUpdater.registerCompletion(returnFuture);
            DefaultS3TransferManager.assertNotUnsupportedArn(downloadRequest.getObjectRequest().bucket(), "download");
            CompletableFuture crtFuture = this.s3CrtAsyncClient.getObject(downloadRequest.getObjectRequest(), responseTransformer);
            CompletableFutureUtils.forwardExceptionTo(returnFuture, (CompletableFuture)crtFuture);
            CompletableFutureUtils.forwardTransformedResultTo((CompletableFuture)crtFuture, returnFuture, res -> CompletedFileDownload.builder().response((GetObjectResponse)res).build());
        }
        catch (Throwable throwable) {
            returnFuture.completeExceptionally(throwable);
        }
        return progressUpdater;
    }

    @Override
    public FileDownload resumeDownloadFile(ResumableFileDownload resumableFileDownload) {
        Validate.paramNotNull((Object)resumableFileDownload, (String)"resumableFileDownload");
        CompletableFuture<CompletedFileDownload> returnFuture = new CompletableFuture<CompletedFileDownload>();
        DownloadFileRequest originalDownloadRequest = resumableFileDownload.downloadFileRequest();
        GetObjectRequest getObjectRequest = originalDownloadRequest.getObjectRequest();
        CompletableFuture<TransferProgress> progressFuture = new CompletableFuture<TransferProgress>();
        CompletableFuture<DownloadFileRequest> newDownloadFileRequestFuture = new CompletableFuture<DownloadFileRequest>();
        ((CompletableFuture)this.s3CrtAsyncClient.headObject(b -> b.bucket(getObjectRequest.bucket()).key(getObjectRequest.key())).thenAccept(headObjectResponse -> {
            Pair<DownloadFileRequest, AsyncResponseTransformer<GetObjectResponse, GetObjectResponse>> requestPair = ResumableRequestConverter.toDownloadFileRequestAndTransformer(resumableFileDownload, headObjectResponse, originalDownloadRequest);
            DownloadFileRequest newDownloadFileRequest = (DownloadFileRequest)requestPair.left();
            newDownloadFileRequestFuture.complete(newDownloadFileRequest);
            log.debug(() -> "Sending downloadFileRequest " + newDownloadFileRequest);
            TransferProgressUpdater progressUpdater = this.doDownloadFile(newDownloadFileRequest, (AsyncResponseTransformer<GetObjectResponse, GetObjectResponse>)((AsyncResponseTransformer)requestPair.right()), returnFuture);
            progressFuture.complete(progressUpdater.progress());
        })).exceptionally(throwable -> {
            DefaultS3TransferManager.handleException(returnFuture, progressFuture, newDownloadFileRequestFuture, throwable);
            return null;
        });
        return new DefaultFileDownload(returnFuture, progressFuture, newDownloadFileRequestFuture);
    }

    private static void handleException(CompletableFuture<CompletedFileDownload> returnFuture, CompletableFuture<TransferProgress> progressFuture, CompletableFuture<DownloadFileRequest> newDownloadFileRequestFuture, Throwable throwable) {
        SdkClientException exception = SdkClientException.create((String)"Failed to resume the request", (Throwable)throwable);
        returnFuture.completeExceptionally((Throwable)exception);
        progressFuture.completeExceptionally((Throwable)exception);
        newDownloadFileRequestFuture.completeExceptionally((Throwable)exception);
    }

    @Override
    public DirectoryDownload downloadDirectory(DownloadDirectoryRequest downloadDirectoryRequest) {
        Validate.paramNotNull((Object)downloadDirectoryRequest, (String)"downloadDirectoryRequest");
        try {
            DefaultS3TransferManager.assertNotUnsupportedArn(downloadDirectoryRequest.bucket(), "downloadDirectoryRequest");
            return this.downloadDirectoryHelper.downloadDirectory(downloadDirectoryRequest);
        }
        catch (Throwable throwable) {
            return new DefaultDirectoryDownload(CompletableFutureUtils.failedFuture((Throwable)throwable));
        }
    }

    @Override
    public Copy copy(CopyRequest copyRequest) {
        Validate.paramNotNull((Object)copyRequest, (String)"copyRequest");
        CompletableFuture<CompletedCopy> returnFuture = new CompletableFuture<CompletedCopy>();
        TransferProgressUpdater progressUpdater = new TransferProgressUpdater(copyRequest, null);
        progressUpdater.transferInitiated();
        progressUpdater.registerCompletion(returnFuture);
        try {
            DefaultS3TransferManager.assertNotUnsupportedArn(copyRequest.copyObjectRequest().sourceBucket(), "copy sourceBucket");
            DefaultS3TransferManager.assertNotUnsupportedArn(copyRequest.copyObjectRequest().destinationBucket(), "copy destinationBucket");
            CompletableFuture crtFuture = this.s3CrtAsyncClient.copyObject(copyRequest.copyObjectRequest());
            CompletableFutureUtils.forwardExceptionTo(returnFuture, (CompletableFuture)crtFuture);
            CompletableFutureUtils.forwardTransformedResultTo((CompletableFuture)crtFuture, returnFuture, r -> CompletedCopy.builder().response((CopyObjectResponse)r).build());
        }
        catch (Throwable throwable) {
            returnFuture.completeExceptionally(throwable);
        }
        return new DefaultCopy(returnFuture, progressUpdater.progress());
    }

    public void close() {
        this.s3CrtAsyncClient.close();
        this.transferConfiguration.close();
    }

    public static S3TransferManager.Builder builder() {
        return new DefaultBuilder();
    }

    private static void assertNotUnsupportedArn(String bucket, String operation) {
        if (bucket == null) {
            return;
        }
        if (!bucket.startsWith("arn:")) {
            return;
        }
        if (DefaultS3TransferManager.isObjectLambdaArn(bucket)) {
            String error = String.format("%s does not support S3 Object Lambda resources", operation);
            throw new IllegalArgumentException(error);
        }
        Arn arn = Arn.fromString((String)bucket);
        if (DefaultS3TransferManager.isMrapArn(arn)) {
            String error = String.format("%s does not support S3 multi-region access point ARN", operation);
            throw new IllegalArgumentException(error);
        }
    }

    private static boolean isObjectLambdaArn(String arn) {
        return arn.contains(":s3-object-lambda");
    }

    private static boolean isMrapArn(Arn arn) {
        S3Resource s3Resource = S3ArnConverter.create().convertArn(arn);
        S3AccessPointResource s3EndpointResource = (S3AccessPointResource)Validate.isInstanceOf(S3AccessPointResource.class, (Object)s3Resource, (String)"An ARN was passed as a bucket parameter to an S3 operation, however it does not appear to be a valid S3 access point ARN.", (Object[])new Object[0]);
        return !s3EndpointResource.region().isPresent();
    }

    private static final class DefaultBuilder
    implements S3TransferManager.Builder {
        private S3ClientConfiguration s3ClientConfiguration = (S3ClientConfiguration)S3ClientConfiguration.builder().build();
        private S3TransferManagerOverrideConfiguration transferManagerConfiguration = (S3TransferManagerOverrideConfiguration)S3TransferManagerOverrideConfiguration.builder().build();

        private DefaultBuilder() {
        }

        @Override
        public S3TransferManager.Builder s3ClientConfiguration(S3ClientConfiguration configuration) {
            this.s3ClientConfiguration = configuration;
            return this;
        }

        @Override
        public S3TransferManager.Builder transferConfiguration(S3TransferManagerOverrideConfiguration transferManagerConfiguration) {
            this.transferManagerConfiguration = transferManagerConfiguration;
            return this;
        }

        @Override
        public S3TransferManager build() {
            return new DefaultS3TransferManager(this);
        }
    }
}

