/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3.internal;

import java.nio.file.Path;
import java.util.Objects;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.SdkPreviewApi;
import software.amazon.awssdk.services.s3.model.S3Object;
import software.amazon.awssdk.transfer.s3.DownloadFileContext;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
@SdkPreviewApi
public final class DefaultDownloadFileContext
implements DownloadFileContext {
    private final S3Object source;
    private final Path destination;

    public DefaultDownloadFileContext(S3Object source, Path destination) {
        this.source = (S3Object)Validate.notNull((Object)source, (String)"source", (Object[])new Object[0]);
        this.destination = (Path)Validate.notNull((Object)destination, (String)"destination", (Object[])new Object[0]);
    }

    @Override
    public S3Object source() {
        return this.source;
    }

    @Override
    public Path destination() {
        return this.destination;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultDownloadFileContext that = (DefaultDownloadFileContext)o;
        if (!Objects.equals(this.source, that.source)) {
            return false;
        }
        return Objects.equals(this.destination, that.destination);
    }

    public int hashCode() {
        int result = this.source != null ? this.source.hashCode() : 0;
        result = 31 * result + (this.destination != null ? this.destination.hashCode() : 0);
        return result;
    }

    public String toString() {
        return ToString.builder((String)"DefaultDownloadFileContext").add("source", (Object)this.source).add("destination", (Object)this.destination).build();
    }
}

