/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.transfer.s3.DownloadFileRequest;
import software.amazon.awssdk.transfer.s3.ResumableTransfer;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkPublicApi
public final class ResumableFileDownload
implements ResumableTransfer,
ToCopyableBuilder<Builder, ResumableFileDownload> {
    private final DownloadFileRequest downloadFileRequest;
    private final long bytesTransferred;
    private final Instant s3ObjectLastModified;
    private final Long totalSizeInBytes;
    private final Instant fileLastModified;

    private ResumableFileDownload(DefaultBuilder builder) {
        this.downloadFileRequest = (DownloadFileRequest)Validate.paramNotNull((Object)builder.downloadFileRequest, (String)"downloadFileRequest");
        Validate.isPositiveOrNull((Long)builder.bytesTransferred, (String)"bytesTransferred");
        this.bytesTransferred = builder.bytesTransferred == null ? 0L : builder.bytesTransferred;
        this.s3ObjectLastModified = builder.s3ObjectLastModified;
        this.totalSizeInBytes = Validate.isPositiveOrNull((Long)builder.totalSizeInBytes, (String)"totalSizeInBytes");
        this.fileLastModified = builder.fileLastModified;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResumableFileDownload that = (ResumableFileDownload)o;
        if (this.bytesTransferred != that.bytesTransferred) {
            return false;
        }
        if (!this.downloadFileRequest.equals(that.downloadFileRequest)) {
            return false;
        }
        if (!Objects.equals(this.s3ObjectLastModified, that.s3ObjectLastModified)) {
            return false;
        }
        if (!Objects.equals(this.fileLastModified, that.fileLastModified)) {
            return false;
        }
        return Objects.equals(this.totalSizeInBytes, that.totalSizeInBytes);
    }

    public int hashCode() {
        int result = this.downloadFileRequest.hashCode();
        result = 31 * result + (int)(this.bytesTransferred ^ this.bytesTransferred >>> 32);
        result = 31 * result + (this.s3ObjectLastModified != null ? this.s3ObjectLastModified.hashCode() : 0);
        result = 31 * result + (this.fileLastModified != null ? this.fileLastModified.hashCode() : 0);
        result = 31 * result + (this.totalSizeInBytes != null ? this.totalSizeInBytes.hashCode() : 0);
        return result;
    }

    public static Builder builder() {
        return new DefaultBuilder();
    }

    public DownloadFileRequest downloadFileRequest() {
        return this.downloadFileRequest;
    }

    public long bytesTransferred() {
        return this.bytesTransferred;
    }

    public Optional<Instant> s3ObjectLastModified() {
        return Optional.ofNullable(this.s3ObjectLastModified);
    }

    public Instant fileLastModified() {
        return this.fileLastModified;
    }

    public Optional<Long> totalSizeInBytes() {
        return Optional.ofNullable(this.totalSizeInBytes);
    }

    public Builder toBuilder() {
        return new DefaultBuilder(this);
    }

    private static final class DefaultBuilder
    implements Builder {
        private DownloadFileRequest downloadFileRequest;
        private Long bytesTransferred;
        private Instant s3ObjectLastModified;
        private Long totalSizeInBytes;
        private Instant fileLastModified;

        private DefaultBuilder() {
        }

        private DefaultBuilder(ResumableFileDownload persistableFileDownload) {
            this.downloadFileRequest = persistableFileDownload.downloadFileRequest;
            this.bytesTransferred = persistableFileDownload.bytesTransferred;
            this.s3ObjectLastModified = persistableFileDownload.s3ObjectLastModified;
        }

        @Override
        public Builder downloadFileRequest(DownloadFileRequest downloadFileRequest) {
            this.downloadFileRequest = downloadFileRequest;
            return this;
        }

        @Override
        public Builder bytesTransferred(Long bytesTransferred) {
            this.bytesTransferred = bytesTransferred;
            return this;
        }

        @Override
        public Builder totalSizeInBytes(Long totalSizeInBytes) {
            this.totalSizeInBytes = totalSizeInBytes;
            return this;
        }

        @Override
        public Builder s3ObjectLastModified(Instant s3ObjectLastModified) {
            this.s3ObjectLastModified = s3ObjectLastModified;
            return this;
        }

        @Override
        public Builder fileLastModified(Instant fileLastModified) {
            this.fileLastModified = fileLastModified;
            return this;
        }

        public ResumableFileDownload build() {
            return new ResumableFileDownload(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ResumableFileDownload> {
        public Builder downloadFileRequest(DownloadFileRequest var1);

        public Builder bytesTransferred(Long var1);

        public Builder totalSizeInBytes(Long var1);

        public Builder s3ObjectLastModified(Instant var1);

        public Builder fileLastModified(Instant var1);
    }
}

