/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3.internal;

import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AsyncBufferingSubscriber<T>
implements Subscriber<T> {
    private static final Logger log = Logger.loggerFor(AsyncBufferingSubscriber.class);
    private static final Object COMPLETE_EVENT = new Object();
    private final Queue<Object> buffer;
    private final CompletableFuture<?> returnFuture;
    private final Function<T, CompletableFuture<?>> consumer;
    private final int maxConcurrentExecutions;
    private final AtomicInteger numRequestsInFlight;
    private final AtomicBoolean isDelivering = new AtomicBoolean(false);
    private volatile boolean isStreamingDone;
    private volatile Subscription subscription;

    public AsyncBufferingSubscriber(Function<T, CompletableFuture<?>> consumer, CompletableFuture<Void> returnFuture, int maxConcurrentExecutions) {
        this.buffer = new ConcurrentLinkedQueue<Object>();
        this.returnFuture = returnFuture;
        this.consumer = consumer;
        this.maxConcurrentExecutions = maxConcurrentExecutions;
        this.numRequestsInFlight = new AtomicInteger(0);
    }

    public void onSubscribe(Subscription subscription) {
        Validate.paramNotNull((Object)subscription, (String)"subscription");
        if (this.subscription != null) {
            log.warn(() -> "The subscriber has already been subscribed. Cancelling the incoming subscription");
            subscription.cancel();
            return;
        }
        this.subscription = subscription;
        subscription.request(1L);
    }

    public void onNext(T item) {
        if (item == null) {
            this.subscription.cancel();
            NullPointerException exception = new NullPointerException("Item must not be null");
            this.returnFuture.completeExceptionally(exception);
            throw exception;
        }
        try {
            this.buffer.add(item);
            this.flushBufferIfNeeded();
        }
        catch (Exception e) {
            this.isStreamingDone = true;
            this.subscription.cancel();
            this.returnFuture.completeExceptionally(e);
        }
    }

    private void flushBufferIfNeeded() {
        if (this.buffer.isEmpty()) {
            if (this.isStreamingDone && this.numRequestsInFlight.get() == 0) {
                this.returnFuture.complete(null);
            } else {
                this.subscription.request(1L);
            }
            return;
        }
        if (this.isDelivering.compareAndSet(false, true)) {
            try {
                Object firstEvent = this.buffer.peek();
                if (AsyncBufferingSubscriber.isCompleteEvent(firstEvent)) {
                    Object event = this.buffer.poll();
                    this.handleCompleteEvent(event);
                    return;
                }
                while (!this.buffer.isEmpty() && this.numRequestsInFlight.get() < this.maxConcurrentExecutions) {
                    Object item = this.buffer.poll();
                    if (item == null) {
                        break;
                    }
                    if (AsyncBufferingSubscriber.isCompleteEvent(item)) {
                        this.handleCompleteEvent(item);
                        return;
                    }
                    this.deliverItem(item);
                }
            }
            finally {
                this.isDelivering.set(false);
            }
        }
    }

    private void deliverItem(T item) {
        int numberOfRequestInFlight = this.numRequestsInFlight.incrementAndGet();
        log.debug(() -> "Delivering next item, numRequestInFlight=" + numberOfRequestInFlight);
        this.consumer.apply(item).whenComplete((r, t) -> {
            this.numRequestsInFlight.decrementAndGet();
            if (!this.isStreamingDone) {
                this.subscription.request(1L);
            } else {
                this.flushBufferIfNeeded();
            }
        });
    }

    private void handleCompleteEvent(Object event) {
        this.isStreamingDone = true;
        if (this.numRequestsInFlight.get() == 0) {
            this.returnFuture.complete(null);
        }
    }

    public void onError(Throwable t) {
        this.handleError(t);
    }

    private void handleError(Throwable t) {
        this.returnFuture.completeExceptionally(t);
        this.buffer.clear();
    }

    public void onComplete() {
        this.buffer.add(COMPLETE_EVENT);
        this.flushBufferIfNeeded();
    }

    private static boolean isCompleteEvent(Object event) {
        return COMPLETE_EVENT.equals(event);
    }
}

