/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3.internal.progress;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.transfer.s3.progress.TransferProgressSnapshot;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkInternalApi
public final class DefaultTransferProgressSnapshot
implements ToCopyableBuilder<Builder, DefaultTransferProgressSnapshot>,
TransferProgressSnapshot {
    private final long bytesTransferred;
    private final Long transferSizeInBytes;

    private DefaultTransferProgressSnapshot(Builder builder) {
        if (builder.transferSizeInBytes != null) {
            Validate.isNotNegative((long)builder.transferSizeInBytes, (String)"transferSizeInBytes");
            Validate.isTrue((builder.bytesTransferred <= builder.transferSizeInBytes ? 1 : 0) != 0, (String)"bytesTransferred (%s) must not be greater than transferSizeInBytes (%s)", (Object[])new Object[]{builder.bytesTransferred, builder.transferSizeInBytes});
        }
        this.bytesTransferred = Validate.isNotNegative((long)builder.bytesTransferred, (String)"bytesTransferred");
        this.transferSizeInBytes = builder.transferSizeInBytes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    public long bytesTransferred() {
        return this.bytesTransferred;
    }

    @Override
    public Optional<Long> transferSizeInBytes() {
        return Optional.ofNullable(this.transferSizeInBytes);
    }

    @Override
    public Optional<Double> ratioTransferred() {
        return this.transferSizeInBytes().map(Long::doubleValue).map(size -> size == 0.0 ? 1.0 : (double)this.bytesTransferred / size);
    }

    @Override
    public Optional<Long> bytesRemaining() {
        return this.transferSizeInBytes().map(size -> size - this.bytesTransferred);
    }

    public String toString() {
        return ToString.builder((String)"TransferProgressSnapshot").add("bytesTransferred", (Object)this.bytesTransferred).add("transferSizeInBytes", (Object)this.transferSizeInBytes).build();
    }

    public static final class Builder
    implements CopyableBuilder<Builder, DefaultTransferProgressSnapshot> {
        private long bytesTransferred = 0L;
        private Long transferSizeInBytes;

        private Builder() {
        }

        private Builder(DefaultTransferProgressSnapshot snapshot) {
            this.bytesTransferred = snapshot.bytesTransferred;
            this.transferSizeInBytes = snapshot.transferSizeInBytes;
        }

        public Builder bytesTransferred(long bytesTransferred) {
            this.bytesTransferred = bytesTransferred;
            return this;
        }

        public long getBytesTransferred() {
            return this.bytesTransferred;
        }

        public Builder transferSizeInBytes(Long transferSizeInBytes) {
            this.transferSizeInBytes = transferSizeInBytes;
            return this;
        }

        public Long getTransferSizeInBytes() {
            return this.transferSizeInBytes;
        }

        public DefaultTransferProgressSnapshot build() {
            return new DefaultTransferProgressSnapshot(this);
        }
    }
}

