/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3.internal;

import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.SdkTestInternalApi;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.awscore.AwsRequest;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.core.client.config.SdkAdvancedClientOption;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.interceptor.SdkExecutionAttribute;
import software.amazon.awssdk.core.interceptor.SdkInternalExecutionAttribute;
import software.amazon.awssdk.core.retry.RetryPolicy;
import software.amazon.awssdk.core.signer.NoOpSigner;
import software.amazon.awssdk.http.SdkHttpExecutionAttributes;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.S3AsyncClientBuilder;
import software.amazon.awssdk.services.s3.S3Configuration;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Response;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectResponse;
import software.amazon.awssdk.transfer.s3.internal.S3CrtAsyncClient;
import software.amazon.awssdk.transfer.s3.internal.S3CrtAsyncHttpClient;
import software.amazon.awssdk.transfer.s3.internal.S3InternalSdkHttpExecutionAttribute;

@SdkInternalApi
public final class DefaultS3CrtAsyncClient
implements S3CrtAsyncClient {
    private final SdkAsyncHttpClient s3CrtAsyncHttpClient;
    private final S3AsyncClient s3AsyncClient;

    private DefaultS3CrtAsyncClient(DefaultS3CrtClientBuilder builder) {
        this.s3CrtAsyncHttpClient = S3CrtAsyncHttpClient.builder().targetThroughputInGbps(builder.targetThroughputInGbps()).minimumPartSizeInBytes(builder.minimumPartSizeInBytes()).maxConcurrency(builder.maxConcurrency).region(builder.region).credentialsProvider(builder.credentialsProvider).build();
        this.s3AsyncClient = this.initializeS3AsyncClient(builder);
    }

    @SdkTestInternalApi
    DefaultS3CrtAsyncClient(SdkAsyncHttpClient s3CrtAsyncHttpClient, S3AsyncClient s3AsyncClient) {
        this.s3CrtAsyncHttpClient = s3CrtAsyncHttpClient;
        this.s3AsyncClient = s3AsyncClient;
    }

    private S3AsyncClient initializeS3AsyncClient(DefaultS3CrtClientBuilder builder) {
        return (S3AsyncClient)((S3AsyncClientBuilder)((S3AsyncClientBuilder)((S3AsyncClientBuilder)((S3AsyncClientBuilder)((S3AsyncClientBuilder)S3AsyncClient.builder().serviceConfiguration((S3Configuration)S3Configuration.builder().checksumValidationEnabled(Boolean.valueOf(false)).build())).region(builder.region)).credentialsProvider(builder.credentialsProvider)).overrideConfiguration(o -> o.putAdvancedOption(SdkAdvancedClientOption.SIGNER, (Object)new NoOpSigner()).retryPolicy(RetryPolicy.none()).addExecutionInterceptor((ExecutionInterceptor)new AttachHttpAttributesExecutionInterceptor()))).httpClient(this.s3CrtAsyncHttpClient)).build();
    }

    public <ReturnT> CompletableFuture<ReturnT> getObject(GetObjectRequest getObjectRequest, AsyncResponseTransformer<GetObjectResponse, ReturnT> asyncResponseTransformer) {
        DefaultS3CrtAsyncClient.validateOverrideConfiguration((AwsRequest)getObjectRequest);
        return this.s3AsyncClient.getObject(getObjectRequest, asyncResponseTransformer);
    }

    public CompletableFuture<PutObjectResponse> putObject(PutObjectRequest putObjectRequest, AsyncRequestBody requestBody) {
        DefaultS3CrtAsyncClient.validateOverrideConfiguration((AwsRequest)putObjectRequest);
        return this.s3AsyncClient.putObject(putObjectRequest, requestBody);
    }

    public CompletableFuture<ListObjectsV2Response> listObjectsV2(ListObjectsV2Request listObjectsV2Request) {
        return this.s3AsyncClient.listObjectsV2(listObjectsV2Request);
    }

    public String serviceName() {
        return "s3";
    }

    public void close() {
        this.s3CrtAsyncHttpClient.close();
        this.s3AsyncClient.close();
    }

    private static void validateOverrideConfiguration(AwsRequest request) {
        if (request.overrideConfiguration().isPresent()) {
            AwsRequestOverrideConfiguration overrideConfiguration = (AwsRequestOverrideConfiguration)request.overrideConfiguration().get();
            if (overrideConfiguration.signer().isPresent()) {
                throw new UnsupportedOperationException("Request-level signer override is not supported");
            }
            if (overrideConfiguration.credentialsProvider().isPresent()) {
                throw new UnsupportedOperationException("Request-level credentials override is not supported");
            }
        }
    }

    private static final class AttachHttpAttributesExecutionInterceptor
    implements ExecutionInterceptor {
        private AttachHttpAttributesExecutionInterceptor() {
        }

        public void afterMarshalling(Context.AfterMarshalling context, ExecutionAttributes executionAttributes) {
            SdkHttpExecutionAttributes attributes = SdkHttpExecutionAttributes.builder().put(S3InternalSdkHttpExecutionAttribute.OPERATION_NAME, executionAttributes.getAttribute(SdkExecutionAttribute.OPERATION_NAME)).build();
            executionAttributes.putAttribute(SdkInternalExecutionAttribute.SDK_HTTP_EXECUTION_ATTRIBUTES, (Object)attributes);
        }
    }

    public static final class DefaultS3CrtClientBuilder
    implements S3CrtAsyncClient.S3CrtAsyncClientBuilder {
        private AwsCredentialsProvider credentialsProvider;
        private Region region;
        private Long minimalPartSizeInBytes;
        private Double targetThroughputInGbps;
        private Integer maxConcurrency;

        public AwsCredentialsProvider credentialsProvider() {
            return this.credentialsProvider;
        }

        public Region region() {
            return this.region;
        }

        public Long minimumPartSizeInBytes() {
            return this.minimalPartSizeInBytes;
        }

        public Double targetThroughputInGbps() {
            return this.targetThroughputInGbps;
        }

        public Integer maxConcurrency() {
            return this.maxConcurrency;
        }

        @Override
        public S3CrtAsyncClient.S3CrtAsyncClientBuilder credentialsProvider(AwsCredentialsProvider credentialsProvider) {
            this.credentialsProvider = credentialsProvider;
            return this;
        }

        @Override
        public S3CrtAsyncClient.S3CrtAsyncClientBuilder region(Region region) {
            this.region = region;
            return this;
        }

        @Override
        public S3CrtAsyncClient.S3CrtAsyncClientBuilder minimumPartSizeInBytes(Long partSizeBytes) {
            this.minimalPartSizeInBytes = partSizeBytes;
            return this;
        }

        @Override
        public S3CrtAsyncClient.S3CrtAsyncClientBuilder targetThroughputInGbps(Double targetThroughputInGbps) {
            this.targetThroughputInGbps = targetThroughputInGbps;
            return this;
        }

        @Override
        public S3CrtAsyncClient.S3CrtAsyncClientBuilder maxConcurrency(Integer maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        @Override
        public S3CrtAsyncClient build() {
            return new DefaultS3CrtAsyncClient(this);
        }
    }
}

