/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3;

import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkPreviewApi;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.transfer.s3.DirectoryDownload;
import software.amazon.awssdk.transfer.s3.DirectoryUpload;
import software.amazon.awssdk.transfer.s3.Download;
import software.amazon.awssdk.transfer.s3.DownloadDirectoryRequest;
import software.amazon.awssdk.transfer.s3.DownloadFileRequest;
import software.amazon.awssdk.transfer.s3.DownloadRequest;
import software.amazon.awssdk.transfer.s3.FileDownload;
import software.amazon.awssdk.transfer.s3.FileUpload;
import software.amazon.awssdk.transfer.s3.S3ClientConfiguration;
import software.amazon.awssdk.transfer.s3.S3TransferManagerOverrideConfiguration;
import software.amazon.awssdk.transfer.s3.Upload;
import software.amazon.awssdk.transfer.s3.UploadDirectoryRequest;
import software.amazon.awssdk.transfer.s3.UploadFileRequest;
import software.amazon.awssdk.transfer.s3.UploadRequest;
import software.amazon.awssdk.transfer.s3.internal.DefaultS3TransferManager;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.Validate;

@SdkPublicApi
@SdkPreviewApi
public interface S3TransferManager
extends SdkAutoCloseable {
    default public FileDownload downloadFile(DownloadFileRequest downloadRequest) {
        throw new UnsupportedOperationException();
    }

    default public FileDownload downloadFile(Consumer<DownloadFileRequest.Builder> request) {
        return this.downloadFile((DownloadFileRequest)((DownloadFileRequest.Builder)DownloadFileRequest.builder().applyMutation(request)).build());
    }

    default public <ResultT> Download<ResultT> download(DownloadRequest<ResultT> downloadRequest) {
        throw new UnsupportedOperationException();
    }

    default public <ResultT> Download<ResultT> download(Function<DownloadRequest.UntypedBuilder, DownloadRequest.TypedBuilder<ResultT>> request) {
        return this.download((DownloadRequest)DownloadRequest.builder().applyMutation(request).build());
    }

    default public FileUpload uploadFile(UploadFileRequest uploadFileRequest) {
        throw new UnsupportedOperationException();
    }

    default public FileUpload uploadFile(Consumer<UploadFileRequest.Builder> request) {
        return this.uploadFile((UploadFileRequest)((UploadFileRequest.Builder)UploadFileRequest.builder().applyMutation(request)).build());
    }

    default public Upload upload(UploadRequest uploadRequest) {
        throw new UnsupportedOperationException();
    }

    default public Upload upload(Consumer<UploadRequest.Builder> request) {
        return this.upload(((UploadRequest.Builder)UploadRequest.builder().applyMutation(request)).build());
    }

    default public DirectoryUpload uploadDirectory(UploadDirectoryRequest uploadDirectoryRequest) {
        throw new UnsupportedOperationException();
    }

    default public DirectoryUpload uploadDirectory(Consumer<UploadDirectoryRequest.Builder> requestBuilder) {
        Validate.paramNotNull(requestBuilder, (String)"requestBuilder");
        return this.uploadDirectory(((UploadDirectoryRequest.Builder)UploadDirectoryRequest.builder().applyMutation(requestBuilder)).build());
    }

    default public DirectoryDownload downloadDirectory(DownloadDirectoryRequest downloadDirectoryRequest) {
        throw new UnsupportedOperationException();
    }

    default public DirectoryDownload downloadDirectory(Consumer<DownloadDirectoryRequest.Builder> requestBuilder) {
        Validate.paramNotNull(requestBuilder, (String)"requestBuilder");
        return this.downloadDirectory(((DownloadDirectoryRequest.Builder)DownloadDirectoryRequest.builder().applyMutation(requestBuilder)).build());
    }

    public static S3TransferManager create() {
        return S3TransferManager.builder().build();
    }

    public static Builder builder() {
        return DefaultS3TransferManager.builder();
    }

    public static interface Builder {
        public Builder s3ClientConfiguration(S3ClientConfiguration var1);

        default public Builder s3ClientConfiguration(Consumer<S3ClientConfiguration.Builder> configuration) {
            S3ClientConfiguration.Builder builder = S3ClientConfiguration.builder();
            configuration.accept(builder);
            this.s3ClientConfiguration((S3ClientConfiguration)builder.build());
            return this;
        }

        public Builder transferConfiguration(S3TransferManagerOverrideConfiguration var1);

        default public Builder transferConfiguration(Consumer<S3TransferManagerOverrideConfiguration.Builder> configuration) {
            Validate.paramNotNull(configuration, (String)"configuration");
            S3TransferManagerOverrideConfiguration.Builder builder = S3TransferManagerOverrideConfiguration.builder();
            configuration.accept(builder);
            this.transferConfiguration((S3TransferManagerOverrideConfiguration)builder.build());
            return this;
        }

        public S3TransferManager build();
    }
}

