/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3.internal.progress;

import java.util.List;
import java.util.function.Consumer;
import org.slf4j.Logger;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.transfer.s3.progress.TransferListener;
import software.amazon.awssdk.utils.FunctionalUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class TransferListenerInvoker
implements TransferListener {
    private static final software.amazon.awssdk.utils.Logger log = software.amazon.awssdk.utils.Logger.loggerFor(TransferListener.class);
    private final List<TransferListener> listeners;

    public TransferListenerInvoker(List<TransferListener> listeners) {
        this.listeners = (List)Validate.paramNotNull(listeners, (String)"listeners");
    }

    @Override
    public void transferInitiated(TransferListener.Context.TransferInitiated context) {
        this.forEach(listener -> listener.transferInitiated(context));
    }

    @Override
    public void bytesTransferred(TransferListener.Context.BytesTransferred context) {
        this.forEach(listener -> listener.bytesTransferred(context));
    }

    @Override
    public void transferComplete(TransferListener.Context.TransferComplete context) {
        this.forEach(listener -> listener.transferComplete(context));
    }

    @Override
    public void transferFailed(TransferListener.Context.TransferFailed context) {
        this.forEach(listener -> listener.transferFailed(context));
    }

    private void forEach(Consumer<TransferListener> action) {
        for (TransferListener listener : this.listeners) {
            FunctionalUtils.runAndLogError((Logger)log.logger(), (String)"Exception thrown in TransferListener, ignoring", () -> action.accept(listener));
        }
    }
}

