/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import software.amazon.awssdk.annotations.SdkPreviewApi;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.transfer.s3.CompletedDirectoryTransfer;
import software.amazon.awssdk.transfer.s3.FailedFileUpload;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;

@SdkPublicApi
@SdkPreviewApi
public final class CompletedDirectoryUpload
implements CompletedDirectoryTransfer {
    private final Collection<FailedFileUpload> failedTransfers;

    private CompletedDirectoryUpload(DefaultBuilder builder) {
        this.failedTransfers = Collections.unmodifiableCollection((Collection)Validate.paramNotNull((Object)builder.failedTransfers, (String)"failedTransfers"));
    }

    public Collection<FailedFileUpload> failedTransfers() {
        return this.failedTransfers;
    }

    public static Builder builder() {
        return new DefaultBuilder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompletedDirectoryUpload that = (CompletedDirectoryUpload)o;
        return Objects.equals(this.failedTransfers, that.failedTransfers);
    }

    public int hashCode() {
        return this.failedTransfers != null ? this.failedTransfers.hashCode() : 0;
    }

    public String toString() {
        return ToString.builder((String)"CompletedDirectoryUpload").add("failedTransfers", this.failedTransfers).build();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return DefaultBuilder.class;
    }

    private static final class DefaultBuilder
    implements Builder {
        private Collection<FailedFileUpload> failedTransfers;

        private DefaultBuilder() {
        }

        @Override
        public Builder failedTransfers(Collection<FailedFileUpload> failedTransfers) {
            this.failedTransfers = new ArrayList<FailedFileUpload>(failedTransfers);
            return this;
        }

        @Override
        public Builder addFailedTransfer(FailedFileUpload failedTransfer) {
            if (this.failedTransfers == null) {
                this.failedTransfers = new ArrayList<FailedFileUpload>();
            }
            this.failedTransfers.add(failedTransfer);
            return this;
        }

        public Collection<FailedFileUpload> getFailedTransfers() {
            return Collections.unmodifiableCollection(this.failedTransfers);
        }

        public void setFailedTransfers(Collection<FailedFileUpload> failedTransfers) {
            this.failedTransfers(failedTransfers);
        }

        @Override
        public CompletedDirectoryUpload build() {
            return new CompletedDirectoryUpload(this);
        }
    }

    public static interface Builder {
        public Builder failedTransfers(Collection<FailedFileUpload> var1);

        public Builder addFailedTransfer(FailedFileUpload var1);

        public CompletedDirectoryUpload build();
    }
}

