/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.eventnotifications.s3.model;

import java.util.Objects;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.eventnotifications.s3.model.UserIdentity;
import software.amazon.awssdk.utils.ToString;

@SdkPublicApi
public class S3Bucket {
    private final String name;
    private final UserIdentity ownerIdentity;
    private final String arn;

    public S3Bucket(String name, UserIdentity ownerIdentity, String arn) {
        this.name = name;
        this.ownerIdentity = ownerIdentity;
        this.arn = arn;
    }

    public String getName() {
        return this.name;
    }

    public UserIdentity getOwnerIdentity() {
        return this.ownerIdentity;
    }

    public String getArn() {
        return this.arn;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        S3Bucket s3Bucket = (S3Bucket)o;
        if (!Objects.equals(this.name, s3Bucket.name)) {
            return false;
        }
        if (!Objects.equals(this.ownerIdentity, s3Bucket.ownerIdentity)) {
            return false;
        }
        return Objects.equals(this.arn, s3Bucket.arn);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.ownerIdentity != null ? this.ownerIdentity.hashCode() : 0);
        result = 31 * result + (this.arn != null ? this.arn.hashCode() : 0);
        return result;
    }

    public String toString() {
        return ToString.builder((String)"S3Bucket").add("name", (Object)this.name).add("ownerIdentity", (Object)this.ownerIdentity).add("arn", (Object)this.arn).build();
    }
}

