/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.eventnotifications.s3.model;

import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.eventnotifications.s3.internal.S3EventNotificationReader;
import software.amazon.awssdk.eventnotifications.s3.internal.S3EventNotificationWriter;
import software.amazon.awssdk.eventnotifications.s3.model.S3EventNotificationRecord;
import software.amazon.awssdk.utils.ToString;

@SdkPublicApi
public class S3EventNotification {
    private final List<S3EventNotificationRecord> records;

    public S3EventNotification(List<S3EventNotificationRecord> records) {
        this.records = records;
    }

    public List<S3EventNotificationRecord> getRecords() {
        return this.records;
    }

    public static S3EventNotification fromJson(String json) {
        return S3EventNotificationReader.create().read(json);
    }

    public static S3EventNotification fromJson(byte[] json) {
        return S3EventNotificationReader.create().read(json);
    }

    public S3EventNotification fromJson(InputStream json) {
        return S3EventNotificationReader.create().read(json);
    }

    public String toJson() {
        return S3EventNotificationWriter.create().writeToString(this);
    }

    public String toJsonPretty() {
        S3EventNotificationWriter writer = (S3EventNotificationWriter)S3EventNotificationWriter.builder().prettyPrint(true).build();
        return writer.writeToString(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        S3EventNotification that = (S3EventNotification)o;
        return Objects.equals(this.records, that.records);
    }

    public int hashCode() {
        return this.records != null ? this.records.hashCode() : 0;
    }

    public String toString() {
        return ToString.builder((String)"S3EventNotification").add("records", this.records).build();
    }
}

