/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rum.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchCreateRumMetricDefinitionsRequest extends RumRequest implements
        ToCopyableBuilder<BatchCreateRumMetricDefinitionsRequest.Builder, BatchCreateRumMetricDefinitionsRequest> {
    private static final SdkField<String> APP_MONITOR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AppMonitorName").getter(getter(BatchCreateRumMetricDefinitionsRequest::appMonitorName))
            .setter(setter(Builder::appMonitorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AppMonitorName").build()).build();

    private static final SdkField<String> DESTINATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Destination").getter(getter(BatchCreateRumMetricDefinitionsRequest::destinationAsString))
            .setter(setter(Builder::destination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").build()).build();

    private static final SdkField<String> DESTINATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationArn").getter(getter(BatchCreateRumMetricDefinitionsRequest::destinationArn))
            .setter(setter(Builder::destinationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationArn").build()).build();

    private static final SdkField<List<MetricDefinitionRequest>> METRIC_DEFINITIONS_FIELD = SdkField
            .<List<MetricDefinitionRequest>> builder(MarshallingType.LIST)
            .memberName("MetricDefinitions")
            .getter(getter(BatchCreateRumMetricDefinitionsRequest::metricDefinitions))
            .setter(setter(Builder::metricDefinitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricDefinitions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MetricDefinitionRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetricDefinitionRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_MONITOR_NAME_FIELD,
            DESTINATION_FIELD, DESTINATION_ARN_FIELD, METRIC_DEFINITIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String appMonitorName;

    private final String destination;

    private final String destinationArn;

    private final List<MetricDefinitionRequest> metricDefinitions;

    private BatchCreateRumMetricDefinitionsRequest(BuilderImpl builder) {
        super(builder);
        this.appMonitorName = builder.appMonitorName;
        this.destination = builder.destination;
        this.destinationArn = builder.destinationArn;
        this.metricDefinitions = builder.metricDefinitions;
    }

    /**
     * <p>
     * The name of the CloudWatch RUM app monitor that is to send the metrics.
     * </p>
     * 
     * @return The name of the CloudWatch RUM app monitor that is to send the metrics.
     */
    public final String appMonitorName() {
        return appMonitorName;
    }

    /**
     * <p>
     * The destination to send the metrics to. Valid values are <code>CloudWatch</code> and <code>Evidently</code>. If
     * you specify <code>Evidently</code>, you must also specify the Amazon Resource Name (ARN) of the
     * CloudWatchEvidently experiment that will receive the metrics and an IAM role that has permission to write to the
     * experiment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #destination} will
     * return {@link MetricDestination#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #destinationAsString}.
     * </p>
     * 
     * @return The destination to send the metrics to. Valid values are <code>CloudWatch</code> and
     *         <code>Evidently</code>. If you specify <code>Evidently</code>, you must also specify the Amazon Resource
     *         Name (ARN) of the CloudWatchEvidently experiment that will receive the metrics and an IAM role that has
     *         permission to write to the experiment.
     * @see MetricDestination
     */
    public final MetricDestination destination() {
        return MetricDestination.fromValue(destination);
    }

    /**
     * <p>
     * The destination to send the metrics to. Valid values are <code>CloudWatch</code> and <code>Evidently</code>. If
     * you specify <code>Evidently</code>, you must also specify the Amazon Resource Name (ARN) of the
     * CloudWatchEvidently experiment that will receive the metrics and an IAM role that has permission to write to the
     * experiment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #destination} will
     * return {@link MetricDestination#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #destinationAsString}.
     * </p>
     * 
     * @return The destination to send the metrics to. Valid values are <code>CloudWatch</code> and
     *         <code>Evidently</code>. If you specify <code>Evidently</code>, you must also specify the Amazon Resource
     *         Name (ARN) of the CloudWatchEvidently experiment that will receive the metrics and an IAM role that has
     *         permission to write to the experiment.
     * @see MetricDestination
     */
    public final String destinationAsString() {
        return destination;
    }

    /**
     * <p>
     * This parameter is required if <code>Destination</code> is <code>Evidently</code>. If <code>Destination</code> is
     * <code>CloudWatch</code>, do not use this parameter.
     * </p>
     * <p>
     * This parameter specifies the ARN of the Evidently experiment that is to receive the metrics. You must have
     * already defined this experiment as a valid destination. For more information, see <a
     * href="https://docs.aws.amazon.com/cloudwatchrum/latest/APIReference/API_PutRumMetricsDestination.html"
     * >PutRumMetricsDestination</a>.
     * </p>
     * 
     * @return This parameter is required if <code>Destination</code> is <code>Evidently</code>. If
     *         <code>Destination</code> is <code>CloudWatch</code>, do not use this parameter.</p>
     *         <p>
     *         This parameter specifies the ARN of the Evidently experiment that is to receive the metrics. You must
     *         have already defined this experiment as a valid destination. For more information, see <a
     *         href="https://docs.aws.amazon.com/cloudwatchrum/latest/APIReference/API_PutRumMetricsDestination.html"
     *         >PutRumMetricsDestination</a>.
     */
    public final String destinationArn() {
        return destinationArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the MetricDefinitions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMetricDefinitions() {
        return metricDefinitions != null && !(metricDefinitions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of structures which define the metrics that you want to send.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetricDefinitions} method.
     * </p>
     * 
     * @return An array of structures which define the metrics that you want to send.
     */
    public final List<MetricDefinitionRequest> metricDefinitions() {
        return metricDefinitions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appMonitorName());
        hashCode = 31 * hashCode + Objects.hashCode(destinationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(destinationArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasMetricDefinitions() ? metricDefinitions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchCreateRumMetricDefinitionsRequest)) {
            return false;
        }
        BatchCreateRumMetricDefinitionsRequest other = (BatchCreateRumMetricDefinitionsRequest) obj;
        return Objects.equals(appMonitorName(), other.appMonitorName())
                && Objects.equals(destinationAsString(), other.destinationAsString())
                && Objects.equals(destinationArn(), other.destinationArn())
                && hasMetricDefinitions() == other.hasMetricDefinitions()
                && Objects.equals(metricDefinitions(), other.metricDefinitions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchCreateRumMetricDefinitionsRequest").add("AppMonitorName", appMonitorName())
                .add("Destination", destinationAsString()).add("DestinationArn", destinationArn())
                .add("MetricDefinitions", hasMetricDefinitions() ? metricDefinitions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AppMonitorName":
            return Optional.ofNullable(clazz.cast(appMonitorName()));
        case "Destination":
            return Optional.ofNullable(clazz.cast(destinationAsString()));
        case "DestinationArn":
            return Optional.ofNullable(clazz.cast(destinationArn()));
        case "MetricDefinitions":
            return Optional.ofNullable(clazz.cast(metricDefinitions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AppMonitorName", APP_MONITOR_NAME_FIELD);
        map.put("Destination", DESTINATION_FIELD);
        map.put("DestinationArn", DESTINATION_ARN_FIELD);
        map.put("MetricDefinitions", METRIC_DEFINITIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchCreateRumMetricDefinitionsRequest, T> g) {
        return obj -> g.apply((BatchCreateRumMetricDefinitionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends RumRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchCreateRumMetricDefinitionsRequest> {
        /**
         * <p>
         * The name of the CloudWatch RUM app monitor that is to send the metrics.
         * </p>
         * 
         * @param appMonitorName
         *        The name of the CloudWatch RUM app monitor that is to send the metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appMonitorName(String appMonitorName);

        /**
         * <p>
         * The destination to send the metrics to. Valid values are <code>CloudWatch</code> and <code>Evidently</code>.
         * If you specify <code>Evidently</code>, you must also specify the Amazon Resource Name (ARN) of the
         * CloudWatchEvidently experiment that will receive the metrics and an IAM role that has permission to write to
         * the experiment.
         * </p>
         * 
         * @param destination
         *        The destination to send the metrics to. Valid values are <code>CloudWatch</code> and
         *        <code>Evidently</code>. If you specify <code>Evidently</code>, you must also specify the Amazon
         *        Resource Name (ARN) of the CloudWatchEvidently experiment that will receive the metrics and an IAM
         *        role that has permission to write to the experiment.
         * @see MetricDestination
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricDestination
         */
        Builder destination(String destination);

        /**
         * <p>
         * The destination to send the metrics to. Valid values are <code>CloudWatch</code> and <code>Evidently</code>.
         * If you specify <code>Evidently</code>, you must also specify the Amazon Resource Name (ARN) of the
         * CloudWatchEvidently experiment that will receive the metrics and an IAM role that has permission to write to
         * the experiment.
         * </p>
         * 
         * @param destination
         *        The destination to send the metrics to. Valid values are <code>CloudWatch</code> and
         *        <code>Evidently</code>. If you specify <code>Evidently</code>, you must also specify the Amazon
         *        Resource Name (ARN) of the CloudWatchEvidently experiment that will receive the metrics and an IAM
         *        role that has permission to write to the experiment.
         * @see MetricDestination
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricDestination
         */
        Builder destination(MetricDestination destination);

        /**
         * <p>
         * This parameter is required if <code>Destination</code> is <code>Evidently</code>. If <code>Destination</code>
         * is <code>CloudWatch</code>, do not use this parameter.
         * </p>
         * <p>
         * This parameter specifies the ARN of the Evidently experiment that is to receive the metrics. You must have
         * already defined this experiment as a valid destination. For more information, see <a
         * href="https://docs.aws.amazon.com/cloudwatchrum/latest/APIReference/API_PutRumMetricsDestination.html"
         * >PutRumMetricsDestination</a>.
         * </p>
         * 
         * @param destinationArn
         *        This parameter is required if <code>Destination</code> is <code>Evidently</code>. If
         *        <code>Destination</code> is <code>CloudWatch</code>, do not use this parameter.</p>
         *        <p>
         *        This parameter specifies the ARN of the Evidently experiment that is to receive the metrics. You must
         *        have already defined this experiment as a valid destination. For more information, see <a href=
         *        "https://docs.aws.amazon.com/cloudwatchrum/latest/APIReference/API_PutRumMetricsDestination.html"
         *        >PutRumMetricsDestination</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationArn(String destinationArn);

        /**
         * <p>
         * An array of structures which define the metrics that you want to send.
         * </p>
         * 
         * @param metricDefinitions
         *        An array of structures which define the metrics that you want to send.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricDefinitions(Collection<MetricDefinitionRequest> metricDefinitions);

        /**
         * <p>
         * An array of structures which define the metrics that you want to send.
         * </p>
         * 
         * @param metricDefinitions
         *        An array of structures which define the metrics that you want to send.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricDefinitions(MetricDefinitionRequest... metricDefinitions);

        /**
         * <p>
         * An array of structures which define the metrics that you want to send.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rum.model.MetricDefinitionRequest.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.rum.model.MetricDefinitionRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rum.model.MetricDefinitionRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #metricDefinitions(List<MetricDefinitionRequest>)}.
         * 
         * @param metricDefinitions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rum.model.MetricDefinitionRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricDefinitions(java.util.Collection<MetricDefinitionRequest>)
         */
        Builder metricDefinitions(Consumer<MetricDefinitionRequest.Builder>... metricDefinitions);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RumRequest.BuilderImpl implements Builder {
        private String appMonitorName;

        private String destination;

        private String destinationArn;

        private List<MetricDefinitionRequest> metricDefinitions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchCreateRumMetricDefinitionsRequest model) {
            super(model);
            appMonitorName(model.appMonitorName);
            destination(model.destination);
            destinationArn(model.destinationArn);
            metricDefinitions(model.metricDefinitions);
        }

        public final String getAppMonitorName() {
            return appMonitorName;
        }

        public final void setAppMonitorName(String appMonitorName) {
            this.appMonitorName = appMonitorName;
        }

        @Override
        public final Builder appMonitorName(String appMonitorName) {
            this.appMonitorName = appMonitorName;
            return this;
        }

        public final String getDestination() {
            return destination;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        @Override
        public final Builder destination(MetricDestination destination) {
            this.destination(destination == null ? null : destination.toString());
            return this;
        }

        public final String getDestinationArn() {
            return destinationArn;
        }

        public final void setDestinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
        }

        @Override
        public final Builder destinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
            return this;
        }

        public final List<MetricDefinitionRequest.Builder> getMetricDefinitions() {
            List<MetricDefinitionRequest.Builder> result = MetricDefinitionsRequestCopier.copyToBuilder(this.metricDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricDefinitions(Collection<MetricDefinitionRequest.BuilderImpl> metricDefinitions) {
            this.metricDefinitions = MetricDefinitionsRequestCopier.copyFromBuilder(metricDefinitions);
        }

        @Override
        public final Builder metricDefinitions(Collection<MetricDefinitionRequest> metricDefinitions) {
            this.metricDefinitions = MetricDefinitionsRequestCopier.copy(metricDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricDefinitions(MetricDefinitionRequest... metricDefinitions) {
            metricDefinitions(Arrays.asList(metricDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricDefinitions(Consumer<MetricDefinitionRequest.Builder>... metricDefinitions) {
            metricDefinitions(Stream.of(metricDefinitions).map(c -> MetricDefinitionRequest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchCreateRumMetricDefinitionsRequest build() {
            return new BatchCreateRumMetricDefinitionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
