/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rum.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.rum.model.AppMonitorConfiguration;
import software.amazon.awssdk.services.rum.model.AppMonitorDomainListCopier;
import software.amazon.awssdk.services.rum.model.CustomEvents;
import software.amazon.awssdk.services.rum.model.DeobfuscationConfiguration;
import software.amazon.awssdk.services.rum.model.RumRequest;
import software.amazon.awssdk.services.rum.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAppMonitorRequest
extends RumRequest
implements ToCopyableBuilder<Builder, CreateAppMonitorRequest> {
    private static final SdkField<AppMonitorConfiguration> APP_MONITOR_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AppMonitorConfiguration").getter(CreateAppMonitorRequest.getter(CreateAppMonitorRequest::appMonitorConfiguration)).setter(CreateAppMonitorRequest.setter(Builder::appMonitorConfiguration)).constructor(AppMonitorConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppMonitorConfiguration").build()}).build();
    private static final SdkField<CustomEvents> CUSTOM_EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CustomEvents").getter(CreateAppMonitorRequest.getter(CreateAppMonitorRequest::customEvents)).setter(CreateAppMonitorRequest.setter(Builder::customEvents)).constructor(CustomEvents::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomEvents").build()}).build();
    private static final SdkField<Boolean> CW_LOG_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CwLogEnabled").getter(CreateAppMonitorRequest.getter(CreateAppMonitorRequest::cwLogEnabled)).setter(CreateAppMonitorRequest.setter(Builder::cwLogEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CwLogEnabled").build()}).build();
    private static final SdkField<DeobfuscationConfiguration> DEOBFUSCATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DeobfuscationConfiguration").getter(CreateAppMonitorRequest.getter(CreateAppMonitorRequest::deobfuscationConfiguration)).setter(CreateAppMonitorRequest.setter(Builder::deobfuscationConfiguration)).constructor(DeobfuscationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeobfuscationConfiguration").build()}).build();
    private static final SdkField<String> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Domain").getter(CreateAppMonitorRequest.getter(CreateAppMonitorRequest::domain)).setter(CreateAppMonitorRequest.setter(Builder::domain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()}).build();
    private static final SdkField<List<String>> DOMAIN_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DomainList").getter(CreateAppMonitorRequest.getter(CreateAppMonitorRequest::domainList)).setter(CreateAppMonitorRequest.setter(Builder::domainList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateAppMonitorRequest.getter(CreateAppMonitorRequest::name)).setter(CreateAppMonitorRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateAppMonitorRequest.getter(CreateAppMonitorRequest::tags)).setter(CreateAppMonitorRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_MONITOR_CONFIGURATION_FIELD, CUSTOM_EVENTS_FIELD, CW_LOG_ENABLED_FIELD, DEOBFUSCATION_CONFIGURATION_FIELD, DOMAIN_FIELD, DOMAIN_LIST_FIELD, NAME_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateAppMonitorRequest.memberNameToFieldInitializer();
    private final AppMonitorConfiguration appMonitorConfiguration;
    private final CustomEvents customEvents;
    private final Boolean cwLogEnabled;
    private final DeobfuscationConfiguration deobfuscationConfiguration;
    private final String domain;
    private final List<String> domainList;
    private final String name;
    private final Map<String, String> tags;

    private CreateAppMonitorRequest(BuilderImpl builder) {
        super(builder);
        this.appMonitorConfiguration = builder.appMonitorConfiguration;
        this.customEvents = builder.customEvents;
        this.cwLogEnabled = builder.cwLogEnabled;
        this.deobfuscationConfiguration = builder.deobfuscationConfiguration;
        this.domain = builder.domain;
        this.domainList = builder.domainList;
        this.name = builder.name;
        this.tags = builder.tags;
    }

    public final AppMonitorConfiguration appMonitorConfiguration() {
        return this.appMonitorConfiguration;
    }

    public final CustomEvents customEvents() {
        return this.customEvents;
    }

    public final Boolean cwLogEnabled() {
        return this.cwLogEnabled;
    }

    public final DeobfuscationConfiguration deobfuscationConfiguration() {
        return this.deobfuscationConfiguration;
    }

    public final String domain() {
        return this.domain;
    }

    public final boolean hasDomainList() {
        return this.domainList != null && !(this.domainList instanceof SdkAutoConstructList);
    }

    public final List<String> domainList() {
        return this.domainList;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.appMonitorConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.customEvents());
        hashCode = 31 * hashCode + Objects.hashCode(this.cwLogEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.deobfuscationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.domain());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDomainList() ? this.domainList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAppMonitorRequest)) {
            return false;
        }
        CreateAppMonitorRequest other = (CreateAppMonitorRequest)((Object)obj);
        return Objects.equals(this.appMonitorConfiguration(), other.appMonitorConfiguration()) && Objects.equals(this.customEvents(), other.customEvents()) && Objects.equals(this.cwLogEnabled(), other.cwLogEnabled()) && Objects.equals(this.deobfuscationConfiguration(), other.deobfuscationConfiguration()) && Objects.equals(this.domain(), other.domain()) && this.hasDomainList() == other.hasDomainList() && Objects.equals(this.domainList(), other.domainList()) && Objects.equals(this.name(), other.name()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateAppMonitorRequest").add("AppMonitorConfiguration", (Object)this.appMonitorConfiguration()).add("CustomEvents", (Object)this.customEvents()).add("CwLogEnabled", (Object)this.cwLogEnabled()).add("DeobfuscationConfiguration", (Object)this.deobfuscationConfiguration()).add("Domain", (Object)this.domain()).add("DomainList", this.hasDomainList() ? this.domainList() : null).add("Name", (Object)this.name()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AppMonitorConfiguration": {
                return Optional.ofNullable(clazz.cast(this.appMonitorConfiguration()));
            }
            case "CustomEvents": {
                return Optional.ofNullable(clazz.cast(this.customEvents()));
            }
            case "CwLogEnabled": {
                return Optional.ofNullable(clazz.cast(this.cwLogEnabled()));
            }
            case "DeobfuscationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.deobfuscationConfiguration()));
            }
            case "Domain": {
                return Optional.ofNullable(clazz.cast(this.domain()));
            }
            case "DomainList": {
                return Optional.ofNullable(clazz.cast(this.domainList()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AppMonitorConfiguration", APP_MONITOR_CONFIGURATION_FIELD);
        map.put("CustomEvents", CUSTOM_EVENTS_FIELD);
        map.put("CwLogEnabled", CW_LOG_ENABLED_FIELD);
        map.put("DeobfuscationConfiguration", DEOBFUSCATION_CONFIGURATION_FIELD);
        map.put("Domain", DOMAIN_FIELD);
        map.put("DomainList", DOMAIN_LIST_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAppMonitorRequest, T> g) {
        return obj -> g.apply((CreateAppMonitorRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RumRequest.BuilderImpl
    implements Builder {
        private AppMonitorConfiguration appMonitorConfiguration;
        private CustomEvents customEvents;
        private Boolean cwLogEnabled;
        private DeobfuscationConfiguration deobfuscationConfiguration;
        private String domain;
        private List<String> domainList = DefaultSdkAutoConstructList.getInstance();
        private String name;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAppMonitorRequest model) {
            super(model);
            this.appMonitorConfiguration(model.appMonitorConfiguration);
            this.customEvents(model.customEvents);
            this.cwLogEnabled(model.cwLogEnabled);
            this.deobfuscationConfiguration(model.deobfuscationConfiguration);
            this.domain(model.domain);
            this.domainList(model.domainList);
            this.name(model.name);
            this.tags(model.tags);
        }

        public final AppMonitorConfiguration.Builder getAppMonitorConfiguration() {
            return this.appMonitorConfiguration != null ? this.appMonitorConfiguration.toBuilder() : null;
        }

        public final void setAppMonitorConfiguration(AppMonitorConfiguration.BuilderImpl appMonitorConfiguration) {
            this.appMonitorConfiguration = appMonitorConfiguration != null ? appMonitorConfiguration.build() : null;
        }

        @Override
        public final Builder appMonitorConfiguration(AppMonitorConfiguration appMonitorConfiguration) {
            this.appMonitorConfiguration = appMonitorConfiguration;
            return this;
        }

        public final CustomEvents.Builder getCustomEvents() {
            return this.customEvents != null ? this.customEvents.toBuilder() : null;
        }

        public final void setCustomEvents(CustomEvents.BuilderImpl customEvents) {
            this.customEvents = customEvents != null ? customEvents.build() : null;
        }

        @Override
        public final Builder customEvents(CustomEvents customEvents) {
            this.customEvents = customEvents;
            return this;
        }

        public final Boolean getCwLogEnabled() {
            return this.cwLogEnabled;
        }

        public final void setCwLogEnabled(Boolean cwLogEnabled) {
            this.cwLogEnabled = cwLogEnabled;
        }

        @Override
        public final Builder cwLogEnabled(Boolean cwLogEnabled) {
            this.cwLogEnabled = cwLogEnabled;
            return this;
        }

        public final DeobfuscationConfiguration.Builder getDeobfuscationConfiguration() {
            return this.deobfuscationConfiguration != null ? this.deobfuscationConfiguration.toBuilder() : null;
        }

        public final void setDeobfuscationConfiguration(DeobfuscationConfiguration.BuilderImpl deobfuscationConfiguration) {
            this.deobfuscationConfiguration = deobfuscationConfiguration != null ? deobfuscationConfiguration.build() : null;
        }

        @Override
        public final Builder deobfuscationConfiguration(DeobfuscationConfiguration deobfuscationConfiguration) {
            this.deobfuscationConfiguration = deobfuscationConfiguration;
            return this;
        }

        public final String getDomain() {
            return this.domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final Collection<String> getDomainList() {
            if (this.domainList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.domainList;
        }

        public final void setDomainList(Collection<String> domainList) {
            this.domainList = AppMonitorDomainListCopier.copy(domainList);
        }

        @Override
        public final Builder domainList(Collection<String> domainList) {
            this.domainList = AppMonitorDomainListCopier.copy(domainList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainList(String ... domainList) {
            this.domainList(Arrays.asList(domainList));
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAppMonitorRequest build() {
            return new CreateAppMonitorRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RumRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAppMonitorRequest> {
        public Builder appMonitorConfiguration(AppMonitorConfiguration var1);

        default public Builder appMonitorConfiguration(Consumer<AppMonitorConfiguration.Builder> appMonitorConfiguration) {
            return this.appMonitorConfiguration((AppMonitorConfiguration)((AppMonitorConfiguration.Builder)AppMonitorConfiguration.builder().applyMutation(appMonitorConfiguration)).build());
        }

        public Builder customEvents(CustomEvents var1);

        default public Builder customEvents(Consumer<CustomEvents.Builder> customEvents) {
            return this.customEvents((CustomEvents)((CustomEvents.Builder)CustomEvents.builder().applyMutation(customEvents)).build());
        }

        public Builder cwLogEnabled(Boolean var1);

        public Builder deobfuscationConfiguration(DeobfuscationConfiguration var1);

        default public Builder deobfuscationConfiguration(Consumer<DeobfuscationConfiguration.Builder> deobfuscationConfiguration) {
            return this.deobfuscationConfiguration((DeobfuscationConfiguration)((DeobfuscationConfiguration.Builder)DeobfuscationConfiguration.builder().applyMutation(deobfuscationConfiguration)).build());
        }

        public Builder domain(String var1);

        public Builder domainList(Collection<String> var1);

        public Builder domainList(String ... var1);

        public Builder name(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

