/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rum.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rum.model.MetricDestination;
import software.amazon.awssdk.services.rum.model.RumRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetRumMetricDefinitionsRequest
extends RumRequest
implements ToCopyableBuilder<Builder, BatchGetRumMetricDefinitionsRequest> {
    private static final SdkField<String> APP_MONITOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AppMonitorName").getter(BatchGetRumMetricDefinitionsRequest.getter(BatchGetRumMetricDefinitionsRequest::appMonitorName)).setter(BatchGetRumMetricDefinitionsRequest.setter(Builder::appMonitorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("AppMonitorName").build()}).build();
    private static final SdkField<String> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Destination").getter(BatchGetRumMetricDefinitionsRequest.getter(BatchGetRumMetricDefinitionsRequest::destinationAsString)).setter(BatchGetRumMetricDefinitionsRequest.setter(Builder::destination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("destination").build()}).build();
    private static final SdkField<String> DESTINATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationArn").getter(BatchGetRumMetricDefinitionsRequest.getter(BatchGetRumMetricDefinitionsRequest::destinationArn)).setter(BatchGetRumMetricDefinitionsRequest.setter(Builder::destinationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("destinationArn").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(BatchGetRumMetricDefinitionsRequest.getter(BatchGetRumMetricDefinitionsRequest::maxResults)).setter(BatchGetRumMetricDefinitionsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(BatchGetRumMetricDefinitionsRequest.getter(BatchGetRumMetricDefinitionsRequest::nextToken)).setter(BatchGetRumMetricDefinitionsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_MONITOR_NAME_FIELD, DESTINATION_FIELD, DESTINATION_ARN_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchGetRumMetricDefinitionsRequest.memberNameToFieldInitializer();
    private final String appMonitorName;
    private final String destination;
    private final String destinationArn;
    private final Integer maxResults;
    private final String nextToken;

    private BatchGetRumMetricDefinitionsRequest(BuilderImpl builder) {
        super(builder);
        this.appMonitorName = builder.appMonitorName;
        this.destination = builder.destination;
        this.destinationArn = builder.destinationArn;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final String appMonitorName() {
        return this.appMonitorName;
    }

    public final MetricDestination destination() {
        return MetricDestination.fromValue(this.destination);
    }

    public final String destinationAsString() {
        return this.destination;
    }

    public final String destinationArn() {
        return this.destinationArn;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.appMonitorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetRumMetricDefinitionsRequest)) {
            return false;
        }
        BatchGetRumMetricDefinitionsRequest other = (BatchGetRumMetricDefinitionsRequest)((Object)obj);
        return Objects.equals(this.appMonitorName(), other.appMonitorName()) && Objects.equals(this.destinationAsString(), other.destinationAsString()) && Objects.equals(this.destinationArn(), other.destinationArn()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetRumMetricDefinitionsRequest").add("AppMonitorName", (Object)this.appMonitorName()).add("Destination", (Object)this.destinationAsString()).add("DestinationArn", (Object)this.destinationArn()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AppMonitorName": {
                return Optional.ofNullable(clazz.cast(this.appMonitorName()));
            }
            case "Destination": {
                return Optional.ofNullable(clazz.cast(this.destinationAsString()));
            }
            case "DestinationArn": {
                return Optional.ofNullable(clazz.cast(this.destinationArn()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AppMonitorName", APP_MONITOR_NAME_FIELD);
        map.put("destination", DESTINATION_FIELD);
        map.put("destinationArn", DESTINATION_ARN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetRumMetricDefinitionsRequest, T> g) {
        return obj -> g.apply((BatchGetRumMetricDefinitionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RumRequest.BuilderImpl
    implements Builder {
        private String appMonitorName;
        private String destination;
        private String destinationArn;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetRumMetricDefinitionsRequest model) {
            super(model);
            this.appMonitorName(model.appMonitorName);
            this.destination(model.destination);
            this.destinationArn(model.destinationArn);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getAppMonitorName() {
            return this.appMonitorName;
        }

        public final void setAppMonitorName(String appMonitorName) {
            this.appMonitorName = appMonitorName;
        }

        @Override
        public final Builder appMonitorName(String appMonitorName) {
            this.appMonitorName = appMonitorName;
            return this;
        }

        public final String getDestination() {
            return this.destination;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        @Override
        public final Builder destination(MetricDestination destination) {
            this.destination(destination == null ? null : destination.toString());
            return this;
        }

        public final String getDestinationArn() {
            return this.destinationArn;
        }

        public final void setDestinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
        }

        @Override
        public final Builder destinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetRumMetricDefinitionsRequest build() {
            return new BatchGetRumMetricDefinitionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RumRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetRumMetricDefinitionsRequest> {
        public Builder appMonitorName(String var1);

        public Builder destination(String var1);

        public Builder destination(MetricDestination var1);

        public Builder destinationArn(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

