/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rum.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rum.RumClient;
import software.amazon.awssdk.services.rum.model.GetAppMonitorDataRequest;
import software.amazon.awssdk.services.rum.model.GetAppMonitorDataResponse;

public class GetAppMonitorDataIterable
implements SdkIterable<GetAppMonitorDataResponse> {
    private final RumClient client;
    private final GetAppMonitorDataRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetAppMonitorDataIterable(RumClient client, GetAppMonitorDataRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetAppMonitorDataResponseFetcher();
    }

    public Iterator<GetAppMonitorDataResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> events() {
        Function<GetAppMonitorDataResponse, Iterator> getIterator = response -> {
            if (response != null && response.events() != null) {
                return response.events().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetAppMonitorDataResponseFetcher
    implements SyncPageFetcher<GetAppMonitorDataResponse> {
        private GetAppMonitorDataResponseFetcher() {
        }

        public boolean hasNextPage(GetAppMonitorDataResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetAppMonitorDataResponse nextPage(GetAppMonitorDataResponse previousPage) {
            if (previousPage == null) {
                return GetAppMonitorDataIterable.this.client.getAppMonitorData(GetAppMonitorDataIterable.this.firstRequest);
            }
            return GetAppMonitorDataIterable.this.client.getAppMonitorData((GetAppMonitorDataRequest)((Object)GetAppMonitorDataIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

