/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rum.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rum.RumAsyncClient;
import software.amazon.awssdk.services.rum.model.ListRumMetricsDestinationsRequest;
import software.amazon.awssdk.services.rum.model.ListRumMetricsDestinationsResponse;
import software.amazon.awssdk.services.rum.model.MetricDestinationSummary;

public class ListRumMetricsDestinationsPublisher
implements SdkPublisher<ListRumMetricsDestinationsResponse> {
    private final RumAsyncClient client;
    private final ListRumMetricsDestinationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRumMetricsDestinationsPublisher(RumAsyncClient client, ListRumMetricsDestinationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRumMetricsDestinationsPublisher(RumAsyncClient client, ListRumMetricsDestinationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRumMetricsDestinationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRumMetricsDestinationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<MetricDestinationSummary> destinations() {
        Function<ListRumMetricsDestinationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.destinations() != null) {
                return response.destinations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListRumMetricsDestinationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListRumMetricsDestinationsResponseFetcher
    implements AsyncPageFetcher<ListRumMetricsDestinationsResponse> {
        private ListRumMetricsDestinationsResponseFetcher() {
        }

        public boolean hasNextPage(ListRumMetricsDestinationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRumMetricsDestinationsResponse> nextPage(ListRumMetricsDestinationsResponse previousPage) {
            if (previousPage == null) {
                return ListRumMetricsDestinationsPublisher.this.client.listRumMetricsDestinations(ListRumMetricsDestinationsPublisher.this.firstRequest);
            }
            return ListRumMetricsDestinationsPublisher.this.client.listRumMetricsDestinations((ListRumMetricsDestinationsRequest)((Object)ListRumMetricsDestinationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

