/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rum;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.rum.DefaultRumAsyncClient;
import software.amazon.awssdk.services.rum.DefaultRumBaseClientBuilder;
import software.amazon.awssdk.services.rum.RumAsyncClient;
import software.amazon.awssdk.services.rum.RumAsyncClientBuilder;
import software.amazon.awssdk.services.rum.RumServiceClientConfiguration;
import software.amazon.awssdk.services.rum.endpoints.RumEndpointProvider;

@SdkInternalApi
final class DefaultRumAsyncClientBuilder
extends DefaultRumBaseClientBuilder<RumAsyncClientBuilder, RumAsyncClient>
implements RumAsyncClientBuilder {
    DefaultRumAsyncClientBuilder() {
    }

    @Override
    public DefaultRumAsyncClientBuilder endpointProvider(RumEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final RumAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultRumAsyncClientBuilder.validateClientOptions(clientConfiguration);
        RumServiceClientConfiguration serviceClientConfiguration = RumServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).build();
        return new DefaultRumAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

