/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rum;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.rum.DefaultRumAsyncClient;
import software.amazon.awssdk.services.rum.DefaultRumBaseClientBuilder;
import software.amazon.awssdk.services.rum.RumAsyncClient;
import software.amazon.awssdk.services.rum.RumAsyncClientBuilder;
import software.amazon.awssdk.services.rum.RumServiceClientConfiguration;
import software.amazon.awssdk.services.rum.endpoints.RumEndpointProvider;

@SdkInternalApi
final class DefaultRumAsyncClientBuilder
extends DefaultRumBaseClientBuilder<RumAsyncClientBuilder, RumAsyncClient>
implements RumAsyncClientBuilder {
    DefaultRumAsyncClientBuilder() {
    }

    @Override
    public DefaultRumAsyncClientBuilder endpointProvider(RumEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final RumAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultRumAsyncClientBuilder.validateClientOptions(clientConfiguration);
        RumServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultRumAsyncClient client = new DefaultRumAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private RumServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return RumServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

