/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rum.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rum.RumClient;
import software.amazon.awssdk.services.rum.model.AppMonitorSummary;
import software.amazon.awssdk.services.rum.model.ListAppMonitorsRequest;
import software.amazon.awssdk.services.rum.model.ListAppMonitorsResponse;

public class ListAppMonitorsIterable
implements SdkIterable<ListAppMonitorsResponse> {
    private final RumClient client;
    private final ListAppMonitorsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAppMonitorsIterable(RumClient client, ListAppMonitorsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListAppMonitorsResponseFetcher();
    }

    public Iterator<ListAppMonitorsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AppMonitorSummary> appMonitorSummaries() {
        Function<ListAppMonitorsResponse, Iterator> getIterator = response -> {
            if (response != null && response.appMonitorSummaries() != null) {
                return response.appMonitorSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAppMonitorsResponseFetcher
    implements SyncPageFetcher<ListAppMonitorsResponse> {
        private ListAppMonitorsResponseFetcher() {
        }

        public boolean hasNextPage(ListAppMonitorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAppMonitorsResponse nextPage(ListAppMonitorsResponse previousPage) {
            if (previousPage == null) {
                return ListAppMonitorsIterable.this.client.listAppMonitors(ListAppMonitorsIterable.this.firstRequest);
            }
            return ListAppMonitorsIterable.this.client.listAppMonitors((ListAppMonitorsRequest)((Object)ListAppMonitorsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

