/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rtbfabric.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rtbfabric.model.ResponderErrorMaskingAction;
import software.amazon.awssdk.services.rtbfabric.model.ResponderErrorMaskingLoggingType;
import software.amazon.awssdk.services.rtbfabric.model.ResponderErrorMaskingLoggingTypesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResponderErrorMaskingForHttpCode
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResponderErrorMaskingForHttpCode> {
    private static final SdkField<String> HTTP_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("httpCode").getter(ResponderErrorMaskingForHttpCode.getter(ResponderErrorMaskingForHttpCode::httpCode)).setter(ResponderErrorMaskingForHttpCode.setter(Builder::httpCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("httpCode").build()}).build();
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("action").getter(ResponderErrorMaskingForHttpCode.getter(ResponderErrorMaskingForHttpCode::actionAsString)).setter(ResponderErrorMaskingForHttpCode.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()}).build();
    private static final SdkField<List<String>> LOGGING_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("loggingTypes").getter(ResponderErrorMaskingForHttpCode.getter(ResponderErrorMaskingForHttpCode::loggingTypesAsStrings)).setter(ResponderErrorMaskingForHttpCode.setter(Builder::loggingTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loggingTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Float> RESPONSE_LOGGING_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("responseLoggingPercentage").getter(ResponderErrorMaskingForHttpCode.getter(ResponderErrorMaskingForHttpCode::responseLoggingPercentage)).setter(ResponderErrorMaskingForHttpCode.setter(Builder::responseLoggingPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseLoggingPercentage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HTTP_CODE_FIELD, ACTION_FIELD, LOGGING_TYPES_FIELD, RESPONSE_LOGGING_PERCENTAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ResponderErrorMaskingForHttpCode.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String httpCode;
    private final String action;
    private final List<String> loggingTypes;
    private final Float responseLoggingPercentage;

    private ResponderErrorMaskingForHttpCode(BuilderImpl builder) {
        this.httpCode = builder.httpCode;
        this.action = builder.action;
        this.loggingTypes = builder.loggingTypes;
        this.responseLoggingPercentage = builder.responseLoggingPercentage;
    }

    public final String httpCode() {
        return this.httpCode;
    }

    public final ResponderErrorMaskingAction action() {
        return ResponderErrorMaskingAction.fromValue(this.action);
    }

    public final String actionAsString() {
        return this.action;
    }

    public final List<ResponderErrorMaskingLoggingType> loggingTypes() {
        return ResponderErrorMaskingLoggingTypesCopier.copyStringToEnum(this.loggingTypes);
    }

    public final boolean hasLoggingTypes() {
        return this.loggingTypes != null && !(this.loggingTypes instanceof SdkAutoConstructList);
    }

    public final List<String> loggingTypesAsStrings() {
        return this.loggingTypes;
    }

    public final Float responseLoggingPercentage() {
        return this.responseLoggingPercentage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.httpCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLoggingTypes() ? this.loggingTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.responseLoggingPercentage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResponderErrorMaskingForHttpCode)) {
            return false;
        }
        ResponderErrorMaskingForHttpCode other = (ResponderErrorMaskingForHttpCode)obj;
        return Objects.equals(this.httpCode(), other.httpCode()) && Objects.equals(this.actionAsString(), other.actionAsString()) && this.hasLoggingTypes() == other.hasLoggingTypes() && Objects.equals(this.loggingTypesAsStrings(), other.loggingTypesAsStrings()) && Objects.equals(this.responseLoggingPercentage(), other.responseLoggingPercentage());
    }

    public final String toString() {
        return ToString.builder((String)"ResponderErrorMaskingForHttpCode").add("HttpCode", (Object)this.httpCode()).add("Action", (Object)this.actionAsString()).add("LoggingTypes", this.hasLoggingTypes() ? this.loggingTypesAsStrings() : null).add("ResponseLoggingPercentage", (Object)this.responseLoggingPercentage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "httpCode": {
                return Optional.ofNullable(clazz.cast(this.httpCode()));
            }
            case "action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
            case "loggingTypes": {
                return Optional.ofNullable(clazz.cast(this.loggingTypesAsStrings()));
            }
            case "responseLoggingPercentage": {
                return Optional.ofNullable(clazz.cast(this.responseLoggingPercentage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("httpCode", HTTP_CODE_FIELD);
        map.put("action", ACTION_FIELD);
        map.put("loggingTypes", LOGGING_TYPES_FIELD);
        map.put("responseLoggingPercentage", RESPONSE_LOGGING_PERCENTAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResponderErrorMaskingForHttpCode, T> g) {
        return obj -> g.apply((ResponderErrorMaskingForHttpCode)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String httpCode;
        private String action;
        private List<String> loggingTypes = DefaultSdkAutoConstructList.getInstance();
        private Float responseLoggingPercentage;

        private BuilderImpl() {
        }

        private BuilderImpl(ResponderErrorMaskingForHttpCode model) {
            this.httpCode(model.httpCode);
            this.action(model.action);
            this.loggingTypesWithStrings(model.loggingTypes);
            this.responseLoggingPercentage(model.responseLoggingPercentage);
        }

        public final String getHttpCode() {
            return this.httpCode;
        }

        public final void setHttpCode(String httpCode) {
            this.httpCode = httpCode;
        }

        @Override
        public final Builder httpCode(String httpCode) {
            this.httpCode = httpCode;
            return this;
        }

        public final String getAction() {
            return this.action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(ResponderErrorMaskingAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final Collection<String> getLoggingTypes() {
            if (this.loggingTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.loggingTypes;
        }

        public final void setLoggingTypes(Collection<String> loggingTypes) {
            this.loggingTypes = ResponderErrorMaskingLoggingTypesCopier.copy(loggingTypes);
        }

        @Override
        public final Builder loggingTypesWithStrings(Collection<String> loggingTypes) {
            this.loggingTypes = ResponderErrorMaskingLoggingTypesCopier.copy(loggingTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loggingTypesWithStrings(String ... loggingTypes) {
            this.loggingTypesWithStrings(Arrays.asList(loggingTypes));
            return this;
        }

        @Override
        public final Builder loggingTypes(Collection<ResponderErrorMaskingLoggingType> loggingTypes) {
            this.loggingTypes = ResponderErrorMaskingLoggingTypesCopier.copyEnumToString(loggingTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loggingTypes(ResponderErrorMaskingLoggingType ... loggingTypes) {
            this.loggingTypes(Arrays.asList(loggingTypes));
            return this;
        }

        public final Float getResponseLoggingPercentage() {
            return this.responseLoggingPercentage;
        }

        public final void setResponseLoggingPercentage(Float responseLoggingPercentage) {
            this.responseLoggingPercentage = responseLoggingPercentage;
        }

        @Override
        public final Builder responseLoggingPercentage(Float responseLoggingPercentage) {
            this.responseLoggingPercentage = responseLoggingPercentage;
            return this;
        }

        public ResponderErrorMaskingForHttpCode build() {
            return new ResponderErrorMaskingForHttpCode(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResponderErrorMaskingForHttpCode> {
        public Builder httpCode(String var1);

        public Builder action(String var1);

        public Builder action(ResponderErrorMaskingAction var1);

        public Builder loggingTypesWithStrings(Collection<String> var1);

        public Builder loggingTypesWithStrings(String ... var1);

        public Builder loggingTypes(Collection<ResponderErrorMaskingLoggingType> var1);

        public Builder loggingTypes(ResponderErrorMaskingLoggingType ... var1);

        public Builder responseLoggingPercentage(Float var1);
    }
}

