/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rtbfabric.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rtbfabric.RtbFabricAsyncClient;
import software.amazon.awssdk.services.rtbfabric.internal.UserAgentUtils;
import software.amazon.awssdk.services.rtbfabric.model.ListResponderGatewaysRequest;
import software.amazon.awssdk.services.rtbfabric.model.ListResponderGatewaysResponse;

public class ListResponderGatewaysPublisher
implements SdkPublisher<ListResponderGatewaysResponse> {
    private final RtbFabricAsyncClient client;
    private final ListResponderGatewaysRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListResponderGatewaysPublisher(RtbFabricAsyncClient client, ListResponderGatewaysRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListResponderGatewaysPublisher(RtbFabricAsyncClient client, ListResponderGatewaysRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListResponderGatewaysResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListResponderGatewaysResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> gatewayIds() {
        Function<ListResponderGatewaysResponse, Iterator> getIterator = response -> {
            if (response != null && response.gatewayIds() != null) {
                return response.gatewayIds().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListResponderGatewaysResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListResponderGatewaysResponseFetcher
    implements AsyncPageFetcher<ListResponderGatewaysResponse> {
        private ListResponderGatewaysResponseFetcher() {
        }

        public boolean hasNextPage(ListResponderGatewaysResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListResponderGatewaysResponse> nextPage(ListResponderGatewaysResponse previousPage) {
            if (previousPage == null) {
                return ListResponderGatewaysPublisher.this.client.listResponderGateways(ListResponderGatewaysPublisher.this.firstRequest);
            }
            return ListResponderGatewaysPublisher.this.client.listResponderGateways((ListResponderGatewaysRequest)((Object)ListResponderGatewaysPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

