/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rtbfabric.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rtbfabric.model.CertificateAuthorityCertificatesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TrustStoreConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TrustStoreConfiguration> {
    private static final SdkField<List<String>> CERTIFICATE_AUTHORITY_CERTIFICATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("certificateAuthorityCertificates").getter(TrustStoreConfiguration.getter(TrustStoreConfiguration::certificateAuthorityCertificates)).setter(TrustStoreConfiguration.setter(Builder::certificateAuthorityCertificates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateAuthorityCertificates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_AUTHORITY_CERTIFICATES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TrustStoreConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> certificateAuthorityCertificates;

    private TrustStoreConfiguration(BuilderImpl builder) {
        this.certificateAuthorityCertificates = builder.certificateAuthorityCertificates;
    }

    public final boolean hasCertificateAuthorityCertificates() {
        return this.certificateAuthorityCertificates != null && !(this.certificateAuthorityCertificates instanceof SdkAutoConstructList);
    }

    public final List<String> certificateAuthorityCertificates() {
        return this.certificateAuthorityCertificates;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCertificateAuthorityCertificates() ? this.certificateAuthorityCertificates() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrustStoreConfiguration)) {
            return false;
        }
        TrustStoreConfiguration other = (TrustStoreConfiguration)obj;
        return this.hasCertificateAuthorityCertificates() == other.hasCertificateAuthorityCertificates() && Objects.equals(this.certificateAuthorityCertificates(), other.certificateAuthorityCertificates());
    }

    public final String toString() {
        return ToString.builder((String)"TrustStoreConfiguration").add("CertificateAuthorityCertificates", (Object)(this.certificateAuthorityCertificates() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "certificateAuthorityCertificates": {
                return Optional.ofNullable(clazz.cast(this.certificateAuthorityCertificates()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("certificateAuthorityCertificates", CERTIFICATE_AUTHORITY_CERTIFICATES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TrustStoreConfiguration, T> g) {
        return obj -> g.apply((TrustStoreConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> certificateAuthorityCertificates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TrustStoreConfiguration model) {
            this.certificateAuthorityCertificates(model.certificateAuthorityCertificates);
        }

        public final Collection<String> getCertificateAuthorityCertificates() {
            if (this.certificateAuthorityCertificates instanceof SdkAutoConstructList) {
                return null;
            }
            return this.certificateAuthorityCertificates;
        }

        public final void setCertificateAuthorityCertificates(Collection<String> certificateAuthorityCertificates) {
            this.certificateAuthorityCertificates = CertificateAuthorityCertificatesCopier.copy(certificateAuthorityCertificates);
        }

        @Override
        public final Builder certificateAuthorityCertificates(Collection<String> certificateAuthorityCertificates) {
            this.certificateAuthorityCertificates = CertificateAuthorityCertificatesCopier.copy(certificateAuthorityCertificates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificateAuthorityCertificates(String ... certificateAuthorityCertificates) {
            this.certificateAuthorityCertificates(Arrays.asList(certificateAuthorityCertificates));
            return this;
        }

        public TrustStoreConfiguration build() {
            return new TrustStoreConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TrustStoreConfiguration> {
        public Builder certificateAuthorityCertificates(Collection<String> var1);

        public Builder certificateAuthorityCertificates(String ... var1);
    }
}

