/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rtbfabric.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rtbfabric.model.AutoScalingGroupNameListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutoScalingGroupsConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutoScalingGroupsConfiguration> {
    private static final SdkField<List<String>> AUTO_SCALING_GROUP_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("autoScalingGroupNames").getter(AutoScalingGroupsConfiguration.getter(AutoScalingGroupsConfiguration::autoScalingGroupNames)).setter(AutoScalingGroupsConfiguration.setter(Builder::autoScalingGroupNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoScalingGroupNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(AutoScalingGroupsConfiguration.getter(AutoScalingGroupsConfiguration::roleArn)).setter(AutoScalingGroupsConfiguration.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_SCALING_GROUP_NAMES_FIELD, ROLE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AutoScalingGroupsConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> autoScalingGroupNames;
    private final String roleArn;

    private AutoScalingGroupsConfiguration(BuilderImpl builder) {
        this.autoScalingGroupNames = builder.autoScalingGroupNames;
        this.roleArn = builder.roleArn;
    }

    public final boolean hasAutoScalingGroupNames() {
        return this.autoScalingGroupNames != null && !(this.autoScalingGroupNames instanceof SdkAutoConstructList);
    }

    public final List<String> autoScalingGroupNames() {
        return this.autoScalingGroupNames;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAutoScalingGroupNames() ? this.autoScalingGroupNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoScalingGroupsConfiguration)) {
            return false;
        }
        AutoScalingGroupsConfiguration other = (AutoScalingGroupsConfiguration)obj;
        return this.hasAutoScalingGroupNames() == other.hasAutoScalingGroupNames() && Objects.equals(this.autoScalingGroupNames(), other.autoScalingGroupNames()) && Objects.equals(this.roleArn(), other.roleArn());
    }

    public final String toString() {
        return ToString.builder((String)"AutoScalingGroupsConfiguration").add("AutoScalingGroupNames", this.hasAutoScalingGroupNames() ? this.autoScalingGroupNames() : null).add("RoleArn", (Object)this.roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "autoScalingGroupNames": {
                return Optional.ofNullable(clazz.cast(this.autoScalingGroupNames()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("autoScalingGroupNames", AUTO_SCALING_GROUP_NAMES_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutoScalingGroupsConfiguration, T> g) {
        return obj -> g.apply((AutoScalingGroupsConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> autoScalingGroupNames = DefaultSdkAutoConstructList.getInstance();
        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoScalingGroupsConfiguration model) {
            this.autoScalingGroupNames(model.autoScalingGroupNames);
            this.roleArn(model.roleArn);
        }

        public final Collection<String> getAutoScalingGroupNames() {
            if (this.autoScalingGroupNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.autoScalingGroupNames;
        }

        public final void setAutoScalingGroupNames(Collection<String> autoScalingGroupNames) {
            this.autoScalingGroupNames = AutoScalingGroupNameListCopier.copy(autoScalingGroupNames);
        }

        @Override
        public final Builder autoScalingGroupNames(Collection<String> autoScalingGroupNames) {
            this.autoScalingGroupNames = AutoScalingGroupNameListCopier.copy(autoScalingGroupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoScalingGroupNames(String ... autoScalingGroupNames) {
            this.autoScalingGroupNames(Arrays.asList(autoScalingGroupNames));
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public AutoScalingGroupsConfiguration build() {
            return new AutoScalingGroupsConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutoScalingGroupsConfiguration> {
        public Builder autoScalingGroupNames(Collection<String> var1);

        public Builder autoScalingGroupNames(String ... var1);

        public Builder roleArn(String var1);
    }
}

