/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rtbfabric.waiters;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.services.rtbfabric.RtbFabricAsyncClient;
import software.amazon.awssdk.services.rtbfabric.model.GetInboundExternalLinkRequest;
import software.amazon.awssdk.services.rtbfabric.model.GetInboundExternalLinkResponse;
import software.amazon.awssdk.services.rtbfabric.model.GetLinkRequest;
import software.amazon.awssdk.services.rtbfabric.model.GetLinkResponse;
import software.amazon.awssdk.services.rtbfabric.model.GetOutboundExternalLinkRequest;
import software.amazon.awssdk.services.rtbfabric.model.GetOutboundExternalLinkResponse;
import software.amazon.awssdk.services.rtbfabric.model.GetRequesterGatewayRequest;
import software.amazon.awssdk.services.rtbfabric.model.GetRequesterGatewayResponse;
import software.amazon.awssdk.services.rtbfabric.model.GetResponderGatewayRequest;
import software.amazon.awssdk.services.rtbfabric.model.GetResponderGatewayResponse;
import software.amazon.awssdk.utils.SdkAutoCloseable;

/**
 * Waiter utility class that polls a resource until a desired state is reached or until it is determined that the
 * resource will never enter into the desired state. This can be created using the static {@link #builder()} method
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
@Immutable
public interface RtbFabricAsyncWaiter extends SdkAutoCloseable {
    /**
     * Polls {@link RtbFabricAsyncClient#getInboundExternalLink} API until the desired condition
     * {@code InboundExternalLinkActive} is met, or until it is determined that the resource will never enter into the
     * desired state
     *
     * @param getInboundExternalLinkRequest
     *        the request to be used for polling
     * @return CompletableFuture containing the WaiterResponse. It completes successfully when the resource enters into
     *         a desired state or exceptionally when it is determined that the resource will never enter into the
     *         desired state.
     */
    default CompletableFuture<WaiterResponse<GetInboundExternalLinkResponse>> waitUntilInboundExternalLinkActive(
            GetInboundExternalLinkRequest getInboundExternalLinkRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link RtbFabricAsyncClient#getInboundExternalLink} API until the desired condition
     * {@code InboundExternalLinkActive} is met, or until it is determined that the resource will never enter into the
     * desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link GetInboundExternalLinkRequest#builder()}
     *
     * @param getInboundExternalLinkRequest
     *        The consumer that will configure the request to be used for polling
     * @return CompletableFuture of the WaiterResponse containing either a response or an exception that has matched
     *         with the waiter success condition
     */
    default CompletableFuture<WaiterResponse<GetInboundExternalLinkResponse>> waitUntilInboundExternalLinkActive(
            Consumer<GetInboundExternalLinkRequest.Builder> getInboundExternalLinkRequest) {
        return waitUntilInboundExternalLinkActive(GetInboundExternalLinkRequest.builder()
                .applyMutation(getInboundExternalLinkRequest).build());
    }

    /**
     * Polls {@link RtbFabricAsyncClient#getInboundExternalLink} API until the desired condition
     * {@code InboundExternalLinkActive} is met, or until it is determined that the resource will never enter into the
     * desired state
     *
     * @param getInboundExternalLinkRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<GetInboundExternalLinkResponse>> waitUntilInboundExternalLinkActive(
            GetInboundExternalLinkRequest getInboundExternalLinkRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link RtbFabricAsyncClient#getInboundExternalLink} API until the desired condition
     * {@code InboundExternalLinkActive} is met, or until it is determined that the resource will never enter into the
     * desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param getInboundExternalLinkRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<GetInboundExternalLinkResponse>> waitUntilInboundExternalLinkActive(
            Consumer<GetInboundExternalLinkRequest.Builder> getInboundExternalLinkRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilInboundExternalLinkActive(
                GetInboundExternalLinkRequest.builder().applyMutation(getInboundExternalLinkRequest).build(),
                WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link RtbFabricAsyncClient#getLink} API until the desired condition {@code LinkAccepted} is met, or until
     * it is determined that the resource will never enter into the desired state
     *
     * @param getLinkRequest
     *        the request to be used for polling
     * @return CompletableFuture containing the WaiterResponse. It completes successfully when the resource enters into
     *         a desired state or exceptionally when it is determined that the resource will never enter into the
     *         desired state.
     */
    default CompletableFuture<WaiterResponse<GetLinkResponse>> waitUntilLinkAccepted(GetLinkRequest getLinkRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link RtbFabricAsyncClient#getLink} API until the desired condition {@code LinkAccepted} is met, or until
     * it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link GetLinkRequest#builder()}
     *
     * @param getLinkRequest
     *        The consumer that will configure the request to be used for polling
     * @return CompletableFuture of the WaiterResponse containing either a response or an exception that has matched
     *         with the waiter success condition
     */
    default CompletableFuture<WaiterResponse<GetLinkResponse>> waitUntilLinkAccepted(
            Consumer<GetLinkRequest.Builder> getLinkRequest) {
        return waitUntilLinkAccepted(GetLinkRequest.builder().applyMutation(getLinkRequest).build());
    }

    /**
     * Polls {@link RtbFabricAsyncClient#getLink} API until the desired condition {@code LinkAccepted} is met, or until
     * it is determined that the resource will never enter into the desired state
     *
     * @param getLinkRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<GetLinkResponse>> waitUntilLinkAccepted(GetLinkRequest getLinkRequest,
            WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link RtbFabricAsyncClient#getLink} API until the desired condition {@code LinkAccepted} is met, or until
     * it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param getLinkRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<GetLinkResponse>> waitUntilLinkAccepted(
            Consumer<GetLinkRequest.Builder> getLinkRequest, Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilLinkAccepted(GetLinkRequest.builder().applyMutation(getLinkRequest).build(), WaiterOverrideConfiguration
                .builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link RtbFabricAsyncClient#getLink} API until the desired condition {@code LinkActive} is met, or until it
     * is determined that the resource will never enter into the desired state
     *
     * @param getLinkRequest
     *        the request to be used for polling
     * @return CompletableFuture containing the WaiterResponse. It completes successfully when the resource enters into
     *         a desired state or exceptionally when it is determined that the resource will never enter into the
     *         desired state.
     */
    default CompletableFuture<WaiterResponse<GetLinkResponse>> waitUntilLinkActive(GetLinkRequest getLinkRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link RtbFabricAsyncClient#getLink} API until the desired condition {@code LinkActive} is met, or until it
     * is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link GetLinkRequest#builder()}
     *
     * @param getLinkRequest
     *        The consumer that will configure the request to be used for polling
     * @return CompletableFuture of the WaiterResponse containing either a response or an exception that has matched
     *         with the waiter success condition
     */
    default CompletableFuture<WaiterResponse<GetLinkResponse>> waitUntilLinkActive(Consumer<GetLinkRequest.Builder> getLinkRequest) {
        return waitUntilLinkActive(GetLinkRequest.builder().applyMutation(getLinkRequest).build());
    }

    /**
     * Polls {@link RtbFabricAsyncClient#getLink} API until the desired condition {@code LinkActive} is met, or until it
     * is determined that the resource will never enter into the desired state
     *
     * @param getLinkRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<GetLinkResponse>> waitUntilLinkActive(GetLinkRequest getLinkRequest,
            WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link RtbFabricAsyncClient#getLink} API until the desired condition {@code LinkActive} is met, or until it
     * is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param getLinkRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<GetLinkResponse>> waitUntilLinkActive(
            Consumer<GetLinkRequest.Builder> getLinkRequest, Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilLinkActive(GetLinkRequest.builder().applyMutation(getLinkRequest).build(), WaiterOverrideConfiguration
                .builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link RtbFabricAsyncClient#getOutboundExternalLink} API until the desired condition
     * {@code OutboundExternalLinkActive} is met, or until it is determined that the resource will never enter into the
     * desired state
     *
     * @param getOutboundExternalLinkRequest
     *        the request to be used for polling
     * @return CompletableFuture containing the WaiterResponse. It completes successfully when the resource enters into
     *         a desired state or exceptionally when it is determined that the resource will never enter into the
     *         desired state.
     */
    default CompletableFuture<WaiterResponse<GetOutboundExternalLinkResponse>> waitUntilOutboundExternalLinkActive(
            GetOutboundExternalLinkRequest getOutboundExternalLinkRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link RtbFabricAsyncClient#getOutboundExternalLink} API until the desired condition
     * {@code OutboundExternalLinkActive} is met, or until it is determined that the resource will never enter into the
     * desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link GetOutboundExternalLinkRequest#builder()}
     *
     * @param getOutboundExternalLinkRequest
     *        The consumer that will configure the request to be used for polling
     * @return CompletableFuture of the WaiterResponse containing either a response or an exception that has matched
     *         with the waiter success condition
     */
    default CompletableFuture<WaiterResponse<GetOutboundExternalLinkResponse>> waitUntilOutboundExternalLinkActive(
            Consumer<GetOutboundExternalLinkRequest.Builder> getOutboundExternalLinkRequest) {
        return waitUntilOutboundExternalLinkActive(GetOutboundExternalLinkRequest.builder()
                .applyMutation(getOutboundExternalLinkRequest).build());
    }

    /**
     * Polls {@link RtbFabricAsyncClient#getOutboundExternalLink} API until the desired condition
     * {@code OutboundExternalLinkActive} is met, or until it is determined that the resource will never enter into the
     * desired state
     *
     * @param getOutboundExternalLinkRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<GetOutboundExternalLinkResponse>> waitUntilOutboundExternalLinkActive(
            GetOutboundExternalLinkRequest getOutboundExternalLinkRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link RtbFabricAsyncClient#getOutboundExternalLink} API until the desired condition
     * {@code OutboundExternalLinkActive} is met, or until it is determined that the resource will never enter into the
     * desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param getOutboundExternalLinkRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<GetOutboundExternalLinkResponse>> waitUntilOutboundExternalLinkActive(
            Consumer<GetOutboundExternalLinkRequest.Builder> getOutboundExternalLinkRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilOutboundExternalLinkActive(
                GetOutboundExternalLinkRequest.builder().applyMutation(getOutboundExternalLinkRequest).build(),
                WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link RtbFabricAsyncClient#getRequesterGateway} API until the desired condition
     * {@code RequesterGatewayActive} is met, or until it is determined that the resource will never enter into the
     * desired state
     *
     * @param getRequesterGatewayRequest
     *        the request to be used for polling
     * @return CompletableFuture containing the WaiterResponse. It completes successfully when the resource enters into
     *         a desired state or exceptionally when it is determined that the resource will never enter into the
     *         desired state.
     */
    default CompletableFuture<WaiterResponse<GetRequesterGatewayResponse>> waitUntilRequesterGatewayActive(
            GetRequesterGatewayRequest getRequesterGatewayRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link RtbFabricAsyncClient#getRequesterGateway} API until the desired condition
     * {@code RequesterGatewayActive} is met, or until it is determined that the resource will never enter into the
     * desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link GetRequesterGatewayRequest#builder()}
     *
     * @param getRequesterGatewayRequest
     *        The consumer that will configure the request to be used for polling
     * @return CompletableFuture of the WaiterResponse containing either a response or an exception that has matched
     *         with the waiter success condition
     */
    default CompletableFuture<WaiterResponse<GetRequesterGatewayResponse>> waitUntilRequesterGatewayActive(
            Consumer<GetRequesterGatewayRequest.Builder> getRequesterGatewayRequest) {
        return waitUntilRequesterGatewayActive(GetRequesterGatewayRequest.builder().applyMutation(getRequesterGatewayRequest)
                .build());
    }

    /**
     * Polls {@link RtbFabricAsyncClient#getRequesterGateway} API until the desired condition
     * {@code RequesterGatewayActive} is met, or until it is determined that the resource will never enter into the
     * desired state
     *
     * @param getRequesterGatewayRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<GetRequesterGatewayResponse>> waitUntilRequesterGatewayActive(
            GetRequesterGatewayRequest getRequesterGatewayRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link RtbFabricAsyncClient#getRequesterGateway} API until the desired condition
     * {@code RequesterGatewayActive} is met, or until it is determined that the resource will never enter into the
     * desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param getRequesterGatewayRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<GetRequesterGatewayResponse>> waitUntilRequesterGatewayActive(
            Consumer<GetRequesterGatewayRequest.Builder> getRequesterGatewayRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilRequesterGatewayActive(GetRequesterGatewayRequest.builder().applyMutation(getRequesterGatewayRequest)
                .build(), WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link RtbFabricAsyncClient#getRequesterGateway} API until the desired condition
     * {@code RequesterGatewayDeleted} is met, or until it is determined that the resource will never enter into the
     * desired state
     *
     * @param getRequesterGatewayRequest
     *        the request to be used for polling
     * @return CompletableFuture containing the WaiterResponse. It completes successfully when the resource enters into
     *         a desired state or exceptionally when it is determined that the resource will never enter into the
     *         desired state.
     */
    default CompletableFuture<WaiterResponse<GetRequesterGatewayResponse>> waitUntilRequesterGatewayDeleted(
            GetRequesterGatewayRequest getRequesterGatewayRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link RtbFabricAsyncClient#getRequesterGateway} API until the desired condition
     * {@code RequesterGatewayDeleted} is met, or until it is determined that the resource will never enter into the
     * desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link GetRequesterGatewayRequest#builder()}
     *
     * @param getRequesterGatewayRequest
     *        The consumer that will configure the request to be used for polling
     * @return CompletableFuture of the WaiterResponse containing either a response or an exception that has matched
     *         with the waiter success condition
     */
    default CompletableFuture<WaiterResponse<GetRequesterGatewayResponse>> waitUntilRequesterGatewayDeleted(
            Consumer<GetRequesterGatewayRequest.Builder> getRequesterGatewayRequest) {
        return waitUntilRequesterGatewayDeleted(GetRequesterGatewayRequest.builder().applyMutation(getRequesterGatewayRequest)
                .build());
    }

    /**
     * Polls {@link RtbFabricAsyncClient#getRequesterGateway} API until the desired condition
     * {@code RequesterGatewayDeleted} is met, or until it is determined that the resource will never enter into the
     * desired state
     *
     * @param getRequesterGatewayRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<GetRequesterGatewayResponse>> waitUntilRequesterGatewayDeleted(
            GetRequesterGatewayRequest getRequesterGatewayRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link RtbFabricAsyncClient#getRequesterGateway} API until the desired condition
     * {@code RequesterGatewayDeleted} is met, or until it is determined that the resource will never enter into the
     * desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param getRequesterGatewayRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<GetRequesterGatewayResponse>> waitUntilRequesterGatewayDeleted(
            Consumer<GetRequesterGatewayRequest.Builder> getRequesterGatewayRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilRequesterGatewayDeleted(GetRequesterGatewayRequest.builder().applyMutation(getRequesterGatewayRequest)
                .build(), WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link RtbFabricAsyncClient#getResponderGateway} API until the desired condition
     * {@code ResponderGatewayActive} is met, or until it is determined that the resource will never enter into the
     * desired state
     *
     * @param getResponderGatewayRequest
     *        the request to be used for polling
     * @return CompletableFuture containing the WaiterResponse. It completes successfully when the resource enters into
     *         a desired state or exceptionally when it is determined that the resource will never enter into the
     *         desired state.
     */
    default CompletableFuture<WaiterResponse<GetResponderGatewayResponse>> waitUntilResponderGatewayActive(
            GetResponderGatewayRequest getResponderGatewayRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link RtbFabricAsyncClient#getResponderGateway} API until the desired condition
     * {@code ResponderGatewayActive} is met, or until it is determined that the resource will never enter into the
     * desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link GetResponderGatewayRequest#builder()}
     *
     * @param getResponderGatewayRequest
     *        The consumer that will configure the request to be used for polling
     * @return CompletableFuture of the WaiterResponse containing either a response or an exception that has matched
     *         with the waiter success condition
     */
    default CompletableFuture<WaiterResponse<GetResponderGatewayResponse>> waitUntilResponderGatewayActive(
            Consumer<GetResponderGatewayRequest.Builder> getResponderGatewayRequest) {
        return waitUntilResponderGatewayActive(GetResponderGatewayRequest.builder().applyMutation(getResponderGatewayRequest)
                .build());
    }

    /**
     * Polls {@link RtbFabricAsyncClient#getResponderGateway} API until the desired condition
     * {@code ResponderGatewayActive} is met, or until it is determined that the resource will never enter into the
     * desired state
     *
     * @param getResponderGatewayRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<GetResponderGatewayResponse>> waitUntilResponderGatewayActive(
            GetResponderGatewayRequest getResponderGatewayRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link RtbFabricAsyncClient#getResponderGateway} API until the desired condition
     * {@code ResponderGatewayActive} is met, or until it is determined that the resource will never enter into the
     * desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param getResponderGatewayRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<GetResponderGatewayResponse>> waitUntilResponderGatewayActive(
            Consumer<GetResponderGatewayRequest.Builder> getResponderGatewayRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilResponderGatewayActive(GetResponderGatewayRequest.builder().applyMutation(getResponderGatewayRequest)
                .build(), WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link RtbFabricAsyncClient#getResponderGateway} API until the desired condition
     * {@code ResponderGatewayDeleted} is met, or until it is determined that the resource will never enter into the
     * desired state
     *
     * @param getResponderGatewayRequest
     *        the request to be used for polling
     * @return CompletableFuture containing the WaiterResponse. It completes successfully when the resource enters into
     *         a desired state or exceptionally when it is determined that the resource will never enter into the
     *         desired state.
     */
    default CompletableFuture<WaiterResponse<GetResponderGatewayResponse>> waitUntilResponderGatewayDeleted(
            GetResponderGatewayRequest getResponderGatewayRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link RtbFabricAsyncClient#getResponderGateway} API until the desired condition
     * {@code ResponderGatewayDeleted} is met, or until it is determined that the resource will never enter into the
     * desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link GetResponderGatewayRequest#builder()}
     *
     * @param getResponderGatewayRequest
     *        The consumer that will configure the request to be used for polling
     * @return CompletableFuture of the WaiterResponse containing either a response or an exception that has matched
     *         with the waiter success condition
     */
    default CompletableFuture<WaiterResponse<GetResponderGatewayResponse>> waitUntilResponderGatewayDeleted(
            Consumer<GetResponderGatewayRequest.Builder> getResponderGatewayRequest) {
        return waitUntilResponderGatewayDeleted(GetResponderGatewayRequest.builder().applyMutation(getResponderGatewayRequest)
                .build());
    }

    /**
     * Polls {@link RtbFabricAsyncClient#getResponderGateway} API until the desired condition
     * {@code ResponderGatewayDeleted} is met, or until it is determined that the resource will never enter into the
     * desired state
     *
     * @param getResponderGatewayRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<GetResponderGatewayResponse>> waitUntilResponderGatewayDeleted(
            GetResponderGatewayRequest getResponderGatewayRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link RtbFabricAsyncClient#getResponderGateway} API until the desired condition
     * {@code ResponderGatewayDeleted} is met, or until it is determined that the resource will never enter into the
     * desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param getResponderGatewayRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<GetResponderGatewayResponse>> waitUntilResponderGatewayDeleted(
            Consumer<GetResponderGatewayRequest.Builder> getResponderGatewayRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilResponderGatewayDeleted(GetResponderGatewayRequest.builder().applyMutation(getResponderGatewayRequest)
                .build(), WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Create a builder that can be used to configure and create a {@link RtbFabricAsyncWaiter}.
     *
     * @return a builder
     */
    static Builder builder() {
        return DefaultRtbFabricAsyncWaiter.builder();
    }

    /**
     * Create an instance of {@link RtbFabricAsyncWaiter} with the default configuration.
     * <p>
     * <b>A default {@link RtbFabricAsyncClient} will be created to poll resources. It is recommended to share a single
     * instance of the waiter created via this method. If it is not desirable to share a waiter instance, invoke
     * {@link #close()} to release the resources once the waiter is not needed.</b>
     *
     * @return an instance of {@link RtbFabricAsyncWaiter}
     */
    static RtbFabricAsyncWaiter create() {
        return DefaultRtbFabricAsyncWaiter.builder().build();
    }

    interface Builder {
        /**
         * Sets a custom {@link ScheduledExecutorService} that will be used to schedule async polling attempts
         * <p>
         * This executorService must be closed by the caller when it is ready to be disposed. The SDK will not close the
         * executorService when the waiter is closed
         *
         * @param executorService
         *        the executorService to set
         * @return a reference to this object so that method calls can be chained together.
         */
        Builder scheduledExecutorService(ScheduledExecutorService executorService);

        /**
         * Defines overrides to the default SDK waiter configuration that should be used for waiters created from this
         * builder
         *
         * @param overrideConfiguration
         *        the override configuration to set
         * @return a reference to this object so that method calls can be chained together.
         */
        Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration);

        /**
         * This is a convenient method to pass the override configuration without the need to create an instance
         * manually via {@link WaiterOverrideConfiguration#builder()}
         *
         * @param overrideConfiguration
         *        The consumer that will configure the overrideConfiguration
         * @return a reference to this object so that method calls can be chained together.
         * @see #overrideConfiguration(WaiterOverrideConfiguration)
         */
        default Builder overrideConfiguration(Consumer<WaiterOverrideConfiguration.Builder> overrideConfiguration) {
            WaiterOverrideConfiguration.Builder builder = WaiterOverrideConfiguration.builder();
            overrideConfiguration.accept(builder);
            return overrideConfiguration(builder.build());
        }

        /**
         * Sets a custom {@link RtbFabricAsyncClient} that will be used to poll the resource
         * <p>
         * This SDK client must be closed by the caller when it is ready to be disposed. The SDK will not close the
         * client when the waiter is closed
         *
         * @param client
         *        the client to send the request
         * @return a reference to this object so that method calls can be chained together.
         */
        Builder client(RtbFabricAsyncClient client);

        /**
         * Builds an instance of {@link RtbFabricAsyncWaiter} based on the configurations supplied to this builder
         *
         * @return An initialized {@link RtbFabricAsyncWaiter}
         */
        RtbFabricAsyncWaiter build();
    }
}
