/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

/**
 * <p>
 * Amazon Web Services RTB Fabric provides secure, low-latency infrastructure for connecting real-time bidding (RTB)
 * applications. Rather than hosting applications directly, RTB Fabric acts as the connecting fabric that enables your
 * applications to communicate efficiently over private networks instead of the public internet. You maintain complete
 * control over your applications, data, and bidding decisions, while RTB Fabric provides the underlying infrastructure
 * for secure, reliable connectivity.
 * </p>
 * <p>
 * You can use these APIs to complete RTB Fabric tasks, such as setting up audit log ingestions or viewing user access.
 * For more information about RTB Fabric, including the required permissions to use the service, see the <a
 * href="https://docs.aws.amazon.com/rtb-fabric/latest/userguide/">Amazon Web Services RTB Fabric User Guide</a>.
 * </p>
 */
package software.amazon.awssdk.services.rtbfabric;