/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rtbfabric.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateResponderGatewayRequest extends RtbFabricRequest implements
        ToCopyableBuilder<UpdateResponderGatewayRequest.Builder, UpdateResponderGatewayRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainName").getter(getter(UpdateResponderGatewayRequest::domainName))
            .setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainName").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("port")
            .getter(getter(UpdateResponderGatewayRequest::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("port").build()).build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("protocol").getter(getter(UpdateResponderGatewayRequest::protocolAsString))
            .setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()).build();

    private static final SdkField<TrustStoreConfiguration> TRUST_STORE_CONFIGURATION_FIELD = SdkField
            .<TrustStoreConfiguration> builder(MarshallingType.SDK_POJO).memberName("trustStoreConfiguration")
            .getter(getter(UpdateResponderGatewayRequest::trustStoreConfiguration))
            .setter(setter(Builder::trustStoreConfiguration)).constructor(TrustStoreConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trustStoreConfiguration").build())
            .build();

    private static final SdkField<ManagedEndpointConfiguration> MANAGED_ENDPOINT_CONFIGURATION_FIELD = SdkField
            .<ManagedEndpointConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("managedEndpointConfiguration")
            .getter(getter(UpdateResponderGatewayRequest::managedEndpointConfiguration))
            .setter(setter(Builder::managedEndpointConfiguration))
            .constructor(ManagedEndpointConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedEndpointConfiguration")
                    .build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(UpdateResponderGatewayRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> GATEWAY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("gatewayId").getter(getter(UpdateResponderGatewayRequest::gatewayId)).setter(setter(Builder::gatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("gatewayId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateResponderGatewayRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, PORT_FIELD,
            PROTOCOL_FIELD, TRUST_STORE_CONFIGURATION_FIELD, MANAGED_ENDPOINT_CONFIGURATION_FIELD, CLIENT_TOKEN_FIELD,
            GATEWAY_ID_FIELD, DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String domainName;

    private final Integer port;

    private final String protocol;

    private final TrustStoreConfiguration trustStoreConfiguration;

    private final ManagedEndpointConfiguration managedEndpointConfiguration;

    private final String clientToken;

    private final String gatewayId;

    private final String description;

    private UpdateResponderGatewayRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.port = builder.port;
        this.protocol = builder.protocol;
        this.trustStoreConfiguration = builder.trustStoreConfiguration;
        this.managedEndpointConfiguration = builder.managedEndpointConfiguration;
        this.clientToken = builder.clientToken;
        this.gatewayId = builder.gatewayId;
        this.description = builder.description;
    }

    /**
     * <p>
     * The domain name for the responder gateway.
     * </p>
     * 
     * @return The domain name for the responder gateway.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The networking port to use.
     * </p>
     * 
     * @return The networking port to use.
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * The networking protocol to use.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link Protocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The networking protocol to use.
     * @see Protocol
     */
    public final Protocol protocol() {
        return Protocol.fromValue(protocol);
    }

    /**
     * <p>
     * The networking protocol to use.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link Protocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The networking protocol to use.
     * @see Protocol
     */
    public final String protocolAsString() {
        return protocol;
    }

    /**
     * <p>
     * The configuration of the trust store.
     * </p>
     * 
     * @return The configuration of the trust store.
     */
    public final TrustStoreConfiguration trustStoreConfiguration() {
        return trustStoreConfiguration;
    }

    /**
     * <p>
     * The configuration for the managed endpoint.
     * </p>
     * 
     * @return The configuration for the managed endpoint.
     */
    public final ManagedEndpointConfiguration managedEndpointConfiguration() {
        return managedEndpointConfiguration;
    }

    /**
     * <p>
     * The unique client token.
     * </p>
     * 
     * @return The unique client token.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The unique identifier of the gateway.
     * </p>
     * 
     * @return The unique identifier of the gateway.
     */
    public final String gatewayId() {
        return gatewayId;
    }

    /**
     * <p>
     * An optional description for the responder gateway.
     * </p>
     * 
     * @return An optional description for the responder gateway.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(trustStoreConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(managedEndpointConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(gatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateResponderGatewayRequest)) {
            return false;
        }
        UpdateResponderGatewayRequest other = (UpdateResponderGatewayRequest) obj;
        return Objects.equals(domainName(), other.domainName()) && Objects.equals(port(), other.port())
                && Objects.equals(protocolAsString(), other.protocolAsString())
                && Objects.equals(trustStoreConfiguration(), other.trustStoreConfiguration())
                && Objects.equals(managedEndpointConfiguration(), other.managedEndpointConfiguration())
                && Objects.equals(clientToken(), other.clientToken()) && Objects.equals(gatewayId(), other.gatewayId())
                && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateResponderGatewayRequest").add("DomainName", domainName()).add("Port", port())
                .add("Protocol", protocolAsString()).add("TrustStoreConfiguration", trustStoreConfiguration())
                .add("ManagedEndpointConfiguration", managedEndpointConfiguration()).add("ClientToken", clientToken())
                .add("GatewayId", gatewayId()).add("Description", description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "port":
            return Optional.ofNullable(clazz.cast(port()));
        case "protocol":
            return Optional.ofNullable(clazz.cast(protocolAsString()));
        case "trustStoreConfiguration":
            return Optional.ofNullable(clazz.cast(trustStoreConfiguration()));
        case "managedEndpointConfiguration":
            return Optional.ofNullable(clazz.cast(managedEndpointConfiguration()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "gatewayId":
            return Optional.ofNullable(clazz.cast(gatewayId()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("domainName", DOMAIN_NAME_FIELD);
        map.put("port", PORT_FIELD);
        map.put("protocol", PROTOCOL_FIELD);
        map.put("trustStoreConfiguration", TRUST_STORE_CONFIGURATION_FIELD);
        map.put("managedEndpointConfiguration", MANAGED_ENDPOINT_CONFIGURATION_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("gatewayId", GATEWAY_ID_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateResponderGatewayRequest, T> g) {
        return obj -> g.apply((UpdateResponderGatewayRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends RtbFabricRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateResponderGatewayRequest> {
        /**
         * <p>
         * The domain name for the responder gateway.
         * </p>
         * 
         * @param domainName
         *        The domain name for the responder gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The networking port to use.
         * </p>
         * 
         * @param port
         *        The networking port to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * The networking protocol to use.
         * </p>
         * 
         * @param protocol
         *        The networking protocol to use.
         * @see Protocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Protocol
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * The networking protocol to use.
         * </p>
         * 
         * @param protocol
         *        The networking protocol to use.
         * @see Protocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Protocol
         */
        Builder protocol(Protocol protocol);

        /**
         * <p>
         * The configuration of the trust store.
         * </p>
         * 
         * @param trustStoreConfiguration
         *        The configuration of the trust store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trustStoreConfiguration(TrustStoreConfiguration trustStoreConfiguration);

        /**
         * <p>
         * The configuration of the trust store.
         * </p>
         * This is a convenience method that creates an instance of the {@link TrustStoreConfiguration.Builder} avoiding
         * the need to create one manually via {@link TrustStoreConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TrustStoreConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #trustStoreConfiguration(TrustStoreConfiguration)}.
         * 
         * @param trustStoreConfiguration
         *        a consumer that will call methods on {@link TrustStoreConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trustStoreConfiguration(TrustStoreConfiguration)
         */
        default Builder trustStoreConfiguration(Consumer<TrustStoreConfiguration.Builder> trustStoreConfiguration) {
            return trustStoreConfiguration(TrustStoreConfiguration.builder().applyMutation(trustStoreConfiguration).build());
        }

        /**
         * <p>
         * The configuration for the managed endpoint.
         * </p>
         * 
         * @param managedEndpointConfiguration
         *        The configuration for the managed endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedEndpointConfiguration(ManagedEndpointConfiguration managedEndpointConfiguration);

        /**
         * <p>
         * The configuration for the managed endpoint.
         * </p>
         * This is a convenience method that creates an instance of the {@link ManagedEndpointConfiguration.Builder}
         * avoiding the need to create one manually via {@link ManagedEndpointConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ManagedEndpointConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #managedEndpointConfiguration(ManagedEndpointConfiguration)}.
         * 
         * @param managedEndpointConfiguration
         *        a consumer that will call methods on {@link ManagedEndpointConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #managedEndpointConfiguration(ManagedEndpointConfiguration)
         */
        default Builder managedEndpointConfiguration(Consumer<ManagedEndpointConfiguration.Builder> managedEndpointConfiguration) {
            return managedEndpointConfiguration(ManagedEndpointConfiguration.builder()
                    .applyMutation(managedEndpointConfiguration).build());
        }

        /**
         * <p>
         * The unique client token.
         * </p>
         * 
         * @param clientToken
         *        The unique client token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The unique identifier of the gateway.
         * </p>
         * 
         * @param gatewayId
         *        The unique identifier of the gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayId(String gatewayId);

        /**
         * <p>
         * An optional description for the responder gateway.
         * </p>
         * 
         * @param description
         *        An optional description for the responder gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RtbFabricRequest.BuilderImpl implements Builder {
        private String domainName;

        private Integer port;

        private String protocol;

        private TrustStoreConfiguration trustStoreConfiguration;

        private ManagedEndpointConfiguration managedEndpointConfiguration;

        private String clientToken;

        private String gatewayId;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateResponderGatewayRequest model) {
            super(model);
            domainName(model.domainName);
            port(model.port);
            protocol(model.protocol);
            trustStoreConfiguration(model.trustStoreConfiguration);
            managedEndpointConfiguration(model.managedEndpointConfiguration);
            clientToken(model.clientToken);
            gatewayId(model.gatewayId);
            description(model.description);
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getProtocol() {
            return protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(Protocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final TrustStoreConfiguration.Builder getTrustStoreConfiguration() {
            return trustStoreConfiguration != null ? trustStoreConfiguration.toBuilder() : null;
        }

        public final void setTrustStoreConfiguration(TrustStoreConfiguration.BuilderImpl trustStoreConfiguration) {
            this.trustStoreConfiguration = trustStoreConfiguration != null ? trustStoreConfiguration.build() : null;
        }

        @Override
        public final Builder trustStoreConfiguration(TrustStoreConfiguration trustStoreConfiguration) {
            this.trustStoreConfiguration = trustStoreConfiguration;
            return this;
        }

        public final ManagedEndpointConfiguration.Builder getManagedEndpointConfiguration() {
            return managedEndpointConfiguration != null ? managedEndpointConfiguration.toBuilder() : null;
        }

        public final void setManagedEndpointConfiguration(ManagedEndpointConfiguration.BuilderImpl managedEndpointConfiguration) {
            this.managedEndpointConfiguration = managedEndpointConfiguration != null ? managedEndpointConfiguration.build()
                    : null;
        }

        @Override
        public final Builder managedEndpointConfiguration(ManagedEndpointConfiguration managedEndpointConfiguration) {
            this.managedEndpointConfiguration = managedEndpointConfiguration;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getGatewayId() {
            return gatewayId;
        }

        public final void setGatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
        }

        @Override
        public final Builder gatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateResponderGatewayRequest build() {
            return new UpdateResponderGatewayRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
