/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rtbfabric.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the masking for HTTP error codes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResponderErrorMaskingForHttpCode implements SdkPojo, Serializable,
        ToCopyableBuilder<ResponderErrorMaskingForHttpCode.Builder, ResponderErrorMaskingForHttpCode> {
    private static final SdkField<String> HTTP_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("httpCode").getter(getter(ResponderErrorMaskingForHttpCode::httpCode)).setter(setter(Builder::httpCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("httpCode").build()).build();

    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("action")
            .getter(getter(ResponderErrorMaskingForHttpCode::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()).build();

    private static final SdkField<List<String>> LOGGING_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("loggingTypes")
            .getter(getter(ResponderErrorMaskingForHttpCode::loggingTypesAsStrings))
            .setter(setter(Builder::loggingTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loggingTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Float> RESPONSE_LOGGING_PERCENTAGE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("responseLoggingPercentage").getter(getter(ResponderErrorMaskingForHttpCode::responseLoggingPercentage))
            .setter(setter(Builder::responseLoggingPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseLoggingPercentage").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HTTP_CODE_FIELD, ACTION_FIELD,
            LOGGING_TYPES_FIELD, RESPONSE_LOGGING_PERCENTAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String httpCode;

    private final String action;

    private final List<String> loggingTypes;

    private final Float responseLoggingPercentage;

    private ResponderErrorMaskingForHttpCode(BuilderImpl builder) {
        this.httpCode = builder.httpCode;
        this.action = builder.action;
        this.loggingTypes = builder.loggingTypes;
        this.responseLoggingPercentage = builder.responseLoggingPercentage;
    }

    /**
     * <p>
     * The HTTP error code.
     * </p>
     * 
     * @return The HTTP error code.
     */
    public final String httpCode() {
        return httpCode;
    }

    /**
     * <p>
     * The action for the error..
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link ResponderErrorMaskingAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #actionAsString}.
     * </p>
     * 
     * @return The action for the error..
     * @see ResponderErrorMaskingAction
     */
    public final ResponderErrorMaskingAction action() {
        return ResponderErrorMaskingAction.fromValue(action);
    }

    /**
     * <p>
     * The action for the error..
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link ResponderErrorMaskingAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #actionAsString}.
     * </p>
     * 
     * @return The action for the error..
     * @see ResponderErrorMaskingAction
     */
    public final String actionAsString() {
        return action;
    }

    /**
     * <p>
     * The error log type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLoggingTypes} method.
     * </p>
     * 
     * @return The error log type.
     */
    public final List<ResponderErrorMaskingLoggingType> loggingTypes() {
        return ResponderErrorMaskingLoggingTypesCopier.copyStringToEnum(loggingTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the LoggingTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLoggingTypes() {
        return loggingTypes != null && !(loggingTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The error log type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLoggingTypes} method.
     * </p>
     * 
     * @return The error log type.
     */
    public final List<String> loggingTypesAsStrings() {
        return loggingTypes;
    }

    /**
     * <p>
     * The percentage of response logging.
     * </p>
     * 
     * @return The percentage of response logging.
     */
    public final Float responseLoggingPercentage() {
        return responseLoggingPercentage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(httpCode());
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasLoggingTypes() ? loggingTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(responseLoggingPercentage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResponderErrorMaskingForHttpCode)) {
            return false;
        }
        ResponderErrorMaskingForHttpCode other = (ResponderErrorMaskingForHttpCode) obj;
        return Objects.equals(httpCode(), other.httpCode()) && Objects.equals(actionAsString(), other.actionAsString())
                && hasLoggingTypes() == other.hasLoggingTypes()
                && Objects.equals(loggingTypesAsStrings(), other.loggingTypesAsStrings())
                && Objects.equals(responseLoggingPercentage(), other.responseLoggingPercentage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResponderErrorMaskingForHttpCode").add("HttpCode", httpCode()).add("Action", actionAsString())
                .add("LoggingTypes", hasLoggingTypes() ? loggingTypesAsStrings() : null)
                .add("ResponseLoggingPercentage", responseLoggingPercentage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "httpCode":
            return Optional.ofNullable(clazz.cast(httpCode()));
        case "action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "loggingTypes":
            return Optional.ofNullable(clazz.cast(loggingTypesAsStrings()));
        case "responseLoggingPercentage":
            return Optional.ofNullable(clazz.cast(responseLoggingPercentage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("httpCode", HTTP_CODE_FIELD);
        map.put("action", ACTION_FIELD);
        map.put("loggingTypes", LOGGING_TYPES_FIELD);
        map.put("responseLoggingPercentage", RESPONSE_LOGGING_PERCENTAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResponderErrorMaskingForHttpCode, T> g) {
        return obj -> g.apply((ResponderErrorMaskingForHttpCode) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResponderErrorMaskingForHttpCode> {
        /**
         * <p>
         * The HTTP error code.
         * </p>
         * 
         * @param httpCode
         *        The HTTP error code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpCode(String httpCode);

        /**
         * <p>
         * The action for the error..
         * </p>
         * 
         * @param action
         *        The action for the error..
         * @see ResponderErrorMaskingAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResponderErrorMaskingAction
         */
        Builder action(String action);

        /**
         * <p>
         * The action for the error..
         * </p>
         * 
         * @param action
         *        The action for the error..
         * @see ResponderErrorMaskingAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResponderErrorMaskingAction
         */
        Builder action(ResponderErrorMaskingAction action);

        /**
         * <p>
         * The error log type.
         * </p>
         * 
         * @param loggingTypes
         *        The error log type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loggingTypesWithStrings(Collection<String> loggingTypes);

        /**
         * <p>
         * The error log type.
         * </p>
         * 
         * @param loggingTypes
         *        The error log type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loggingTypesWithStrings(String... loggingTypes);

        /**
         * <p>
         * The error log type.
         * </p>
         * 
         * @param loggingTypes
         *        The error log type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loggingTypes(Collection<ResponderErrorMaskingLoggingType> loggingTypes);

        /**
         * <p>
         * The error log type.
         * </p>
         * 
         * @param loggingTypes
         *        The error log type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loggingTypes(ResponderErrorMaskingLoggingType... loggingTypes);

        /**
         * <p>
         * The percentage of response logging.
         * </p>
         * 
         * @param responseLoggingPercentage
         *        The percentage of response logging.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseLoggingPercentage(Float responseLoggingPercentage);
    }

    static final class BuilderImpl implements Builder {
        private String httpCode;

        private String action;

        private List<String> loggingTypes = DefaultSdkAutoConstructList.getInstance();

        private Float responseLoggingPercentage;

        private BuilderImpl() {
        }

        private BuilderImpl(ResponderErrorMaskingForHttpCode model) {
            httpCode(model.httpCode);
            action(model.action);
            loggingTypesWithStrings(model.loggingTypes);
            responseLoggingPercentage(model.responseLoggingPercentage);
        }

        public final String getHttpCode() {
            return httpCode;
        }

        public final void setHttpCode(String httpCode) {
            this.httpCode = httpCode;
        }

        @Override
        public final Builder httpCode(String httpCode) {
            this.httpCode = httpCode;
            return this;
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(ResponderErrorMaskingAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final Collection<String> getLoggingTypes() {
            if (loggingTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return loggingTypes;
        }

        public final void setLoggingTypes(Collection<String> loggingTypes) {
            this.loggingTypes = ResponderErrorMaskingLoggingTypesCopier.copy(loggingTypes);
        }

        @Override
        public final Builder loggingTypesWithStrings(Collection<String> loggingTypes) {
            this.loggingTypes = ResponderErrorMaskingLoggingTypesCopier.copy(loggingTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loggingTypesWithStrings(String... loggingTypes) {
            loggingTypesWithStrings(Arrays.asList(loggingTypes));
            return this;
        }

        @Override
        public final Builder loggingTypes(Collection<ResponderErrorMaskingLoggingType> loggingTypes) {
            this.loggingTypes = ResponderErrorMaskingLoggingTypesCopier.copyEnumToString(loggingTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loggingTypes(ResponderErrorMaskingLoggingType... loggingTypes) {
            loggingTypes(Arrays.asList(loggingTypes));
            return this;
        }

        public final Float getResponseLoggingPercentage() {
            return responseLoggingPercentage;
        }

        public final void setResponseLoggingPercentage(Float responseLoggingPercentage) {
            this.responseLoggingPercentage = responseLoggingPercentage;
        }

        @Override
        public final Builder responseLoggingPercentage(Float responseLoggingPercentage) {
            this.responseLoggingPercentage = responseLoggingPercentage;
            return this;
        }

        @Override
        public ResponderErrorMaskingForHttpCode build() {
            return new ResponderErrorMaskingForHttpCode(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
