/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rtbfabric.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the parameters of a no bid module.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NoBidModuleParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<NoBidModuleParameters.Builder, NoBidModuleParameters> {
    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("reason")
            .getter(getter(NoBidModuleParameters::reason)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reason").build()).build();

    private static final SdkField<Integer> REASON_CODE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("reasonCode").getter(getter(NoBidModuleParameters::reasonCode)).setter(setter(Builder::reasonCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reasonCode").build()).build();

    private static final SdkField<Float> PASS_THROUGH_PERCENTAGE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("passThroughPercentage").getter(getter(NoBidModuleParameters::passThroughPercentage))
            .setter(setter(Builder::passThroughPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("passThroughPercentage").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REASON_FIELD,
            REASON_CODE_FIELD, PASS_THROUGH_PERCENTAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String reason;

    private final Integer reasonCode;

    private final Float passThroughPercentage;

    private NoBidModuleParameters(BuilderImpl builder) {
        this.reason = builder.reason;
        this.reasonCode = builder.reasonCode;
        this.passThroughPercentage = builder.passThroughPercentage;
    }

    /**
     * <p>
     * The reason description.
     * </p>
     * 
     * @return The reason description.
     */
    public final String reason() {
        return reason;
    }

    /**
     * <p>
     * The reason code.
     * </p>
     * 
     * @return The reason code.
     */
    public final Integer reasonCode() {
        return reasonCode;
    }

    /**
     * <p>
     * The pass through percentage.
     * </p>
     * 
     * @return The pass through percentage.
     */
    public final Float passThroughPercentage() {
        return passThroughPercentage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(reason());
        hashCode = 31 * hashCode + Objects.hashCode(reasonCode());
        hashCode = 31 * hashCode + Objects.hashCode(passThroughPercentage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NoBidModuleParameters)) {
            return false;
        }
        NoBidModuleParameters other = (NoBidModuleParameters) obj;
        return Objects.equals(reason(), other.reason()) && Objects.equals(reasonCode(), other.reasonCode())
                && Objects.equals(passThroughPercentage(), other.passThroughPercentage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NoBidModuleParameters").add("Reason", reason()).add("ReasonCode", reasonCode())
                .add("PassThroughPercentage", passThroughPercentage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "reason":
            return Optional.ofNullable(clazz.cast(reason()));
        case "reasonCode":
            return Optional.ofNullable(clazz.cast(reasonCode()));
        case "passThroughPercentage":
            return Optional.ofNullable(clazz.cast(passThroughPercentage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("reason", REASON_FIELD);
        map.put("reasonCode", REASON_CODE_FIELD);
        map.put("passThroughPercentage", PASS_THROUGH_PERCENTAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NoBidModuleParameters, T> g) {
        return obj -> g.apply((NoBidModuleParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NoBidModuleParameters> {
        /**
         * <p>
         * The reason description.
         * </p>
         * 
         * @param reason
         *        The reason description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reason(String reason);

        /**
         * <p>
         * The reason code.
         * </p>
         * 
         * @param reasonCode
         *        The reason code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reasonCode(Integer reasonCode);

        /**
         * <p>
         * The pass through percentage.
         * </p>
         * 
         * @param passThroughPercentage
         *        The pass through percentage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder passThroughPercentage(Float passThroughPercentage);
    }

    static final class BuilderImpl implements Builder {
        private String reason;

        private Integer reasonCode;

        private Float passThroughPercentage;

        private BuilderImpl() {
        }

        private BuilderImpl(NoBidModuleParameters model) {
            reason(model.reason);
            reasonCode(model.reasonCode);
            passThroughPercentage(model.passThroughPercentage);
        }

        public final String getReason() {
            return reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final Integer getReasonCode() {
            return reasonCode;
        }

        public final void setReasonCode(Integer reasonCode) {
            this.reasonCode = reasonCode;
        }

        @Override
        public final Builder reasonCode(Integer reasonCode) {
            this.reasonCode = reasonCode;
            return this;
        }

        public final Float getPassThroughPercentage() {
            return passThroughPercentage;
        }

        public final void setPassThroughPercentage(Float passThroughPercentage) {
            this.passThroughPercentage = passThroughPercentage;
        }

        @Override
        public final Builder passThroughPercentage(Float passThroughPercentage) {
            this.passThroughPercentage = passThroughPercentage;
            return this;
        }

        @Override
        public NoBidModuleParameters build() {
            return new NoBidModuleParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
