/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rtbfabric.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the settings for a link log.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LinkLogSettings implements SdkPojo, Serializable, ToCopyableBuilder<LinkLogSettings.Builder, LinkLogSettings> {
    private static final SdkField<LinkApplicationLogConfiguration> APPLICATION_LOGS_FIELD = SdkField
            .<LinkApplicationLogConfiguration> builder(MarshallingType.SDK_POJO).memberName("applicationLogs")
            .getter(getter(LinkLogSettings::applicationLogs)).setter(setter(Builder::applicationLogs))
            .constructor(LinkApplicationLogConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationLogs").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_LOGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final LinkApplicationLogConfiguration applicationLogs;

    private LinkLogSettings(BuilderImpl builder) {
        this.applicationLogs = builder.applicationLogs;
    }

    /**
     * <p>
     * Describes the configuration of a link application log.
     * </p>
     * 
     * @return Describes the configuration of a link application log.
     */
    public final LinkApplicationLogConfiguration applicationLogs() {
        return applicationLogs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationLogs());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LinkLogSettings)) {
            return false;
        }
        LinkLogSettings other = (LinkLogSettings) obj;
        return Objects.equals(applicationLogs(), other.applicationLogs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LinkLogSettings").add("ApplicationLogs", applicationLogs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationLogs":
            return Optional.ofNullable(clazz.cast(applicationLogs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("applicationLogs", APPLICATION_LOGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LinkLogSettings, T> g) {
        return obj -> g.apply((LinkLogSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LinkLogSettings> {
        /**
         * <p>
         * Describes the configuration of a link application log.
         * </p>
         * 
         * @param applicationLogs
         *        Describes the configuration of a link application log.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationLogs(LinkApplicationLogConfiguration applicationLogs);

        /**
         * <p>
         * Describes the configuration of a link application log.
         * </p>
         * This is a convenience method that creates an instance of the {@link LinkApplicationLogConfiguration.Builder}
         * avoiding the need to create one manually via {@link LinkApplicationLogConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LinkApplicationLogConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #applicationLogs(LinkApplicationLogConfiguration)}.
         * 
         * @param applicationLogs
         *        a consumer that will call methods on {@link LinkApplicationLogConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicationLogs(LinkApplicationLogConfiguration)
         */
        default Builder applicationLogs(Consumer<LinkApplicationLogConfiguration.Builder> applicationLogs) {
            return applicationLogs(LinkApplicationLogConfiguration.builder().applyMutation(applicationLogs).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private LinkApplicationLogConfiguration applicationLogs;

        private BuilderImpl() {
        }

        private BuilderImpl(LinkLogSettings model) {
            applicationLogs(model.applicationLogs);
        }

        public final LinkApplicationLogConfiguration.Builder getApplicationLogs() {
            return applicationLogs != null ? applicationLogs.toBuilder() : null;
        }

        public final void setApplicationLogs(LinkApplicationLogConfiguration.BuilderImpl applicationLogs) {
            this.applicationLogs = applicationLogs != null ? applicationLogs.build() : null;
        }

        @Override
        public final Builder applicationLogs(LinkApplicationLogConfiguration applicationLogs) {
            this.applicationLogs = applicationLogs;
            return this;
        }

        @Override
        public LinkLogSettings build() {
            return new LinkLogSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
