/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rtbfabric.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the attributes of a link.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LinkAttributes implements SdkPojo, Serializable, ToCopyableBuilder<LinkAttributes.Builder, LinkAttributes> {
    private static final SdkField<List<ResponderErrorMaskingForHttpCode>> RESPONDER_ERROR_MASKING_FIELD = SdkField
            .<List<ResponderErrorMaskingForHttpCode>> builder(MarshallingType.LIST)
            .memberName("responderErrorMasking")
            .getter(getter(LinkAttributes::responderErrorMasking))
            .setter(setter(Builder::responderErrorMasking))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responderErrorMasking").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResponderErrorMaskingForHttpCode> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResponderErrorMaskingForHttpCode::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CUSTOMER_PROVIDED_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customerProvidedId").getter(getter(LinkAttributes::customerProvidedId))
            .setter(setter(Builder::customerProvidedId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerProvidedId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESPONDER_ERROR_MASKING_FIELD,
            CUSTOMER_PROVIDED_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<ResponderErrorMaskingForHttpCode> responderErrorMasking;

    private final String customerProvidedId;

    private LinkAttributes(BuilderImpl builder) {
        this.responderErrorMasking = builder.responderErrorMasking;
        this.customerProvidedId = builder.customerProvidedId;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResponderErrorMasking property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasResponderErrorMasking() {
        return responderErrorMasking != null && !(responderErrorMasking instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Describes the masking for HTTP error codes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResponderErrorMasking} method.
     * </p>
     * 
     * @return Describes the masking for HTTP error codes.
     */
    public final List<ResponderErrorMaskingForHttpCode> responderErrorMasking() {
        return responderErrorMasking;
    }

    /**
     * <p>
     * The customer-provided unique identifier of the link.
     * </p>
     * 
     * @return The customer-provided unique identifier of the link.
     */
    public final String customerProvidedId() {
        return customerProvidedId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasResponderErrorMasking() ? responderErrorMasking() : null);
        hashCode = 31 * hashCode + Objects.hashCode(customerProvidedId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LinkAttributes)) {
            return false;
        }
        LinkAttributes other = (LinkAttributes) obj;
        return hasResponderErrorMasking() == other.hasResponderErrorMasking()
                && Objects.equals(responderErrorMasking(), other.responderErrorMasking())
                && Objects.equals(customerProvidedId(), other.customerProvidedId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LinkAttributes")
                .add("ResponderErrorMasking", hasResponderErrorMasking() ? responderErrorMasking() : null)
                .add("CustomerProvidedId", customerProvidedId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "responderErrorMasking":
            return Optional.ofNullable(clazz.cast(responderErrorMasking()));
        case "customerProvidedId":
            return Optional.ofNullable(clazz.cast(customerProvidedId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("responderErrorMasking", RESPONDER_ERROR_MASKING_FIELD);
        map.put("customerProvidedId", CUSTOMER_PROVIDED_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LinkAttributes, T> g) {
        return obj -> g.apply((LinkAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LinkAttributes> {
        /**
         * <p>
         * Describes the masking for HTTP error codes.
         * </p>
         * 
         * @param responderErrorMasking
         *        Describes the masking for HTTP error codes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responderErrorMasking(Collection<ResponderErrorMaskingForHttpCode> responderErrorMasking);

        /**
         * <p>
         * Describes the masking for HTTP error codes.
         * </p>
         * 
         * @param responderErrorMasking
         *        Describes the masking for HTTP error codes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responderErrorMasking(ResponderErrorMaskingForHttpCode... responderErrorMasking);

        /**
         * <p>
         * Describes the masking for HTTP error codes.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rtbfabric.model.ResponderErrorMaskingForHttpCode.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.rtbfabric.model.ResponderErrorMaskingForHttpCode#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rtbfabric.model.ResponderErrorMaskingForHttpCode.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #responderErrorMasking(List<ResponderErrorMaskingForHttpCode>)}.
         * 
         * @param responderErrorMasking
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rtbfabric.model.ResponderErrorMaskingForHttpCode.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #responderErrorMasking(java.util.Collection<ResponderErrorMaskingForHttpCode>)
         */
        Builder responderErrorMasking(Consumer<ResponderErrorMaskingForHttpCode.Builder>... responderErrorMasking);

        /**
         * <p>
         * The customer-provided unique identifier of the link.
         * </p>
         * 
         * @param customerProvidedId
         *        The customer-provided unique identifier of the link.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerProvidedId(String customerProvidedId);
    }

    static final class BuilderImpl implements Builder {
        private List<ResponderErrorMaskingForHttpCode> responderErrorMasking = DefaultSdkAutoConstructList.getInstance();

        private String customerProvidedId;

        private BuilderImpl() {
        }

        private BuilderImpl(LinkAttributes model) {
            responderErrorMasking(model.responderErrorMasking);
            customerProvidedId(model.customerProvidedId);
        }

        public final List<ResponderErrorMaskingForHttpCode.Builder> getResponderErrorMasking() {
            List<ResponderErrorMaskingForHttpCode.Builder> result = ResponderErrorMaskingCopier
                    .copyToBuilder(this.responderErrorMasking);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResponderErrorMasking(Collection<ResponderErrorMaskingForHttpCode.BuilderImpl> responderErrorMasking) {
            this.responderErrorMasking = ResponderErrorMaskingCopier.copyFromBuilder(responderErrorMasking);
        }

        @Override
        public final Builder responderErrorMasking(Collection<ResponderErrorMaskingForHttpCode> responderErrorMasking) {
            this.responderErrorMasking = ResponderErrorMaskingCopier.copy(responderErrorMasking);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder responderErrorMasking(ResponderErrorMaskingForHttpCode... responderErrorMasking) {
            responderErrorMasking(Arrays.asList(responderErrorMasking));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder responderErrorMasking(Consumer<ResponderErrorMaskingForHttpCode.Builder>... responderErrorMasking) {
            responderErrorMasking(Stream.of(responderErrorMasking)
                    .map(c -> ResponderErrorMaskingForHttpCode.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getCustomerProvidedId() {
            return customerProvidedId;
        }

        public final void setCustomerProvidedId(String customerProvidedId) {
            this.customerProvidedId = customerProvidedId;
        }

        @Override
        public final Builder customerProvidedId(String customerProvidedId) {
            this.customerProvidedId = customerProvidedId;
            return this;
        }

        @Override
        public LinkAttributes build() {
            return new LinkAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
