/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rtbfabric.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateLinkResponse extends RtbFabricResponse implements
        ToCopyableBuilder<CreateLinkResponse.Builder, CreateLinkResponse> {
    private static final SdkField<String> GATEWAY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("gatewayId").getter(getter(CreateLinkResponse::gatewayId)).setter(setter(Builder::gatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gatewayId").build()).build();

    private static final SdkField<String> PEER_GATEWAY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("peerGatewayId").getter(getter(CreateLinkResponse::peerGatewayId)).setter(setter(Builder::peerGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("peerGatewayId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(CreateLinkResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(CreateLinkResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt").getter(getter(CreateLinkResponse::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()).build();

    private static final SdkField<String> DIRECTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("direction").getter(getter(CreateLinkResponse::directionAsString)).setter(setter(Builder::direction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("direction").build()).build();

    private static final SdkField<List<ModuleConfiguration>> FLOW_MODULES_FIELD = SdkField
            .<List<ModuleConfiguration>> builder(MarshallingType.LIST)
            .memberName("flowModules")
            .getter(getter(CreateLinkResponse::flowModules))
            .setter(setter(Builder::flowModules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowModules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ModuleConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(ModuleConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ModuleConfiguration>> PENDING_FLOW_MODULES_FIELD = SdkField
            .<List<ModuleConfiguration>> builder(MarshallingType.LIST)
            .memberName("pendingFlowModules")
            .getter(getter(CreateLinkResponse::pendingFlowModules))
            .setter(setter(Builder::pendingFlowModules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pendingFlowModules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ModuleConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(ModuleConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<LinkAttributes> ATTRIBUTES_FIELD = SdkField.<LinkAttributes> builder(MarshallingType.SDK_POJO)
            .memberName("attributes").getter(getter(CreateLinkResponse::attributes)).setter(setter(Builder::attributes))
            .constructor(LinkAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build()).build();

    private static final SdkField<String> LINK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("linkId")
            .getter(getter(CreateLinkResponse::linkId)).setter(setter(Builder::linkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("linkId").build()).build();

    private static final SdkField<String> CUSTOMER_PROVIDED_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customerProvidedId").getter(getter(CreateLinkResponse::customerProvidedId))
            .setter(setter(Builder::customerProvidedId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerProvidedId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ID_FIELD,
            PEER_GATEWAY_ID_FIELD, STATUS_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, DIRECTION_FIELD, FLOW_MODULES_FIELD,
            PENDING_FLOW_MODULES_FIELD, ATTRIBUTES_FIELD, LINK_ID_FIELD, CUSTOMER_PROVIDED_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String gatewayId;

    private final String peerGatewayId;

    private final String status;

    private final Instant createdAt;

    private final Instant updatedAt;

    private final String direction;

    private final List<ModuleConfiguration> flowModules;

    private final List<ModuleConfiguration> pendingFlowModules;

    private final LinkAttributes attributes;

    private final String linkId;

    private final String customerProvidedId;

    private CreateLinkResponse(BuilderImpl builder) {
        super(builder);
        this.gatewayId = builder.gatewayId;
        this.peerGatewayId = builder.peerGatewayId;
        this.status = builder.status;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.direction = builder.direction;
        this.flowModules = builder.flowModules;
        this.pendingFlowModules = builder.pendingFlowModules;
        this.attributes = builder.attributes;
        this.linkId = builder.linkId;
        this.customerProvidedId = builder.customerProvidedId;
    }

    /**
     * <p>
     * The unique identifier of the gateway.
     * </p>
     * 
     * @return The unique identifier of the gateway.
     */
    public final String gatewayId() {
        return gatewayId;
    }

    /**
     * <p>
     * The unique identifier of the peer gateway.
     * </p>
     * 
     * @return The unique identifier of the peer gateway.
     */
    public final String peerGatewayId() {
        return peerGatewayId;
    }

    /**
     * <p>
     * The status of the request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link LinkStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the request.
     * @see LinkStatus
     */
    public final LinkStatus status() {
        return LinkStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link LinkStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the request.
     * @see LinkStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The timestamp of when the link was created.
     * </p>
     * 
     * @return The timestamp of when the link was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The timestamp of when the link was updated.
     * </p>
     * 
     * @return The timestamp of when the link was updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The direction of the link.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #direction} will
     * return {@link LinkDirection#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #directionAsString}.
     * </p>
     * 
     * @return The direction of the link.
     * @see LinkDirection
     */
    public final LinkDirection direction() {
        return LinkDirection.fromValue(direction);
    }

    /**
     * <p>
     * The direction of the link.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #direction} will
     * return {@link LinkDirection#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #directionAsString}.
     * </p>
     * 
     * @return The direction of the link.
     * @see LinkDirection
     */
    public final String directionAsString() {
        return direction;
    }

    /**
     * For responses, this returns true if the service returned a value for the FlowModules property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFlowModules() {
        return flowModules != null && !(flowModules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The configuration of flow modules.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFlowModules} method.
     * </p>
     * 
     * @return The configuration of flow modules.
     */
    public final List<ModuleConfiguration> flowModules() {
        return flowModules;
    }

    /**
     * For responses, this returns true if the service returned a value for the PendingFlowModules property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPendingFlowModules() {
        return pendingFlowModules != null && !(pendingFlowModules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The configuration of pending flow modules.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPendingFlowModules} method.
     * </p>
     * 
     * @return The configuration of pending flow modules.
     */
    public final List<ModuleConfiguration> pendingFlowModules() {
        return pendingFlowModules;
    }

    /**
     * <p>
     * Attributes of the link.
     * </p>
     * 
     * @return Attributes of the link.
     */
    public final LinkAttributes attributes() {
        return attributes;
    }

    /**
     * <p>
     * The unique identifier of the link.
     * </p>
     * 
     * @return The unique identifier of the link.
     */
    public final String linkId() {
        return linkId;
    }

    /**
     * <p>
     * The customer-provided unique identifier of the link.
     * </p>
     * 
     * @return The customer-provided unique identifier of the link.
     */
    public final String customerProvidedId() {
        return customerProvidedId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(peerGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(directionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasFlowModules() ? flowModules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPendingFlowModules() ? pendingFlowModules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(attributes());
        hashCode = 31 * hashCode + Objects.hashCode(linkId());
        hashCode = 31 * hashCode + Objects.hashCode(customerProvidedId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLinkResponse)) {
            return false;
        }
        CreateLinkResponse other = (CreateLinkResponse) obj;
        return Objects.equals(gatewayId(), other.gatewayId()) && Objects.equals(peerGatewayId(), other.peerGatewayId())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(updatedAt(), other.updatedAt())
                && Objects.equals(directionAsString(), other.directionAsString()) && hasFlowModules() == other.hasFlowModules()
                && Objects.equals(flowModules(), other.flowModules()) && hasPendingFlowModules() == other.hasPendingFlowModules()
                && Objects.equals(pendingFlowModules(), other.pendingFlowModules())
                && Objects.equals(attributes(), other.attributes()) && Objects.equals(linkId(), other.linkId())
                && Objects.equals(customerProvidedId(), other.customerProvidedId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateLinkResponse").add("GatewayId", gatewayId()).add("PeerGatewayId", peerGatewayId())
                .add("Status", statusAsString()).add("CreatedAt", createdAt()).add("UpdatedAt", updatedAt())
                .add("Direction", directionAsString()).add("FlowModules", hasFlowModules() ? flowModules() : null)
                .add("PendingFlowModules", hasPendingFlowModules() ? pendingFlowModules() : null).add("Attributes", attributes())
                .add("LinkId", linkId()).add("CustomerProvidedId", customerProvidedId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "gatewayId":
            return Optional.ofNullable(clazz.cast(gatewayId()));
        case "peerGatewayId":
            return Optional.ofNullable(clazz.cast(peerGatewayId()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "direction":
            return Optional.ofNullable(clazz.cast(directionAsString()));
        case "flowModules":
            return Optional.ofNullable(clazz.cast(flowModules()));
        case "pendingFlowModules":
            return Optional.ofNullable(clazz.cast(pendingFlowModules()));
        case "attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        case "linkId":
            return Optional.ofNullable(clazz.cast(linkId()));
        case "customerProvidedId":
            return Optional.ofNullable(clazz.cast(customerProvidedId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("gatewayId", GATEWAY_ID_FIELD);
        map.put("peerGatewayId", PEER_GATEWAY_ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("direction", DIRECTION_FIELD);
        map.put("flowModules", FLOW_MODULES_FIELD);
        map.put("pendingFlowModules", PENDING_FLOW_MODULES_FIELD);
        map.put("attributes", ATTRIBUTES_FIELD);
        map.put("linkId", LINK_ID_FIELD);
        map.put("customerProvidedId", CUSTOMER_PROVIDED_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateLinkResponse, T> g) {
        return obj -> g.apply((CreateLinkResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends RtbFabricResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateLinkResponse> {
        /**
         * <p>
         * The unique identifier of the gateway.
         * </p>
         * 
         * @param gatewayId
         *        The unique identifier of the gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayId(String gatewayId);

        /**
         * <p>
         * The unique identifier of the peer gateway.
         * </p>
         * 
         * @param peerGatewayId
         *        The unique identifier of the peer gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peerGatewayId(String peerGatewayId);

        /**
         * <p>
         * The status of the request.
         * </p>
         * 
         * @param status
         *        The status of the request.
         * @see LinkStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LinkStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the request.
         * </p>
         * 
         * @param status
         *        The status of the request.
         * @see LinkStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LinkStatus
         */
        Builder status(LinkStatus status);

        /**
         * <p>
         * The timestamp of when the link was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp of when the link was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The timestamp of when the link was updated.
         * </p>
         * 
         * @param updatedAt
         *        The timestamp of when the link was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The direction of the link.
         * </p>
         * 
         * @param direction
         *        The direction of the link.
         * @see LinkDirection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LinkDirection
         */
        Builder direction(String direction);

        /**
         * <p>
         * The direction of the link.
         * </p>
         * 
         * @param direction
         *        The direction of the link.
         * @see LinkDirection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LinkDirection
         */
        Builder direction(LinkDirection direction);

        /**
         * <p>
         * The configuration of flow modules.
         * </p>
         * 
         * @param flowModules
         *        The configuration of flow modules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowModules(Collection<ModuleConfiguration> flowModules);

        /**
         * <p>
         * The configuration of flow modules.
         * </p>
         * 
         * @param flowModules
         *        The configuration of flow modules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowModules(ModuleConfiguration... flowModules);

        /**
         * <p>
         * The configuration of flow modules.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rtbfabric.model.ModuleConfiguration.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.rtbfabric.model.ModuleConfiguration#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rtbfabric.model.ModuleConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #flowModules(List<ModuleConfiguration>)}.
         * 
         * @param flowModules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rtbfabric.model.ModuleConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #flowModules(java.util.Collection<ModuleConfiguration>)
         */
        Builder flowModules(Consumer<ModuleConfiguration.Builder>... flowModules);

        /**
         * <p>
         * The configuration of pending flow modules.
         * </p>
         * 
         * @param pendingFlowModules
         *        The configuration of pending flow modules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingFlowModules(Collection<ModuleConfiguration> pendingFlowModules);

        /**
         * <p>
         * The configuration of pending flow modules.
         * </p>
         * 
         * @param pendingFlowModules
         *        The configuration of pending flow modules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingFlowModules(ModuleConfiguration... pendingFlowModules);

        /**
         * <p>
         * The configuration of pending flow modules.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rtbfabric.model.ModuleConfiguration.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.rtbfabric.model.ModuleConfiguration#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rtbfabric.model.ModuleConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #pendingFlowModules(List<ModuleConfiguration>)}.
         * 
         * @param pendingFlowModules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rtbfabric.model.ModuleConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pendingFlowModules(java.util.Collection<ModuleConfiguration>)
         */
        Builder pendingFlowModules(Consumer<ModuleConfiguration.Builder>... pendingFlowModules);

        /**
         * <p>
         * Attributes of the link.
         * </p>
         * 
         * @param attributes
         *        Attributes of the link.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(LinkAttributes attributes);

        /**
         * <p>
         * Attributes of the link.
         * </p>
         * This is a convenience method that creates an instance of the {@link LinkAttributes.Builder} avoiding the need
         * to create one manually via {@link LinkAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LinkAttributes.Builder#build()} is called immediately and its
         * result is passed to {@link #attributes(LinkAttributes)}.
         * 
         * @param attributes
         *        a consumer that will call methods on {@link LinkAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributes(LinkAttributes)
         */
        default Builder attributes(Consumer<LinkAttributes.Builder> attributes) {
            return attributes(LinkAttributes.builder().applyMutation(attributes).build());
        }

        /**
         * <p>
         * The unique identifier of the link.
         * </p>
         * 
         * @param linkId
         *        The unique identifier of the link.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linkId(String linkId);

        /**
         * <p>
         * The customer-provided unique identifier of the link.
         * </p>
         * 
         * @param customerProvidedId
         *        The customer-provided unique identifier of the link.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerProvidedId(String customerProvidedId);
    }

    static final class BuilderImpl extends RtbFabricResponse.BuilderImpl implements Builder {
        private String gatewayId;

        private String peerGatewayId;

        private String status;

        private Instant createdAt;

        private Instant updatedAt;

        private String direction;

        private List<ModuleConfiguration> flowModules = DefaultSdkAutoConstructList.getInstance();

        private List<ModuleConfiguration> pendingFlowModules = DefaultSdkAutoConstructList.getInstance();

        private LinkAttributes attributes;

        private String linkId;

        private String customerProvidedId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLinkResponse model) {
            super(model);
            gatewayId(model.gatewayId);
            peerGatewayId(model.peerGatewayId);
            status(model.status);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
            direction(model.direction);
            flowModules(model.flowModules);
            pendingFlowModules(model.pendingFlowModules);
            attributes(model.attributes);
            linkId(model.linkId);
            customerProvidedId(model.customerProvidedId);
        }

        public final String getGatewayId() {
            return gatewayId;
        }

        public final void setGatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
        }

        @Override
        public final Builder gatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
            return this;
        }

        public final String getPeerGatewayId() {
            return peerGatewayId;
        }

        public final void setPeerGatewayId(String peerGatewayId) {
            this.peerGatewayId = peerGatewayId;
        }

        @Override
        public final Builder peerGatewayId(String peerGatewayId) {
            this.peerGatewayId = peerGatewayId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(LinkStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getDirection() {
            return direction;
        }

        public final void setDirection(String direction) {
            this.direction = direction;
        }

        @Override
        public final Builder direction(String direction) {
            this.direction = direction;
            return this;
        }

        @Override
        public final Builder direction(LinkDirection direction) {
            this.direction(direction == null ? null : direction.toString());
            return this;
        }

        public final List<ModuleConfiguration.Builder> getFlowModules() {
            List<ModuleConfiguration.Builder> result = ModuleConfigurationListCopier.copyToBuilder(this.flowModules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFlowModules(Collection<ModuleConfiguration.BuilderImpl> flowModules) {
            this.flowModules = ModuleConfigurationListCopier.copyFromBuilder(flowModules);
        }

        @Override
        public final Builder flowModules(Collection<ModuleConfiguration> flowModules) {
            this.flowModules = ModuleConfigurationListCopier.copy(flowModules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flowModules(ModuleConfiguration... flowModules) {
            flowModules(Arrays.asList(flowModules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flowModules(Consumer<ModuleConfiguration.Builder>... flowModules) {
            flowModules(Stream.of(flowModules).map(c -> ModuleConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ModuleConfiguration.Builder> getPendingFlowModules() {
            List<ModuleConfiguration.Builder> result = ModuleConfigurationListCopier.copyToBuilder(this.pendingFlowModules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPendingFlowModules(Collection<ModuleConfiguration.BuilderImpl> pendingFlowModules) {
            this.pendingFlowModules = ModuleConfigurationListCopier.copyFromBuilder(pendingFlowModules);
        }

        @Override
        public final Builder pendingFlowModules(Collection<ModuleConfiguration> pendingFlowModules) {
            this.pendingFlowModules = ModuleConfigurationListCopier.copy(pendingFlowModules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pendingFlowModules(ModuleConfiguration... pendingFlowModules) {
            pendingFlowModules(Arrays.asList(pendingFlowModules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pendingFlowModules(Consumer<ModuleConfiguration.Builder>... pendingFlowModules) {
            pendingFlowModules(Stream.of(pendingFlowModules).map(c -> ModuleConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final LinkAttributes.Builder getAttributes() {
            return attributes != null ? attributes.toBuilder() : null;
        }

        public final void setAttributes(LinkAttributes.BuilderImpl attributes) {
            this.attributes = attributes != null ? attributes.build() : null;
        }

        @Override
        public final Builder attributes(LinkAttributes attributes) {
            this.attributes = attributes;
            return this;
        }

        public final String getLinkId() {
            return linkId;
        }

        public final void setLinkId(String linkId) {
            this.linkId = linkId;
        }

        @Override
        public final Builder linkId(String linkId) {
            this.linkId = linkId;
            return this;
        }

        public final String getCustomerProvidedId() {
            return customerProvidedId;
        }

        public final void setCustomerProvidedId(String customerProvidedId) {
            this.customerProvidedId = customerProvidedId;
        }

        @Override
        public final Builder customerProvidedId(String customerProvidedId) {
            this.customerProvidedId = customerProvidedId;
            return this;
        }

        @Override
        public CreateLinkResponse build() {
            return new CreateLinkResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
