/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rtbfabric.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateLinkRequest extends RtbFabricRequest implements
        ToCopyableBuilder<CreateLinkRequest.Builder, CreateLinkRequest> {
    private static final SdkField<String> GATEWAY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("gatewayId").getter(getter(CreateLinkRequest::gatewayId)).setter(setter(Builder::gatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("gatewayId").build()).build();

    private static final SdkField<String> PEER_GATEWAY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("peerGatewayId").getter(getter(CreateLinkRequest::peerGatewayId)).setter(setter(Builder::peerGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("peerGatewayId").build()).build();

    private static final SdkField<LinkAttributes> ATTRIBUTES_FIELD = SdkField.<LinkAttributes> builder(MarshallingType.SDK_POJO)
            .memberName("attributes").getter(getter(CreateLinkRequest::attributes)).setter(setter(Builder::attributes))
            .constructor(LinkAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build()).build();

    private static final SdkField<Boolean> HTTP_RESPONDER_ALLOWED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("httpResponderAllowed").getter(getter(CreateLinkRequest::httpResponderAllowed))
            .setter(setter(Builder::httpResponderAllowed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("httpResponderAllowed").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateLinkRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<LinkLogSettings> LOG_SETTINGS_FIELD = SdkField
            .<LinkLogSettings> builder(MarshallingType.SDK_POJO).memberName("logSettings")
            .getter(getter(CreateLinkRequest::logSettings)).setter(setter(Builder::logSettings))
            .constructor(LinkLogSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logSettings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ID_FIELD,
            PEER_GATEWAY_ID_FIELD, ATTRIBUTES_FIELD, HTTP_RESPONDER_ALLOWED_FIELD, TAGS_FIELD, LOG_SETTINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String gatewayId;

    private final String peerGatewayId;

    private final LinkAttributes attributes;

    private final Boolean httpResponderAllowed;

    private final Map<String, String> tags;

    private final LinkLogSettings logSettings;

    private CreateLinkRequest(BuilderImpl builder) {
        super(builder);
        this.gatewayId = builder.gatewayId;
        this.peerGatewayId = builder.peerGatewayId;
        this.attributes = builder.attributes;
        this.httpResponderAllowed = builder.httpResponderAllowed;
        this.tags = builder.tags;
        this.logSettings = builder.logSettings;
    }

    /**
     * <p>
     * The unique identifier of the gateway.
     * </p>
     * 
     * @return The unique identifier of the gateway.
     */
    public final String gatewayId() {
        return gatewayId;
    }

    /**
     * <p>
     * The unique identifier of the peer gateway.
     * </p>
     * 
     * @return The unique identifier of the peer gateway.
     */
    public final String peerGatewayId() {
        return peerGatewayId;
    }

    /**
     * <p>
     * Attributes of the link.
     * </p>
     * 
     * @return Attributes of the link.
     */
    public final LinkAttributes attributes() {
        return attributes;
    }

    /**
     * <p>
     * Boolean to specify if an HTTP responder is allowed.
     * </p>
     * 
     * @return Boolean to specify if an HTTP responder is allowed.
     */
    public final Boolean httpResponderAllowed() {
        return httpResponderAllowed;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of the key-value pairs of the tag or tags to assign to the resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A map of the key-value pairs of the tag or tags to assign to the resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * Settings for the application logs.
     * </p>
     * 
     * @return Settings for the application logs.
     */
    public final LinkLogSettings logSettings() {
        return logSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(peerGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(attributes());
        hashCode = 31 * hashCode + Objects.hashCode(httpResponderAllowed());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(logSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLinkRequest)) {
            return false;
        }
        CreateLinkRequest other = (CreateLinkRequest) obj;
        return Objects.equals(gatewayId(), other.gatewayId()) && Objects.equals(peerGatewayId(), other.peerGatewayId())
                && Objects.equals(attributes(), other.attributes())
                && Objects.equals(httpResponderAllowed(), other.httpResponderAllowed()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(logSettings(), other.logSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateLinkRequest").add("GatewayId", gatewayId()).add("PeerGatewayId", peerGatewayId())
                .add("Attributes", attributes()).add("HttpResponderAllowed", httpResponderAllowed())
                .add("Tags", hasTags() ? tags() : null).add("LogSettings", logSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "gatewayId":
            return Optional.ofNullable(clazz.cast(gatewayId()));
        case "peerGatewayId":
            return Optional.ofNullable(clazz.cast(peerGatewayId()));
        case "attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        case "httpResponderAllowed":
            return Optional.ofNullable(clazz.cast(httpResponderAllowed()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "logSettings":
            return Optional.ofNullable(clazz.cast(logSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("gatewayId", GATEWAY_ID_FIELD);
        map.put("peerGatewayId", PEER_GATEWAY_ID_FIELD);
        map.put("attributes", ATTRIBUTES_FIELD);
        map.put("httpResponderAllowed", HTTP_RESPONDER_ALLOWED_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("logSettings", LOG_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateLinkRequest, T> g) {
        return obj -> g.apply((CreateLinkRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends RtbFabricRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateLinkRequest> {
        /**
         * <p>
         * The unique identifier of the gateway.
         * </p>
         * 
         * @param gatewayId
         *        The unique identifier of the gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayId(String gatewayId);

        /**
         * <p>
         * The unique identifier of the peer gateway.
         * </p>
         * 
         * @param peerGatewayId
         *        The unique identifier of the peer gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peerGatewayId(String peerGatewayId);

        /**
         * <p>
         * Attributes of the link.
         * </p>
         * 
         * @param attributes
         *        Attributes of the link.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(LinkAttributes attributes);

        /**
         * <p>
         * Attributes of the link.
         * </p>
         * This is a convenience method that creates an instance of the {@link LinkAttributes.Builder} avoiding the need
         * to create one manually via {@link LinkAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LinkAttributes.Builder#build()} is called immediately and its
         * result is passed to {@link #attributes(LinkAttributes)}.
         * 
         * @param attributes
         *        a consumer that will call methods on {@link LinkAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributes(LinkAttributes)
         */
        default Builder attributes(Consumer<LinkAttributes.Builder> attributes) {
            return attributes(LinkAttributes.builder().applyMutation(attributes).build());
        }

        /**
         * <p>
         * Boolean to specify if an HTTP responder is allowed.
         * </p>
         * 
         * @param httpResponderAllowed
         *        Boolean to specify if an HTTP responder is allowed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpResponderAllowed(Boolean httpResponderAllowed);

        /**
         * <p>
         * A map of the key-value pairs of the tag or tags to assign to the resource.
         * </p>
         * 
         * @param tags
         *        A map of the key-value pairs of the tag or tags to assign to the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * Settings for the application logs.
         * </p>
         * 
         * @param logSettings
         *        Settings for the application logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logSettings(LinkLogSettings logSettings);

        /**
         * <p>
         * Settings for the application logs.
         * </p>
         * This is a convenience method that creates an instance of the {@link LinkLogSettings.Builder} avoiding the
         * need to create one manually via {@link LinkLogSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LinkLogSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #logSettings(LinkLogSettings)}.
         * 
         * @param logSettings
         *        a consumer that will call methods on {@link LinkLogSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logSettings(LinkLogSettings)
         */
        default Builder logSettings(Consumer<LinkLogSettings.Builder> logSettings) {
            return logSettings(LinkLogSettings.builder().applyMutation(logSettings).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RtbFabricRequest.BuilderImpl implements Builder {
        private String gatewayId;

        private String peerGatewayId;

        private LinkAttributes attributes;

        private Boolean httpResponderAllowed;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private LinkLogSettings logSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLinkRequest model) {
            super(model);
            gatewayId(model.gatewayId);
            peerGatewayId(model.peerGatewayId);
            attributes(model.attributes);
            httpResponderAllowed(model.httpResponderAllowed);
            tags(model.tags);
            logSettings(model.logSettings);
        }

        public final String getGatewayId() {
            return gatewayId;
        }

        public final void setGatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
        }

        @Override
        public final Builder gatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
            return this;
        }

        public final String getPeerGatewayId() {
            return peerGatewayId;
        }

        public final void setPeerGatewayId(String peerGatewayId) {
            this.peerGatewayId = peerGatewayId;
        }

        @Override
        public final Builder peerGatewayId(String peerGatewayId) {
            this.peerGatewayId = peerGatewayId;
            return this;
        }

        public final LinkAttributes.Builder getAttributes() {
            return attributes != null ? attributes.toBuilder() : null;
        }

        public final void setAttributes(LinkAttributes.BuilderImpl attributes) {
            this.attributes = attributes != null ? attributes.build() : null;
        }

        @Override
        public final Builder attributes(LinkAttributes attributes) {
            this.attributes = attributes;
            return this;
        }

        public final Boolean getHttpResponderAllowed() {
            return httpResponderAllowed;
        }

        public final void setHttpResponderAllowed(Boolean httpResponderAllowed) {
            this.httpResponderAllowed = httpResponderAllowed;
        }

        @Override
        public final Builder httpResponderAllowed(Boolean httpResponderAllowed) {
            this.httpResponderAllowed = httpResponderAllowed;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public final LinkLogSettings.Builder getLogSettings() {
            return logSettings != null ? logSettings.toBuilder() : null;
        }

        public final void setLogSettings(LinkLogSettings.BuilderImpl logSettings) {
            this.logSettings = logSettings != null ? logSettings.build() : null;
        }

        @Override
        public final Builder logSettings(LinkLogSettings logSettings) {
            this.logSettings = logSettings;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLinkRequest build() {
            return new CreateLinkRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
