/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rtbfabric.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AcceptLinkRequest extends RtbFabricRequest implements
        ToCopyableBuilder<AcceptLinkRequest.Builder, AcceptLinkRequest> {
    private static final SdkField<String> GATEWAY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("gatewayId").getter(getter(AcceptLinkRequest::gatewayId)).setter(setter(Builder::gatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("gatewayId").build()).build();

    private static final SdkField<String> LINK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("linkId")
            .getter(getter(AcceptLinkRequest::linkId)).setter(setter(Builder::linkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("linkId").build()).build();

    private static final SdkField<LinkAttributes> ATTRIBUTES_FIELD = SdkField.<LinkAttributes> builder(MarshallingType.SDK_POJO)
            .memberName("attributes").getter(getter(AcceptLinkRequest::attributes)).setter(setter(Builder::attributes))
            .constructor(LinkAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build()).build();

    private static final SdkField<LinkLogSettings> LOG_SETTINGS_FIELD = SdkField
            .<LinkLogSettings> builder(MarshallingType.SDK_POJO).memberName("logSettings")
            .getter(getter(AcceptLinkRequest::logSettings)).setter(setter(Builder::logSettings))
            .constructor(LinkLogSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logSettings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ID_FIELD,
            LINK_ID_FIELD, ATTRIBUTES_FIELD, LOG_SETTINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String gatewayId;

    private final String linkId;

    private final LinkAttributes attributes;

    private final LinkLogSettings logSettings;

    private AcceptLinkRequest(BuilderImpl builder) {
        super(builder);
        this.gatewayId = builder.gatewayId;
        this.linkId = builder.linkId;
        this.attributes = builder.attributes;
        this.logSettings = builder.logSettings;
    }

    /**
     * <p>
     * The unique identifier of the gateway.
     * </p>
     * 
     * @return The unique identifier of the gateway.
     */
    public final String gatewayId() {
        return gatewayId;
    }

    /**
     * <p>
     * The unique identifier of the link.
     * </p>
     * 
     * @return The unique identifier of the link.
     */
    public final String linkId() {
        return linkId;
    }

    /**
     * <p>
     * Attributes of the link.
     * </p>
     * 
     * @return Attributes of the link.
     */
    public final LinkAttributes attributes() {
        return attributes;
    }

    /**
     * <p>
     * Settings for the application logs.
     * </p>
     * 
     * @return Settings for the application logs.
     */
    public final LinkLogSettings logSettings() {
        return logSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(linkId());
        hashCode = 31 * hashCode + Objects.hashCode(attributes());
        hashCode = 31 * hashCode + Objects.hashCode(logSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AcceptLinkRequest)) {
            return false;
        }
        AcceptLinkRequest other = (AcceptLinkRequest) obj;
        return Objects.equals(gatewayId(), other.gatewayId()) && Objects.equals(linkId(), other.linkId())
                && Objects.equals(attributes(), other.attributes()) && Objects.equals(logSettings(), other.logSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AcceptLinkRequest").add("GatewayId", gatewayId()).add("LinkId", linkId())
                .add("Attributes", attributes()).add("LogSettings", logSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "gatewayId":
            return Optional.ofNullable(clazz.cast(gatewayId()));
        case "linkId":
            return Optional.ofNullable(clazz.cast(linkId()));
        case "attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        case "logSettings":
            return Optional.ofNullable(clazz.cast(logSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("gatewayId", GATEWAY_ID_FIELD);
        map.put("linkId", LINK_ID_FIELD);
        map.put("attributes", ATTRIBUTES_FIELD);
        map.put("logSettings", LOG_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AcceptLinkRequest, T> g) {
        return obj -> g.apply((AcceptLinkRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends RtbFabricRequest.Builder, SdkPojo, CopyableBuilder<Builder, AcceptLinkRequest> {
        /**
         * <p>
         * The unique identifier of the gateway.
         * </p>
         * 
         * @param gatewayId
         *        The unique identifier of the gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayId(String gatewayId);

        /**
         * <p>
         * The unique identifier of the link.
         * </p>
         * 
         * @param linkId
         *        The unique identifier of the link.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linkId(String linkId);

        /**
         * <p>
         * Attributes of the link.
         * </p>
         * 
         * @param attributes
         *        Attributes of the link.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(LinkAttributes attributes);

        /**
         * <p>
         * Attributes of the link.
         * </p>
         * This is a convenience method that creates an instance of the {@link LinkAttributes.Builder} avoiding the need
         * to create one manually via {@link LinkAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LinkAttributes.Builder#build()} is called immediately and its
         * result is passed to {@link #attributes(LinkAttributes)}.
         * 
         * @param attributes
         *        a consumer that will call methods on {@link LinkAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributes(LinkAttributes)
         */
        default Builder attributes(Consumer<LinkAttributes.Builder> attributes) {
            return attributes(LinkAttributes.builder().applyMutation(attributes).build());
        }

        /**
         * <p>
         * Settings for the application logs.
         * </p>
         * 
         * @param logSettings
         *        Settings for the application logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logSettings(LinkLogSettings logSettings);

        /**
         * <p>
         * Settings for the application logs.
         * </p>
         * This is a convenience method that creates an instance of the {@link LinkLogSettings.Builder} avoiding the
         * need to create one manually via {@link LinkLogSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LinkLogSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #logSettings(LinkLogSettings)}.
         * 
         * @param logSettings
         *        a consumer that will call methods on {@link LinkLogSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logSettings(LinkLogSettings)
         */
        default Builder logSettings(Consumer<LinkLogSettings.Builder> logSettings) {
            return logSettings(LinkLogSettings.builder().applyMutation(logSettings).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RtbFabricRequest.BuilderImpl implements Builder {
        private String gatewayId;

        private String linkId;

        private LinkAttributes attributes;

        private LinkLogSettings logSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(AcceptLinkRequest model) {
            super(model);
            gatewayId(model.gatewayId);
            linkId(model.linkId);
            attributes(model.attributes);
            logSettings(model.logSettings);
        }

        public final String getGatewayId() {
            return gatewayId;
        }

        public final void setGatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
        }

        @Override
        public final Builder gatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
            return this;
        }

        public final String getLinkId() {
            return linkId;
        }

        public final void setLinkId(String linkId) {
            this.linkId = linkId;
        }

        @Override
        public final Builder linkId(String linkId) {
            this.linkId = linkId;
            return this;
        }

        public final LinkAttributes.Builder getAttributes() {
            return attributes != null ? attributes.toBuilder() : null;
        }

        public final void setAttributes(LinkAttributes.BuilderImpl attributes) {
            this.attributes = attributes != null ? attributes.build() : null;
        }

        @Override
        public final Builder attributes(LinkAttributes attributes) {
            this.attributes = attributes;
            return this;
        }

        public final LinkLogSettings.Builder getLogSettings() {
            return logSettings != null ? logSettings.toBuilder() : null;
        }

        public final void setLogSettings(LinkLogSettings.BuilderImpl logSettings) {
            this.logSettings = logSettings != null ? logSettings.build() : null;
        }

        @Override
        public final Builder logSettings(LinkLogSettings logSettings) {
            this.logSettings = logSettings;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AcceptLinkRequest build() {
            return new AcceptLinkRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
