/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rtbfabric.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rtbfabric.RtbFabricClient;
import software.amazon.awssdk.services.rtbfabric.internal.UserAgentUtils;
import software.amazon.awssdk.services.rtbfabric.model.ListResponderGatewaysRequest;
import software.amazon.awssdk.services.rtbfabric.model.ListResponderGatewaysResponse;

public class ListResponderGatewaysIterable
implements SdkIterable<ListResponderGatewaysResponse> {
    private final RtbFabricClient client;
    private final ListResponderGatewaysRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListResponderGatewaysIterable(RtbFabricClient client, ListResponderGatewaysRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListResponderGatewaysResponseFetcher();
    }

    public Iterator<ListResponderGatewaysResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> gatewayIds() {
        Function<ListResponderGatewaysResponse, Iterator> getIterator = response -> {
            if (response != null && response.gatewayIds() != null) {
                return response.gatewayIds().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListResponderGatewaysResponseFetcher
    implements SyncPageFetcher<ListResponderGatewaysResponse> {
        private ListResponderGatewaysResponseFetcher() {
        }

        public boolean hasNextPage(ListResponderGatewaysResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListResponderGatewaysResponse nextPage(ListResponderGatewaysResponse previousPage) {
            if (previousPage == null) {
                return ListResponderGatewaysIterable.this.client.listResponderGateways(ListResponderGatewaysIterable.this.firstRequest);
            }
            return ListResponderGatewaysIterable.this.client.listResponderGateways((ListResponderGatewaysRequest)((Object)ListResponderGatewaysIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

