/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rtbfabric.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rtbfabric.model.ModuleConfiguration;
import software.amazon.awssdk.services.rtbfabric.model.ModuleConfigurationListCopier;
import software.amazon.awssdk.services.rtbfabric.model.RtbFabricRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateLinkModuleFlowRequest
extends RtbFabricRequest
implements ToCopyableBuilder<Builder, UpdateLinkModuleFlowRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(UpdateLinkModuleFlowRequest.getter(UpdateLinkModuleFlowRequest::clientToken)).setter(UpdateLinkModuleFlowRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("gatewayId").getter(UpdateLinkModuleFlowRequest.getter(UpdateLinkModuleFlowRequest::gatewayId)).setter(UpdateLinkModuleFlowRequest.setter(Builder::gatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("gatewayId").build()}).build();
    private static final SdkField<String> LINK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("linkId").getter(UpdateLinkModuleFlowRequest.getter(UpdateLinkModuleFlowRequest::linkId)).setter(UpdateLinkModuleFlowRequest.setter(Builder::linkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("linkId").build()}).build();
    private static final SdkField<List<ModuleConfiguration>> MODULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("modules").getter(UpdateLinkModuleFlowRequest.getter(UpdateLinkModuleFlowRequest::modules)).setter(UpdateLinkModuleFlowRequest.setter(Builder::modules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ModuleConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, GATEWAY_ID_FIELD, LINK_ID_FIELD, MODULES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateLinkModuleFlowRequest.memberNameToFieldInitializer();
    private final String clientToken;
    private final String gatewayId;
    private final String linkId;
    private final List<ModuleConfiguration> modules;

    private UpdateLinkModuleFlowRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.gatewayId = builder.gatewayId;
        this.linkId = builder.linkId;
        this.modules = builder.modules;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String gatewayId() {
        return this.gatewayId;
    }

    public final String linkId() {
        return this.linkId;
    }

    public final boolean hasModules() {
        return this.modules != null && !(this.modules instanceof SdkAutoConstructList);
    }

    public final List<ModuleConfiguration> modules() {
        return this.modules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.linkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasModules() ? this.modules() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLinkModuleFlowRequest)) {
            return false;
        }
        UpdateLinkModuleFlowRequest other = (UpdateLinkModuleFlowRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.gatewayId(), other.gatewayId()) && Objects.equals(this.linkId(), other.linkId()) && this.hasModules() == other.hasModules() && Objects.equals(this.modules(), other.modules());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateLinkModuleFlowRequest").add("ClientToken", (Object)this.clientToken()).add("GatewayId", (Object)this.gatewayId()).add("LinkId", (Object)this.linkId()).add("Modules", this.hasModules() ? this.modules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "gatewayId": {
                return Optional.ofNullable(clazz.cast(this.gatewayId()));
            }
            case "linkId": {
                return Optional.ofNullable(clazz.cast(this.linkId()));
            }
            case "modules": {
                return Optional.ofNullable(clazz.cast(this.modules()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("gatewayId", GATEWAY_ID_FIELD);
        map.put("linkId", LINK_ID_FIELD);
        map.put("modules", MODULES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateLinkModuleFlowRequest, T> g) {
        return obj -> g.apply((UpdateLinkModuleFlowRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RtbFabricRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String gatewayId;
        private String linkId;
        private List<ModuleConfiguration> modules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLinkModuleFlowRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.gatewayId(model.gatewayId);
            this.linkId(model.linkId);
            this.modules(model.modules);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getGatewayId() {
            return this.gatewayId;
        }

        public final void setGatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
        }

        @Override
        public final Builder gatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
            return this;
        }

        public final String getLinkId() {
            return this.linkId;
        }

        public final void setLinkId(String linkId) {
            this.linkId = linkId;
        }

        @Override
        public final Builder linkId(String linkId) {
            this.linkId = linkId;
            return this;
        }

        public final List<ModuleConfiguration.Builder> getModules() {
            List<ModuleConfiguration.Builder> result = ModuleConfigurationListCopier.copyToBuilder(this.modules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setModules(Collection<ModuleConfiguration.BuilderImpl> modules) {
            this.modules = ModuleConfigurationListCopier.copyFromBuilder(modules);
        }

        @Override
        public final Builder modules(Collection<ModuleConfiguration> modules) {
            this.modules = ModuleConfigurationListCopier.copy(modules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modules(ModuleConfiguration ... modules) {
            this.modules(Arrays.asList(modules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modules(Consumer<ModuleConfiguration.Builder> ... modules) {
            this.modules(Stream.of(modules).map(c -> (ModuleConfiguration)((ModuleConfiguration.Builder)ModuleConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateLinkModuleFlowRequest build() {
            return new UpdateLinkModuleFlowRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RtbFabricRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateLinkModuleFlowRequest> {
        public Builder clientToken(String var1);

        public Builder gatewayId(String var1);

        public Builder linkId(String var1);

        public Builder modules(Collection<ModuleConfiguration> var1);

        public Builder modules(ModuleConfiguration ... var1);

        public Builder modules(Consumer<ModuleConfiguration.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

