/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rtbfabric.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rtbfabric.RtbFabricClient;
import software.amazon.awssdk.services.rtbfabric.internal.UserAgentUtils;
import software.amazon.awssdk.services.rtbfabric.model.ListRequesterGatewaysRequest;
import software.amazon.awssdk.services.rtbfabric.model.ListRequesterGatewaysResponse;

public class ListRequesterGatewaysIterable
implements SdkIterable<ListRequesterGatewaysResponse> {
    private final RtbFabricClient client;
    private final ListRequesterGatewaysRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRequesterGatewaysIterable(RtbFabricClient client, ListRequesterGatewaysRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListRequesterGatewaysResponseFetcher();
    }

    public Iterator<ListRequesterGatewaysResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> gatewayIds() {
        Function<ListRequesterGatewaysResponse, Iterator> getIterator = response -> {
            if (response != null && response.gatewayIds() != null) {
                return response.gatewayIds().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListRequesterGatewaysResponseFetcher
    implements SyncPageFetcher<ListRequesterGatewaysResponse> {
        private ListRequesterGatewaysResponseFetcher() {
        }

        public boolean hasNextPage(ListRequesterGatewaysResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRequesterGatewaysResponse nextPage(ListRequesterGatewaysResponse previousPage) {
            if (previousPage == null) {
                return ListRequesterGatewaysIterable.this.client.listRequesterGateways(ListRequesterGatewaysIterable.this.firstRequest);
            }
            return ListRequesterGatewaysIterable.this.client.listRequesterGateways((ListRequesterGatewaysRequest)((Object)ListRequesterGatewaysIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

