/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rtbfabric.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.rtbfabric.model.LinkAttributes;
import software.amazon.awssdk.services.rtbfabric.model.LinkLogSettings;
import software.amazon.awssdk.services.rtbfabric.model.RtbFabricRequest;
import software.amazon.awssdk.services.rtbfabric.model.TagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateLinkRequest
extends RtbFabricRequest
implements ToCopyableBuilder<Builder, CreateLinkRequest> {
    private static final SdkField<String> GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("gatewayId").getter(CreateLinkRequest.getter(CreateLinkRequest::gatewayId)).setter(CreateLinkRequest.setter(Builder::gatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("gatewayId").build()}).build();
    private static final SdkField<String> PEER_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("peerGatewayId").getter(CreateLinkRequest.getter(CreateLinkRequest::peerGatewayId)).setter(CreateLinkRequest.setter(Builder::peerGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("peerGatewayId").build()}).build();
    private static final SdkField<LinkAttributes> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("attributes").getter(CreateLinkRequest.getter(CreateLinkRequest::attributes)).setter(CreateLinkRequest.setter(Builder::attributes)).constructor(LinkAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build()}).build();
    private static final SdkField<Boolean> HTTP_RESPONDER_ALLOWED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("httpResponderAllowed").getter(CreateLinkRequest.getter(CreateLinkRequest::httpResponderAllowed)).setter(CreateLinkRequest.setter(Builder::httpResponderAllowed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("httpResponderAllowed").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateLinkRequest.getter(CreateLinkRequest::tags)).setter(CreateLinkRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<LinkLogSettings> LOG_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("logSettings").getter(CreateLinkRequest.getter(CreateLinkRequest::logSettings)).setter(CreateLinkRequest.setter(Builder::logSettings)).constructor(LinkLogSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ID_FIELD, PEER_GATEWAY_ID_FIELD, ATTRIBUTES_FIELD, HTTP_RESPONDER_ALLOWED_FIELD, TAGS_FIELD, LOG_SETTINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateLinkRequest.memberNameToFieldInitializer();
    private final String gatewayId;
    private final String peerGatewayId;
    private final LinkAttributes attributes;
    private final Boolean httpResponderAllowed;
    private final Map<String, String> tags;
    private final LinkLogSettings logSettings;

    private CreateLinkRequest(BuilderImpl builder) {
        super(builder);
        this.gatewayId = builder.gatewayId;
        this.peerGatewayId = builder.peerGatewayId;
        this.attributes = builder.attributes;
        this.httpResponderAllowed = builder.httpResponderAllowed;
        this.tags = builder.tags;
        this.logSettings = builder.logSettings;
    }

    public final String gatewayId() {
        return this.gatewayId;
    }

    public final String peerGatewayId() {
        return this.peerGatewayId;
    }

    public final LinkAttributes attributes() {
        return this.attributes;
    }

    public final Boolean httpResponderAllowed() {
        return this.httpResponderAllowed;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final LinkLogSettings logSettings() {
        return this.logSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.peerGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpResponderAllowed());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.logSettings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLinkRequest)) {
            return false;
        }
        CreateLinkRequest other = (CreateLinkRequest)((Object)obj);
        return Objects.equals(this.gatewayId(), other.gatewayId()) && Objects.equals(this.peerGatewayId(), other.peerGatewayId()) && Objects.equals(this.attributes(), other.attributes()) && Objects.equals(this.httpResponderAllowed(), other.httpResponderAllowed()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.logSettings(), other.logSettings());
    }

    public final String toString() {
        return ToString.builder((String)"CreateLinkRequest").add("GatewayId", (Object)this.gatewayId()).add("PeerGatewayId", (Object)this.peerGatewayId()).add("Attributes", (Object)this.attributes()).add("HttpResponderAllowed", (Object)this.httpResponderAllowed()).add("Tags", this.hasTags() ? this.tags() : null).add("LogSettings", (Object)this.logSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "gatewayId": {
                return Optional.ofNullable(clazz.cast(this.gatewayId()));
            }
            case "peerGatewayId": {
                return Optional.ofNullable(clazz.cast(this.peerGatewayId()));
            }
            case "attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "httpResponderAllowed": {
                return Optional.ofNullable(clazz.cast(this.httpResponderAllowed()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "logSettings": {
                return Optional.ofNullable(clazz.cast(this.logSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("gatewayId", GATEWAY_ID_FIELD);
        map.put("peerGatewayId", PEER_GATEWAY_ID_FIELD);
        map.put("attributes", ATTRIBUTES_FIELD);
        map.put("httpResponderAllowed", HTTP_RESPONDER_ALLOWED_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("logSettings", LOG_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateLinkRequest, T> g) {
        return obj -> g.apply((CreateLinkRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RtbFabricRequest.BuilderImpl
    implements Builder {
        private String gatewayId;
        private String peerGatewayId;
        private LinkAttributes attributes;
        private Boolean httpResponderAllowed;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private LinkLogSettings logSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLinkRequest model) {
            super(model);
            this.gatewayId(model.gatewayId);
            this.peerGatewayId(model.peerGatewayId);
            this.attributes(model.attributes);
            this.httpResponderAllowed(model.httpResponderAllowed);
            this.tags(model.tags);
            this.logSettings(model.logSettings);
        }

        public final String getGatewayId() {
            return this.gatewayId;
        }

        public final void setGatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
        }

        @Override
        public final Builder gatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
            return this;
        }

        public final String getPeerGatewayId() {
            return this.peerGatewayId;
        }

        public final void setPeerGatewayId(String peerGatewayId) {
            this.peerGatewayId = peerGatewayId;
        }

        @Override
        public final Builder peerGatewayId(String peerGatewayId) {
            this.peerGatewayId = peerGatewayId;
            return this;
        }

        public final LinkAttributes.Builder getAttributes() {
            return this.attributes != null ? this.attributes.toBuilder() : null;
        }

        public final void setAttributes(LinkAttributes.BuilderImpl attributes) {
            this.attributes = attributes != null ? attributes.build() : null;
        }

        @Override
        public final Builder attributes(LinkAttributes attributes) {
            this.attributes = attributes;
            return this;
        }

        public final Boolean getHttpResponderAllowed() {
            return this.httpResponderAllowed;
        }

        public final void setHttpResponderAllowed(Boolean httpResponderAllowed) {
            this.httpResponderAllowed = httpResponderAllowed;
        }

        @Override
        public final Builder httpResponderAllowed(Boolean httpResponderAllowed) {
            this.httpResponderAllowed = httpResponderAllowed;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public final LinkLogSettings.Builder getLogSettings() {
            return this.logSettings != null ? this.logSettings.toBuilder() : null;
        }

        public final void setLogSettings(LinkLogSettings.BuilderImpl logSettings) {
            this.logSettings = logSettings != null ? logSettings.build() : null;
        }

        @Override
        public final Builder logSettings(LinkLogSettings logSettings) {
            this.logSettings = logSettings;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLinkRequest build() {
            return new CreateLinkRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RtbFabricRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateLinkRequest> {
        public Builder gatewayId(String var1);

        public Builder peerGatewayId(String var1);

        public Builder attributes(LinkAttributes var1);

        default public Builder attributes(Consumer<LinkAttributes.Builder> attributes) {
            return this.attributes((LinkAttributes)((LinkAttributes.Builder)LinkAttributes.builder().applyMutation(attributes)).build());
        }

        public Builder httpResponderAllowed(Boolean var1);

        public Builder tags(Map<String, String> var1);

        public Builder logSettings(LinkLogSettings var1);

        default public Builder logSettings(Consumer<LinkLogSettings.Builder> logSettings) {
            return this.logSettings((LinkLogSettings)((LinkLogSettings.Builder)LinkLogSettings.builder().applyMutation(logSettings)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

