/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53resolver.model.Route53ResolverRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateResolverEndpointRequest
extends Route53ResolverRequest
implements ToCopyableBuilder<Builder, UpdateResolverEndpointRequest> {
    private static final SdkField<String> RESOLVER_ENDPOINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateResolverEndpointRequest.getter(UpdateResolverEndpointRequest::resolverEndpointId)).setter(UpdateResolverEndpointRequest.setter(Builder::resolverEndpointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResolverEndpointId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateResolverEndpointRequest.getter(UpdateResolverEndpointRequest::name)).setter(UpdateResolverEndpointRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOLVER_ENDPOINT_ID_FIELD, NAME_FIELD));
    private final String resolverEndpointId;
    private final String name;

    private UpdateResolverEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.resolverEndpointId = builder.resolverEndpointId;
        this.name = builder.name;
    }

    public String resolverEndpointId() {
        return this.resolverEndpointId;
    }

    public String name() {
        return this.name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resolverEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateResolverEndpointRequest)) {
            return false;
        }
        UpdateResolverEndpointRequest other = (UpdateResolverEndpointRequest)((Object)obj);
        return Objects.equals(this.resolverEndpointId(), other.resolverEndpointId()) && Objects.equals(this.name(), other.name());
    }

    public String toString() {
        return ToString.builder((String)"UpdateResolverEndpointRequest").add("ResolverEndpointId", (Object)this.resolverEndpointId()).add("Name", (Object)this.name()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResolverEndpointId": {
                return Optional.ofNullable(clazz.cast(this.resolverEndpointId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateResolverEndpointRequest, T> g) {
        return obj -> g.apply((UpdateResolverEndpointRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53ResolverRequest.BuilderImpl
    implements Builder {
        private String resolverEndpointId;
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateResolverEndpointRequest model) {
            super(model);
            this.resolverEndpointId(model.resolverEndpointId);
            this.name(model.name);
        }

        public final String getResolverEndpointId() {
            return this.resolverEndpointId;
        }

        @Override
        public final Builder resolverEndpointId(String resolverEndpointId) {
            this.resolverEndpointId = resolverEndpointId;
            return this;
        }

        public final void setResolverEndpointId(String resolverEndpointId) {
            this.resolverEndpointId = resolverEndpointId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateResolverEndpointRequest build() {
            return new UpdateResolverEndpointRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Route53ResolverRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateResolverEndpointRequest> {
        public Builder resolverEndpointId(String var1);

        public Builder name(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

