/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ResolverEndpointDirection {
    INBOUND("INBOUND"),
    OUTBOUND("OUTBOUND"),
    INBOUND_DELEGATION("INBOUND_DELEGATION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ResolverEndpointDirection> VALUE_MAP;
    private final String value;

    private ResolverEndpointDirection(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResolverEndpointDirection fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResolverEndpointDirection> knownValues() {
        EnumSet<ResolverEndpointDirection> knownValues = EnumSet.allOf(ResolverEndpointDirection.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ResolverEndpointDirection.class, ResolverEndpointDirection::toString);
    }
}

