/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53resolver.Route53ResolverAsyncClient;
import software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointsRequest;
import software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointsResponse;

public class ListResolverEndpointsPublisher
implements SdkPublisher<ListResolverEndpointsResponse> {
    private final Route53ResolverAsyncClient client;
    private final ListResolverEndpointsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListResolverEndpointsPublisher(Route53ResolverAsyncClient client, ListResolverEndpointsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListResolverEndpointsPublisher(Route53ResolverAsyncClient client, ListResolverEndpointsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListResolverEndpointsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListResolverEndpointsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final ListResolverEndpointsPublisher resume(ListResolverEndpointsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListResolverEndpointsPublisher(this.client, (ListResolverEndpointsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListResolverEndpointsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListResolverEndpointsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListResolverEndpointsResponseFetcher
    implements AsyncPageFetcher<ListResolverEndpointsResponse> {
        private ListResolverEndpointsResponseFetcher() {
        }

        public boolean hasNextPage(ListResolverEndpointsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListResolverEndpointsResponse> nextPage(ListResolverEndpointsResponse previousPage) {
            if (previousPage == null) {
                return ListResolverEndpointsPublisher.this.client.listResolverEndpoints(ListResolverEndpointsPublisher.this.firstRequest);
            }
            return ListResolverEndpointsPublisher.this.client.listResolverEndpoints((ListResolverEndpointsRequest)((Object)ListResolverEndpointsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

