/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53resolver.model.Protocol;
import software.amazon.awssdk.services.route53resolver.model.ProtocolListCopier;
import software.amazon.awssdk.services.route53resolver.model.ResolverEndpointDirection;
import software.amazon.awssdk.services.route53resolver.model.ResolverEndpointStatus;
import software.amazon.awssdk.services.route53resolver.model.ResolverEndpointType;
import software.amazon.awssdk.services.route53resolver.model.SecurityGroupIdsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResolverEndpoint
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResolverEndpoint> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(ResolverEndpoint.getter(ResolverEndpoint::id)).setter(ResolverEndpoint.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> CREATOR_REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatorRequestId").getter(ResolverEndpoint.getter(ResolverEndpoint::creatorRequestId)).setter(ResolverEndpoint.setter(Builder::creatorRequestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatorRequestId").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(ResolverEndpoint.getter(ResolverEndpoint::arn)).setter(ResolverEndpoint.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ResolverEndpoint.getter(ResolverEndpoint::name)).setter(ResolverEndpoint.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroupIds").getter(ResolverEndpoint.getter(ResolverEndpoint::securityGroupIds)).setter(ResolverEndpoint.setter(Builder::securityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DIRECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Direction").getter(ResolverEndpoint.getter(ResolverEndpoint::directionAsString)).setter(ResolverEndpoint.setter(Builder::direction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Direction").build()}).build();
    private static final SdkField<Integer> IP_ADDRESS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("IpAddressCount").getter(ResolverEndpoint.getter(ResolverEndpoint::ipAddressCount)).setter(ResolverEndpoint.setter(Builder::ipAddressCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddressCount").build()}).build();
    private static final SdkField<String> HOST_VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HostVPCId").getter(ResolverEndpoint.getter(ResolverEndpoint::hostVPCId)).setter(ResolverEndpoint.setter(Builder::hostVPCId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostVPCId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ResolverEndpoint.getter(ResolverEndpoint::statusAsString)).setter(ResolverEndpoint.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(ResolverEndpoint.getter(ResolverEndpoint::statusMessage)).setter(ResolverEndpoint.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final SdkField<String> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreationTime").getter(ResolverEndpoint.getter(ResolverEndpoint::creationTime)).setter(ResolverEndpoint.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<String> MODIFICATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModificationTime").getter(ResolverEndpoint.getter(ResolverEndpoint::modificationTime)).setter(ResolverEndpoint.setter(Builder::modificationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModificationTime").build()}).build();
    private static final SdkField<String> OUTPOST_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutpostArn").getter(ResolverEndpoint.getter(ResolverEndpoint::outpostArn)).setter(ResolverEndpoint.setter(Builder::outpostArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostArn").build()}).build();
    private static final SdkField<String> PREFERRED_INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreferredInstanceType").getter(ResolverEndpoint.getter(ResolverEndpoint::preferredInstanceType)).setter(ResolverEndpoint.setter(Builder::preferredInstanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredInstanceType").build()}).build();
    private static final SdkField<String> RESOLVER_ENDPOINT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResolverEndpointType").getter(ResolverEndpoint.getter(ResolverEndpoint::resolverEndpointTypeAsString)).setter(ResolverEndpoint.setter(Builder::resolverEndpointType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResolverEndpointType").build()}).build();
    private static final SdkField<List<String>> PROTOCOLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Protocols").getter(ResolverEndpoint.getter(ResolverEndpoint::protocolsAsStrings)).setter(ResolverEndpoint.setter(Builder::protocolsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocols").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, CREATOR_REQUEST_ID_FIELD, ARN_FIELD, NAME_FIELD, SECURITY_GROUP_IDS_FIELD, DIRECTION_FIELD, IP_ADDRESS_COUNT_FIELD, HOST_VPC_ID_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, CREATION_TIME_FIELD, MODIFICATION_TIME_FIELD, OUTPOST_ARN_FIELD, PREFERRED_INSTANCE_TYPE_FIELD, RESOLVER_ENDPOINT_TYPE_FIELD, PROTOCOLS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ResolverEndpoint.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String creatorRequestId;
    private final String arn;
    private final String name;
    private final List<String> securityGroupIds;
    private final String direction;
    private final Integer ipAddressCount;
    private final String hostVPCId;
    private final String status;
    private final String statusMessage;
    private final String creationTime;
    private final String modificationTime;
    private final String outpostArn;
    private final String preferredInstanceType;
    private final String resolverEndpointType;
    private final List<String> protocols;

    private ResolverEndpoint(BuilderImpl builder) {
        this.id = builder.id;
        this.creatorRequestId = builder.creatorRequestId;
        this.arn = builder.arn;
        this.name = builder.name;
        this.securityGroupIds = builder.securityGroupIds;
        this.direction = builder.direction;
        this.ipAddressCount = builder.ipAddressCount;
        this.hostVPCId = builder.hostVPCId;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.creationTime = builder.creationTime;
        this.modificationTime = builder.modificationTime;
        this.outpostArn = builder.outpostArn;
        this.preferredInstanceType = builder.preferredInstanceType;
        this.resolverEndpointType = builder.resolverEndpointType;
        this.protocols = builder.protocols;
    }

    public final String id() {
        return this.id;
    }

    public final String creatorRequestId() {
        return this.creatorRequestId;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasSecurityGroupIds() {
        return this.securityGroupIds != null && !(this.securityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public final ResolverEndpointDirection direction() {
        return ResolverEndpointDirection.fromValue(this.direction);
    }

    public final String directionAsString() {
        return this.direction;
    }

    public final Integer ipAddressCount() {
        return this.ipAddressCount;
    }

    public final String hostVPCId() {
        return this.hostVPCId;
    }

    public final ResolverEndpointStatus status() {
        return ResolverEndpointStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final String creationTime() {
        return this.creationTime;
    }

    public final String modificationTime() {
        return this.modificationTime;
    }

    public final String outpostArn() {
        return this.outpostArn;
    }

    public final String preferredInstanceType() {
        return this.preferredInstanceType;
    }

    public final ResolverEndpointType resolverEndpointType() {
        return ResolverEndpointType.fromValue(this.resolverEndpointType);
    }

    public final String resolverEndpointTypeAsString() {
        return this.resolverEndpointType;
    }

    public final List<Protocol> protocols() {
        return ProtocolListCopier.copyStringToEnum(this.protocols);
    }

    public final boolean hasProtocols() {
        return this.protocols != null && !(this.protocols instanceof SdkAutoConstructList);
    }

    public final List<String> protocolsAsStrings() {
        return this.protocols;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.creatorRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroupIds() ? this.securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.directionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddressCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostVPCId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.modificationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.outpostArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredInstanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.resolverEndpointTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProtocols() ? this.protocolsAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResolverEndpoint)) {
            return false;
        }
        ResolverEndpoint other = (ResolverEndpoint)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.creatorRequestId(), other.creatorRequestId()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && this.hasSecurityGroupIds() == other.hasSecurityGroupIds() && Objects.equals(this.securityGroupIds(), other.securityGroupIds()) && Objects.equals(this.directionAsString(), other.directionAsString()) && Objects.equals(this.ipAddressCount(), other.ipAddressCount()) && Objects.equals(this.hostVPCId(), other.hostVPCId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.modificationTime(), other.modificationTime()) && Objects.equals(this.outpostArn(), other.outpostArn()) && Objects.equals(this.preferredInstanceType(), other.preferredInstanceType()) && Objects.equals(this.resolverEndpointTypeAsString(), other.resolverEndpointTypeAsString()) && this.hasProtocols() == other.hasProtocols() && Objects.equals(this.protocolsAsStrings(), other.protocolsAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"ResolverEndpoint").add("Id", (Object)this.id()).add("CreatorRequestId", (Object)this.creatorRequestId()).add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("SecurityGroupIds", this.hasSecurityGroupIds() ? this.securityGroupIds() : null).add("Direction", (Object)this.directionAsString()).add("IpAddressCount", (Object)this.ipAddressCount()).add("HostVPCId", (Object)this.hostVPCId()).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).add("CreationTime", (Object)this.creationTime()).add("ModificationTime", (Object)this.modificationTime()).add("OutpostArn", (Object)this.outpostArn()).add("PreferredInstanceType", (Object)this.preferredInstanceType()).add("ResolverEndpointType", (Object)this.resolverEndpointTypeAsString()).add("Protocols", this.hasProtocols() ? this.protocolsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "CreatorRequestId": {
                return Optional.ofNullable(clazz.cast(this.creatorRequestId()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "SecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIds()));
            }
            case "Direction": {
                return Optional.ofNullable(clazz.cast(this.directionAsString()));
            }
            case "IpAddressCount": {
                return Optional.ofNullable(clazz.cast(this.ipAddressCount()));
            }
            case "HostVPCId": {
                return Optional.ofNullable(clazz.cast(this.hostVPCId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "ModificationTime": {
                return Optional.ofNullable(clazz.cast(this.modificationTime()));
            }
            case "OutpostArn": {
                return Optional.ofNullable(clazz.cast(this.outpostArn()));
            }
            case "PreferredInstanceType": {
                return Optional.ofNullable(clazz.cast(this.preferredInstanceType()));
            }
            case "ResolverEndpointType": {
                return Optional.ofNullable(clazz.cast(this.resolverEndpointTypeAsString()));
            }
            case "Protocols": {
                return Optional.ofNullable(clazz.cast(this.protocolsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Id", ID_FIELD);
        map.put("CreatorRequestId", CREATOR_REQUEST_ID_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("SecurityGroupIds", SECURITY_GROUP_IDS_FIELD);
        map.put("Direction", DIRECTION_FIELD);
        map.put("IpAddressCount", IP_ADDRESS_COUNT_FIELD);
        map.put("HostVPCId", HOST_VPC_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("ModificationTime", MODIFICATION_TIME_FIELD);
        map.put("OutpostArn", OUTPOST_ARN_FIELD);
        map.put("PreferredInstanceType", PREFERRED_INSTANCE_TYPE_FIELD);
        map.put("ResolverEndpointType", RESOLVER_ENDPOINT_TYPE_FIELD);
        map.put("Protocols", PROTOCOLS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResolverEndpoint, T> g) {
        return obj -> g.apply((ResolverEndpoint)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String creatorRequestId;
        private String arn;
        private String name;
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private String direction;
        private Integer ipAddressCount;
        private String hostVPCId;
        private String status;
        private String statusMessage;
        private String creationTime;
        private String modificationTime;
        private String outpostArn;
        private String preferredInstanceType;
        private String resolverEndpointType;
        private List<String> protocols = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResolverEndpoint model) {
            this.id(model.id);
            this.creatorRequestId(model.creatorRequestId);
            this.arn(model.arn);
            this.name(model.name);
            this.securityGroupIds(model.securityGroupIds);
            this.direction(model.direction);
            this.ipAddressCount(model.ipAddressCount);
            this.hostVPCId(model.hostVPCId);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
            this.creationTime(model.creationTime);
            this.modificationTime(model.modificationTime);
            this.outpostArn(model.outpostArn);
            this.preferredInstanceType(model.preferredInstanceType);
            this.resolverEndpointType(model.resolverEndpointType);
            this.protocolsWithStrings(model.protocols);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getCreatorRequestId() {
            return this.creatorRequestId;
        }

        public final void setCreatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
        }

        @Override
        public final Builder creatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (this.securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final String getDirection() {
            return this.direction;
        }

        public final void setDirection(String direction) {
            this.direction = direction;
        }

        @Override
        public final Builder direction(String direction) {
            this.direction = direction;
            return this;
        }

        @Override
        public final Builder direction(ResolverEndpointDirection direction) {
            this.direction(direction == null ? null : direction.toString());
            return this;
        }

        public final Integer getIpAddressCount() {
            return this.ipAddressCount;
        }

        public final void setIpAddressCount(Integer ipAddressCount) {
            this.ipAddressCount = ipAddressCount;
        }

        @Override
        public final Builder ipAddressCount(Integer ipAddressCount) {
            this.ipAddressCount = ipAddressCount;
            return this;
        }

        public final String getHostVPCId() {
            return this.hostVPCId;
        }

        public final void setHostVPCId(String hostVPCId) {
            this.hostVPCId = hostVPCId;
        }

        @Override
        public final Builder hostVPCId(String hostVPCId) {
            this.hostVPCId = hostVPCId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ResolverEndpointStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(String creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(String creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getModificationTime() {
            return this.modificationTime;
        }

        public final void setModificationTime(String modificationTime) {
            this.modificationTime = modificationTime;
        }

        @Override
        public final Builder modificationTime(String modificationTime) {
            this.modificationTime = modificationTime;
            return this;
        }

        public final String getOutpostArn() {
            return this.outpostArn;
        }

        public final void setOutpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
        }

        @Override
        public final Builder outpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
            return this;
        }

        public final String getPreferredInstanceType() {
            return this.preferredInstanceType;
        }

        public final void setPreferredInstanceType(String preferredInstanceType) {
            this.preferredInstanceType = preferredInstanceType;
        }

        @Override
        public final Builder preferredInstanceType(String preferredInstanceType) {
            this.preferredInstanceType = preferredInstanceType;
            return this;
        }

        public final String getResolverEndpointType() {
            return this.resolverEndpointType;
        }

        public final void setResolverEndpointType(String resolverEndpointType) {
            this.resolverEndpointType = resolverEndpointType;
        }

        @Override
        public final Builder resolverEndpointType(String resolverEndpointType) {
            this.resolverEndpointType = resolverEndpointType;
            return this;
        }

        @Override
        public final Builder resolverEndpointType(ResolverEndpointType resolverEndpointType) {
            this.resolverEndpointType(resolverEndpointType == null ? null : resolverEndpointType.toString());
            return this;
        }

        public final Collection<String> getProtocols() {
            if (this.protocols instanceof SdkAutoConstructList) {
                return null;
            }
            return this.protocols;
        }

        public final void setProtocols(Collection<String> protocols) {
            this.protocols = ProtocolListCopier.copy(protocols);
        }

        @Override
        public final Builder protocolsWithStrings(Collection<String> protocols) {
            this.protocols = ProtocolListCopier.copy(protocols);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protocolsWithStrings(String ... protocols) {
            this.protocolsWithStrings(Arrays.asList(protocols));
            return this;
        }

        @Override
        public final Builder protocols(Collection<Protocol> protocols) {
            this.protocols = ProtocolListCopier.copyEnumToString(protocols);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protocols(Protocol ... protocols) {
            this.protocols(Arrays.asList(protocols));
            return this;
        }

        public ResolverEndpoint build() {
            return new ResolverEndpoint(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResolverEndpoint> {
        public Builder id(String var1);

        public Builder creatorRequestId(String var1);

        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder direction(String var1);

        public Builder direction(ResolverEndpointDirection var1);

        public Builder ipAddressCount(Integer var1);

        public Builder hostVPCId(String var1);

        public Builder status(String var1);

        public Builder status(ResolverEndpointStatus var1);

        public Builder statusMessage(String var1);

        public Builder creationTime(String var1);

        public Builder modificationTime(String var1);

        public Builder outpostArn(String var1);

        public Builder preferredInstanceType(String var1);

        public Builder resolverEndpointType(String var1);

        public Builder resolverEndpointType(ResolverEndpointType var1);

        public Builder protocolsWithStrings(Collection<String> var1);

        public Builder protocolsWithStrings(String ... var1);

        public Builder protocols(Collection<Protocol> var1);

        public Builder protocols(Protocol ... var1);
    }
}

